/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.List;
import proguard.ClassSpecificationVisitorFactory;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.KeepMarker;

public class DescriptorKeepChecker
extends SimplifiedVisitor
implements MemberVisitor,
ClassVisitor {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final WarningPrinter notePrinter;
    private Clazz referencingClass;
    private Member referencingMember;
    private boolean isField;

    public DescriptorKeepChecker(ClassPool programClassPool, ClassPool libraryClassPool, WarningPrinter notePrinter) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.notePrinter = notePrinter;
    }

    public void checkClassSpecifications(List keepSpecifications) {
        this.programClassPool.classesAccept(new ClassCleaner());
        this.libraryClassPool.classesAccept(new ClassCleaner());
        KeepMarker keepMarker = new KeepMarker();
        ClassPoolVisitor classPoolvisitor = ClassSpecificationVisitorFactory.createClassPoolVisitor(keepSpecifications, keepMarker, keepMarker, false, true, true);
        this.programClassPool.accept(classPoolvisitor);
        this.libraryClassPool.accept(classPoolvisitor);
        this.programClassPool.classesAccept(new AllMemberVisitor(this));
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (KeepMarker.isKept(programField)) {
            this.referencingClass = programClass;
            this.referencingMember = programField;
            this.isField = true;
        }
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (KeepMarker.isKept(programMethod)) {
            this.referencingClass = programClass;
            this.referencingMember = programMethod;
            this.isField = false;
            Clazz[] referencedClasses = programMethod.referencedClasses;
            if (referencedClasses != null) {
                for (int index = 0; index < referencedClasses.length - 1; ++index) {
                    if (referencedClasses[index] == null) continue;
                    referencedClasses[index].accept(this);
                }
            }
        }
    }

    public void visitProgramClass(ProgramClass programClass) {
        if (!KeepMarker.isKept(programClass)) {
            this.notePrinter.print(this.referencingClass.getName(), programClass.getName(), "Note: the configuration keeps the entry point '" + ClassUtil.externalClassName(this.referencingClass.getName()) + " { " + (this.isField ? ClassUtil.externalFullFieldDescription(0, this.referencingMember.getName(this.referencingClass), this.referencingMember.getDescriptor(this.referencingClass)) : ClassUtil.externalFullMethodDescription(this.referencingClass.getName(), 0, this.referencingMember.getName(this.referencingClass), this.referencingMember.getDescriptor(this.referencingClass))) + "; }', but not the descriptor class '" + ClassUtil.externalClassName(programClass.getName()) + "'");
        }
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
    }
}

