/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.File;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.Configuration;

public class UpToDateChecker {
    private final Configuration configuration;

    public UpToDateChecker(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean check() {
        boolean outputUpToDate;
        long lastModified;
        ClassPathEntry classPathEntry;
        int index;
        long inputLastModified = this.configuration.lastModified;
        long outputLastModified = Long.MAX_VALUE;
        ClassPath programJars = this.configuration.programJars;
        ClassPath libraryJars = this.configuration.libraryJars;
        if (programJars != null) {
            for (index = 0; index < programJars.size() && inputLastModified < outputLastModified; ++index) {
                classPathEntry = programJars.get(index);
                if (classPathEntry.isOutput()) {
                    lastModified = this.lastModified(classPathEntry.getFile(), true);
                    if (outputLastModified <= lastModified) continue;
                    outputLastModified = lastModified;
                    continue;
                }
                lastModified = this.lastModified(classPathEntry.getFile(), false);
                if (inputLastModified >= lastModified) continue;
                inputLastModified = lastModified;
            }
        }
        if (libraryJars != null) {
            for (index = 0; index < libraryJars.size() && inputLastModified < outputLastModified; ++index) {
                classPathEntry = libraryJars.get(index);
                lastModified = this.lastModified(classPathEntry.getFile(), false);
                if (inputLastModified >= lastModified) continue;
                inputLastModified = lastModified;
            }
        }
        boolean bl = outputUpToDate = inputLastModified < outputLastModified;
        if (outputUpToDate) {
            System.out.println("The output is up to date");
        }
        return outputUpToDate;
    }

    private long lastModified(File file, boolean minimum) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            long lastModified = files.length != 0 && minimum ? Long.MAX_VALUE : 0L;
            for (int index = 0; index < files.length; ++index) {
                long fileLastModified = this.lastModified(files[index], minimum);
                if (!(lastModified < fileLastModified ^ minimum)) continue;
                lastModified = fileLastModified;
            }
            return lastModified;
        }
        return file.lastModified();
    }
}

