/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ConstantValueAttribute;
import proguard.classfile.attribute.DeprecatedAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExceptionsAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.SourceDirAttribute;
import proguard.classfile.attribute.SourceFileAttribute;
import proguard.classfile.attribute.SyntheticAttribute;
import proguard.classfile.attribute.UnknownAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttribute;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.AnnotationAdder;
import proguard.classfile.editor.AttributesEditor;
import proguard.classfile.editor.CodeAttributeComposer;
import proguard.classfile.editor.ConstantAdder;
import proguard.classfile.editor.ElementValueAdder;
import proguard.classfile.editor.ExceptionAdder;
import proguard.classfile.editor.ExceptionInfoAdder;
import proguard.classfile.editor.InstructionAdder;
import proguard.classfile.editor.LineNumberInfoAdder;
import proguard.classfile.editor.LocalVariableInfoAdder;
import proguard.classfile.editor.LocalVariableTypeInfoAdder;
import proguard.classfile.util.SimplifiedVisitor;

public class AttributeAdder
extends SimplifiedVisitor
implements AttributeVisitor {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final int[] EMPTY_INTS = new int[0];
    private static final Attribute[] EMPTY_ATTRIBUTES = new Attribute[0];
    private static final ExceptionInfo[] EMPTY_EXCEPTIONS = new ExceptionInfo[0];
    private final ProgramClass targetClass;
    private final ProgramMember targetMember;
    private final CodeAttribute targetCodeAttribute;
    private final boolean replaceAttributes;
    private final ConstantAdder constantAdder;
    private final AttributesEditor attributesEditor;

    public AttributeAdder(ProgramClass targetClass, boolean replaceAttributes) {
        this(targetClass, null, null, replaceAttributes);
    }

    public AttributeAdder(ProgramClass targetClass, ProgramMember targetMember, boolean replaceAttributes) {
        this(targetClass, targetMember, null, replaceAttributes);
    }

    public AttributeAdder(ProgramClass targetClass, ProgramMember targetMember, CodeAttribute targetCodeAttribute, boolean replaceAttributes) {
        this.targetClass = targetClass;
        this.targetMember = targetMember;
        this.targetCodeAttribute = targetCodeAttribute;
        this.replaceAttributes = replaceAttributes;
        this.constantAdder = new ConstantAdder(targetClass);
        this.attributesEditor = new AttributesEditor(targetClass, targetMember, targetCodeAttribute, replaceAttributes);
    }

    public void visitUnknownAttribute(Clazz clazz, UnknownAttribute unknownAttribute) {
        UnknownAttribute newUnknownAttribute = new UnknownAttribute(this.constantAdder.addConstant(clazz, unknownAttribute.u2attributeNameIndex), unknownAttribute.u4attributeLength, unknownAttribute.info);
        this.attributesEditor.addAttribute(newUnknownAttribute);
    }

    public void visitSourceFileAttribute(Clazz clazz, SourceFileAttribute sourceFileAttribute) {
        SourceFileAttribute newSourceFileAttribute = new SourceFileAttribute(this.constantAdder.addConstant(clazz, sourceFileAttribute.u2attributeNameIndex), this.constantAdder.addConstant(clazz, sourceFileAttribute.u2sourceFileIndex));
        this.attributesEditor.addAttribute(newSourceFileAttribute);
    }

    public void visitSourceDirAttribute(Clazz clazz, SourceDirAttribute sourceDirAttribute) {
        SourceDirAttribute newSourceDirAttribute = new SourceDirAttribute(this.constantAdder.addConstant(clazz, sourceDirAttribute.u2attributeNameIndex), this.constantAdder.addConstant(clazz, sourceDirAttribute.u2sourceDirIndex));
        this.attributesEditor.addAttribute(newSourceDirAttribute);
    }

    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
    }

    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        EnclosingMethodAttribute newEnclosingMethodAttribute = new EnclosingMethodAttribute(this.constantAdder.addConstant(clazz, enclosingMethodAttribute.u2attributeNameIndex), this.constantAdder.addConstant(clazz, enclosingMethodAttribute.u2classIndex), enclosingMethodAttribute.u2nameAndTypeIndex == 0 ? 0 : this.constantAdder.addConstant(clazz, enclosingMethodAttribute.u2nameAndTypeIndex));
        newEnclosingMethodAttribute.referencedClass = enclosingMethodAttribute.referencedClass;
        newEnclosingMethodAttribute.referencedMethod = enclosingMethodAttribute.referencedMethod;
        this.attributesEditor.addAttribute(newEnclosingMethodAttribute);
    }

    public void visitDeprecatedAttribute(Clazz clazz, DeprecatedAttribute deprecatedAttribute) {
        DeprecatedAttribute newDeprecatedAttribute = new DeprecatedAttribute(this.constantAdder.addConstant(clazz, deprecatedAttribute.u2attributeNameIndex));
        this.attributesEditor.addAttribute(newDeprecatedAttribute);
    }

    public void visitSyntheticAttribute(Clazz clazz, SyntheticAttribute syntheticAttribute) {
        SyntheticAttribute newSyntheticAttribute = new SyntheticAttribute(this.constantAdder.addConstant(clazz, syntheticAttribute.u2attributeNameIndex));
        this.attributesEditor.addAttribute(newSyntheticAttribute);
    }

    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        SignatureAttribute newSignatureAttribute = new SignatureAttribute(this.constantAdder.addConstant(clazz, signatureAttribute.u2attributeNameIndex), this.constantAdder.addConstant(clazz, signatureAttribute.u2signatureIndex));
        newSignatureAttribute.referencedClasses = signatureAttribute.referencedClasses;
        this.attributesEditor.addAttribute(newSignatureAttribute);
    }

    public void visitConstantValueAttribute(Clazz clazz, Field field, ConstantValueAttribute constantValueAttribute) {
        ConstantValueAttribute newConstantValueAttribute = new ConstantValueAttribute(this.constantAdder.addConstant(clazz, constantValueAttribute.u2attributeNameIndex), this.constantAdder.addConstant(clazz, constantValueAttribute.u2constantValueIndex));
        this.attributesEditor.addAttribute(newConstantValueAttribute);
    }

    public void visitExceptionsAttribute(Clazz clazz, Method method, ExceptionsAttribute exceptionsAttribute) {
        ExceptionsAttribute newExceptionsAttribute = new ExceptionsAttribute(this.constantAdder.addConstant(clazz, exceptionsAttribute.u2attributeNameIndex), 0, exceptionsAttribute.u2exceptionIndexTableLength > 0 ? new int[exceptionsAttribute.u2exceptionIndexTableLength] : EMPTY_INTS);
        exceptionsAttribute.exceptionEntriesAccept((ProgramClass)clazz, new ExceptionAdder(this.targetClass, newExceptionsAttribute));
        this.attributesEditor.addAttribute(newExceptionsAttribute);
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        CodeAttribute newCodeAttribute = new CodeAttribute(this.constantAdder.addConstant(clazz, codeAttribute.u2attributeNameIndex), codeAttribute.u2maxStack, codeAttribute.u2maxLocals, 0, EMPTY_BYTES, 0, codeAttribute.u2exceptionTableLength > 0 ? new ExceptionInfo[codeAttribute.u2exceptionTableLength] : EMPTY_EXCEPTIONS, 0, codeAttribute.u2attributesCount > 0 ? new Attribute[codeAttribute.u2attributesCount] : EMPTY_ATTRIBUTES);
        CodeAttributeComposer codeAttributeComposer = new CodeAttributeComposer();
        codeAttributeComposer.beginCodeFragment(codeAttribute.u4codeLength + 32);
        codeAttribute.instructionsAccept(clazz, method, new InstructionAdder(this.targetClass, codeAttributeComposer));
        codeAttributeComposer.appendLabel(codeAttribute.u4codeLength);
        codeAttribute.exceptionsAccept(clazz, method, new ExceptionInfoAdder(this.targetClass, codeAttributeComposer));
        codeAttributeComposer.endCodeFragment();
        codeAttribute.attributesAccept(clazz, method, new AttributeAdder(this.targetClass, this.targetMember, newCodeAttribute, this.replaceAttributes));
        codeAttributeComposer.visitCodeAttribute(this.targetClass, (Method)((Object)this.targetMember), newCodeAttribute);
        this.attributesEditor.addAttribute(newCodeAttribute);
    }

    public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
    }

    public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
    }

    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        LineNumberTableAttribute newLineNumberTableAttribute = new LineNumberTableAttribute(this.constantAdder.addConstant(clazz, lineNumberTableAttribute.u2attributeNameIndex), 0, new LineNumberInfo[lineNumberTableAttribute.u2lineNumberTableLength]);
        lineNumberTableAttribute.lineNumbersAccept(clazz, method, codeAttribute, new LineNumberInfoAdder(newLineNumberTableAttribute));
        this.attributesEditor.addAttribute(newLineNumberTableAttribute);
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        LocalVariableTableAttribute newLocalVariableTableAttribute = new LocalVariableTableAttribute(this.constantAdder.addConstant(clazz, localVariableTableAttribute.u2attributeNameIndex), 0, new LocalVariableInfo[localVariableTableAttribute.u2localVariableTableLength]);
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, new LocalVariableInfoAdder(this.targetClass, newLocalVariableTableAttribute));
        this.attributesEditor.addAttribute(newLocalVariableTableAttribute);
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        LocalVariableTypeTableAttribute newLocalVariableTypeTableAttribute = new LocalVariableTypeTableAttribute(this.constantAdder.addConstant(clazz, localVariableTypeTableAttribute.u2attributeNameIndex), 0, new LocalVariableTypeInfo[localVariableTypeTableAttribute.u2localVariableTypeTableLength]);
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, new LocalVariableTypeInfoAdder(this.targetClass, newLocalVariableTypeTableAttribute));
        this.attributesEditor.addAttribute(newLocalVariableTypeTableAttribute);
    }

    public void visitRuntimeVisibleAnnotationsAttribute(Clazz clazz, RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute) {
        RuntimeVisibleAnnotationsAttribute newAnnotationsAttribute = new RuntimeVisibleAnnotationsAttribute(this.constantAdder.addConstant(clazz, runtimeVisibleAnnotationsAttribute.u2attributeNameIndex), 0, new Annotation[runtimeVisibleAnnotationsAttribute.u2annotationsCount]);
        runtimeVisibleAnnotationsAttribute.annotationsAccept(clazz, new AnnotationAdder(this.targetClass, newAnnotationsAttribute));
        this.attributesEditor.addAttribute(newAnnotationsAttribute);
    }

    public void visitRuntimeInvisibleAnnotationsAttribute(Clazz clazz, RuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute) {
        RuntimeInvisibleAnnotationsAttribute newAnnotationsAttribute = new RuntimeInvisibleAnnotationsAttribute(this.constantAdder.addConstant(clazz, runtimeInvisibleAnnotationsAttribute.u2attributeNameIndex), 0, new Annotation[runtimeInvisibleAnnotationsAttribute.u2annotationsCount]);
        runtimeInvisibleAnnotationsAttribute.annotationsAccept(clazz, new AnnotationAdder(this.targetClass, newAnnotationsAttribute));
        this.attributesEditor.addAttribute(newAnnotationsAttribute);
    }

    public void visitRuntimeVisibleParameterAnnotationsAttribute(Clazz clazz, Method method, RuntimeVisibleParameterAnnotationsAttribute runtimeVisibleParameterAnnotationsAttribute) {
        RuntimeVisibleParameterAnnotationsAttribute newParameterAnnotationsAttribute = new RuntimeVisibleParameterAnnotationsAttribute(this.constantAdder.addConstant(clazz, runtimeVisibleParameterAnnotationsAttribute.u2attributeNameIndex), 0, new int[runtimeVisibleParameterAnnotationsAttribute.u2parametersCount], new Annotation[runtimeVisibleParameterAnnotationsAttribute.u2parametersCount][]);
        runtimeVisibleParameterAnnotationsAttribute.annotationsAccept(clazz, method, new AnnotationAdder(this.targetClass, newParameterAnnotationsAttribute));
        this.attributesEditor.addAttribute(newParameterAnnotationsAttribute);
    }

    public void visitRuntimeInvisibleParameterAnnotationsAttribute(Clazz clazz, Method method, RuntimeInvisibleParameterAnnotationsAttribute runtimeInvisibleParameterAnnotationsAttribute) {
        RuntimeInvisibleParameterAnnotationsAttribute newParameterAnnotationsAttribute = new RuntimeInvisibleParameterAnnotationsAttribute(this.constantAdder.addConstant(clazz, runtimeInvisibleParameterAnnotationsAttribute.u2attributeNameIndex), 0, new int[runtimeInvisibleParameterAnnotationsAttribute.u2parametersCount], new Annotation[runtimeInvisibleParameterAnnotationsAttribute.u2parametersCount][]);
        runtimeInvisibleParameterAnnotationsAttribute.annotationsAccept(clazz, method, new AnnotationAdder(this.targetClass, newParameterAnnotationsAttribute));
        this.attributesEditor.addAttribute(newParameterAnnotationsAttribute);
    }

    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        AnnotationDefaultAttribute newAnnotationDefaultAttribute = new AnnotationDefaultAttribute(this.constantAdder.addConstant(clazz, annotationDefaultAttribute.u2attributeNameIndex), null);
        annotationDefaultAttribute.defaultValueAccept(clazz, new ElementValueAdder(this.targetClass, newAnnotationDefaultAttribute, false));
        this.attributesEditor.addAttribute(newAnnotationDefaultAttribute);
    }
}

