/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.FilterReader;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import proguard.classfile.ClassPool;
import proguard.io.DataEntryRewriter;
import proguard.io.DataEntryWriter;

public class ManifestRewriter
extends DataEntryRewriter {
    public ManifestRewriter(ClassPool classPool, DataEntryWriter dataEntryWriter) {
        super(classPool, dataEntryWriter);
    }

    protected void copyData(Reader reader, Writer writer) throws IOException {
        super.copyData(new SplitLineReader(reader), new SplitLineWriter(writer));
    }

    private static class SplitLineWriter
    extends FilterWriter {
        private int counter = 0;

        public SplitLineWriter(Writer writer) {
            super(writer);
        }

        public void write(int c) throws IOException {
            if (c == 10) {
                this.counter = 0;
            } else if (this.counter == 70) {
                super.write(10);
                super.write(32);
                this.counter = 2;
            } else {
                ++this.counter;
            }
            super.write(c);
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            for (int count = 0; count < len; ++count) {
                this.write(cbuf[off + count]);
            }
        }

        public void write(String str, int off, int len) throws IOException {
            this.write(str.toCharArray(), off, len);
        }
    }

    private static class SplitLineReader
    extends FilterReader {
        private char[] buffer = new char[2];
        private int bufferIndex = 0;
        private int bufferSize = 0;

        public SplitLineReader(Reader reader) {
            super(reader);
        }

        public int read() throws IOException {
            while (this.bufferIndex >= this.bufferSize) {
                int c1 = super.read();
                if (c1 != 10 && c1 != 13) {
                    return c1;
                }
                this.bufferIndex = 0;
                this.bufferSize = 0;
                this.buffer[this.bufferSize++] = 10;
                int c2 = super.read();
                if (c2 == 32) {
                    this.bufferSize = 0;
                    continue;
                }
                if (c1 != 13 || c2 != 10) {
                    this.buffer[this.bufferSize++] = (char)c2;
                    continue;
                }
                int c3 = super.read();
                if (c3 == 32) {
                    this.bufferSize = 0;
                    continue;
                }
                this.buffer[this.bufferSize++] = (char)c3;
            }
            return this.buffer[this.bufferIndex++];
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            int c;
            int count = 0;
            while (count < len && (c = this.read()) != -1) {
                cbuf[off + count++] = (char)c;
            }
            return count;
        }

        public long skip(long n) throws IOException {
            int c;
            int count = 0;
            while ((long)count < n && (c = this.read()) != -1) {
                ++count;
            }
            return count;
        }
    }
}

