/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import proguard.obfuscate.NameFactory;
import proguard.obfuscate.SimpleNameFactory;

public class DictionaryNameFactory
implements NameFactory {
    private static final char COMMENT_CHARACTER = '#';
    private final List names;
    private final NameFactory nameFactory;
    private int index = 0;

    public DictionaryNameFactory(File file, NameFactory nameFactory) throws IOException {
        this.names = new ArrayList();
        this.nameFactory = nameFactory;
        FileReader reader = new FileReader(file);
        try {
            StringBuffer buffer = new StringBuffer();
            while (true) {
                int c;
                if ((c = ((Reader)reader).read()) != -1 && (buffer.length() == 0 ? Character.isJavaIdentifierStart((char)c) : Character.isJavaIdentifierPart((char)c))) {
                    buffer.append((char)c);
                    continue;
                }
                if (buffer.length() > 0) {
                    String name = buffer.toString();
                    if (!this.names.contains(name)) {
                        this.names.add(name);
                    }
                    buffer.setLength(0);
                }
                if (c == 35) {
                    while ((c = ((Reader)reader).read()) != -1 && c != 10 && c != 13) {
                    }
                }
                if (c != -1) continue;
                return;
            }
        }
        finally {
            ((Reader)reader).close();
        }
    }

    public DictionaryNameFactory(DictionaryNameFactory dictionaryNameFactory, NameFactory nameFactory) {
        this.names = dictionaryNameFactory.names;
        this.nameFactory = nameFactory;
    }

    public void reset() {
        this.index = 0;
        this.nameFactory.reset();
    }

    public String nextName() {
        String name;
        if (this.index < this.names.size()) {
            name = (String)this.names.get(this.index++);
        } else {
            while (this.names.contains(name = this.nameFactory.nextName())) {
            }
        }
        return name;
    }

    public static void main(String[] args) {
        try {
            DictionaryNameFactory factory = new DictionaryNameFactory(new File(args[0]), (NameFactory)new SimpleNameFactory());
            for (int counter = 0; counter < 50; ++counter) {
                System.out.println("[" + factory.nextName() + "]");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

