/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.util.HashMap;
import java.util.Map;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryMember;
import proguard.classfile.Member;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.util.MethodLinker;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.NameFactory;

public class MemberObfuscator
extends SimplifiedVisitor
implements MemberVisitor {
    private final boolean allowAggressiveOverloading;
    private final NameFactory nameFactory;
    private final Map descriptorMap;

    public MemberObfuscator(boolean allowAggressiveOverloading, NameFactory nameFactory, Map descriptorMap) {
        this.allowAggressiveOverloading = allowAggressiveOverloading;
        this.nameFactory = nameFactory;
        this.descriptorMap = descriptorMap;
    }

    public void visitAnyMember(Clazz clazz, Member member) {
        String name = member.getName(clazz);
        if (name.equals("<clinit>") || name.equals("<init>")) {
            return;
        }
        String descriptor = member.getDescriptor(clazz);
        if (!this.allowAggressiveOverloading) {
            descriptor = descriptor.substring(0, descriptor.indexOf(41) + 1);
        }
        Map nameMap = MemberObfuscator.retrieveNameMap(this.descriptorMap, descriptor);
        String newName = MemberObfuscator.newMemberName(member);
        if (newName == null) {
            this.nameFactory.reset();
            while (nameMap.containsKey(newName = this.nameFactory.nextName())) {
            }
            nameMap.put(newName, name);
            MemberObfuscator.setNewMemberName(member, newName);
        }
    }

    static Map retrieveNameMap(Map descriptorMap, String descriptor) {
        HashMap nameMap = (HashMap)descriptorMap.get(descriptor);
        if (nameMap == null) {
            nameMap = new HashMap();
            descriptorMap.put(descriptor, nameMap);
        }
        return nameMap;
    }

    static void setFixedNewMemberName(Member member, String name) {
        VisitorAccepter lastVisitorAccepter = MethodLinker.lastVisitorAccepter(member);
        if (!(lastVisitorAccepter instanceof LibraryMember) && !(lastVisitorAccepter instanceof MyFixedName)) {
            lastVisitorAccepter.setVisitorInfo(new MyFixedName(name));
        } else {
            lastVisitorAccepter.setVisitorInfo(name);
        }
    }

    static void setNewMemberName(Member member, String name) {
        MethodLinker.lastVisitorAccepter(member).setVisitorInfo(name);
    }

    static boolean hasFixedNewMemberName(Member member) {
        VisitorAccepter lastVisitorAccepter = MethodLinker.lastVisitorAccepter(member);
        return lastVisitorAccepter instanceof LibraryMember || lastVisitorAccepter instanceof MyFixedName;
    }

    static String newMemberName(Member member) {
        return (String)MethodLinker.lastVisitorAccepter(member).getVisitorInfo();
    }

    private static class MyFixedName
    implements VisitorAccepter {
        private String newName;

        public MyFixedName(String newName) {
            this.newName = newName;
        }

        public Object getVisitorInfo() {
            return this.newName;
        }

        public void setVisitorInfo(Object visitorInfo) {
            this.newName = (String)visitorInfo;
        }
    }
}

