/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.ConstantPoolRemapper;
import proguard.classfile.visitor.ClassVisitor;
import proguard.obfuscate.Utf8UsageMarker;

public class Utf8Shrinker
implements ClassVisitor {
    private int[] constantIndexMap = new int[256];
    private final ConstantPoolRemapper constantPoolRemapper = new ConstantPoolRemapper();

    public void visitProgramClass(ProgramClass programClass) {
        programClass.u2constantPoolCount = this.shrinkConstantPool(programClass.constantPool, programClass.u2constantPoolCount);
        this.constantPoolRemapper.setConstantIndexMap(this.constantIndexMap);
        this.constantPoolRemapper.visitProgramClass(programClass);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    private int shrinkConstantPool(Constant[] constantPool, int length) {
        int index;
        if (this.constantIndexMap.length < length) {
            this.constantIndexMap = new int[length];
        }
        int counter = 1;
        boolean isUsed = false;
        for (index = 1; index < length; ++index) {
            this.constantIndexMap[index] = counter;
            Constant constant = constantPool[index];
            if (constant != null) {
                boolean bl = isUsed = constant.getTag() != 1 || Utf8UsageMarker.isUsed(constant);
            }
            if (!isUsed) continue;
            constantPool[counter++] = constant;
        }
        for (index = counter; index < length; ++index) {
            constantPool[index] = null;
        }
        return counter;
    }
}

