/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.MethodOptimizationInfo;

public class AccessMethodMarker
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor,
ClassVisitor,
MemberVisitor {
    private Method invokingMethod;

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        this.invokingMethod = method;
        clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        stringConstant.referencedClassAccept(this);
        stringConstant.referencedMemberAccept(this);
    }

    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        clazz.constantPoolEntryAccept(refConstant.u2classIndex, this);
        refConstant.referencedClassAccept(this);
        refConstant.referencedMemberAccept(this);
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClassAccept(this);
    }

    public void visitAnyClass(Clazz clazz) {
        int accessFlags = clazz.getAccessFlags();
        if ((accessFlags & 1) == 0) {
            AccessMethodMarker.setAccessesPackageCode(this.invokingMethod);
        }
    }

    public void visitAnyMember(Clazz clazz, Member member) {
        int accessFlags = member.getAccessFlags();
        if ((accessFlags & 2) != 0) {
            AccessMethodMarker.setAccessesPrivateCode(this.invokingMethod);
        } else if ((accessFlags & 4) != 0) {
            AccessMethodMarker.setAccessesProtectedCode(this.invokingMethod);
        } else if ((accessFlags & 1) == 0) {
            AccessMethodMarker.setAccessesPackageCode(this.invokingMethod);
        }
    }

    private static void setAccessesPrivateCode(Method method) {
        MethodOptimizationInfo info = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (info != null) {
            info.setAccessesPrivateCode();
        }
    }

    public static boolean accessesPrivateCode(Method method) {
        MethodOptimizationInfo info = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return info == null || info.accessesPrivateCode();
    }

    private static void setAccessesPackageCode(Method method) {
        MethodOptimizationInfo info = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (info != null) {
            info.setAccessesPackageCode();
        }
    }

    public static boolean accessesPackageCode(Method method) {
        MethodOptimizationInfo info = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return info == null || info.accessesPackageCode();
    }

    private static void setAccessesProtectedCode(Method method) {
        MethodOptimizationInfo info = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        if (info != null) {
            info.setAccessesProtectedCode();
        }
    }

    public static boolean accessesProtectedCode(Method method) {
        MethodOptimizationInfo info = MethodOptimizationInfo.getMethodOptimizationInfo(method);
        return info == null || info.accessesProtectedCode();
    }
}

