/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.optimize.info.ClassOptimizationInfo;

public class PackageVisibleMemberInvokingClassMarker
extends SimplifiedVisitor
implements ConstantVisitor {
    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        Member referencedMember;
        Clazz referencedClass = refConstant.referencedClass;
        if (referencedClass != null && (referencedClass.getAccessFlags() & 1) == 0) {
            PackageVisibleMemberInvokingClassMarker.setInvokesPackageVisibleMembers(clazz);
        }
        if ((referencedMember = refConstant.referencedMember) != null && (referencedMember.getAccessFlags() & 3) == 0) {
            PackageVisibleMemberInvokingClassMarker.setInvokesPackageVisibleMembers(clazz);
        }
    }

    private static void setInvokesPackageVisibleMembers(Clazz clazz) {
        ClassOptimizationInfo info = ClassOptimizationInfo.getClassOptimizationInfo(clazz);
        if (info != null) {
            info.setInvokesPackageVisibleMembers();
        }
    }

    public static boolean invokesPackageVisibleMembers(Clazz clazz) {
        ClassOptimizationInfo info = ClassOptimizationInfo.getClassOptimizationInfo(clazz);
        return info == null || info.invokesPackageVisibleMembers();
    }
}

