/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.ProgramClass;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;

public class InterfaceSorter
extends SimplifiedVisitor
implements ClassVisitor {
    public void visitProgramClass(ProgramClass programClass) {
        int[] interfaces = programClass.u2interfaces;
        int interfacesCount = programClass.u2interfacesCount;
        Arrays.sort(interfaces, 0, interfacesCount);
        int newInterfacesCount = 0;
        int previousInterfaceIndex = 0;
        for (int index = 0; index < interfacesCount; ++index) {
            int interfaceIndex = interfaces[index];
            if (interfaceIndex == previousInterfaceIndex) continue;
            interfaces[newInterfacesCount++] = interfaceIndex;
            previousInterfaceIndex = interfaceIndex;
        }
        programClass.u2interfacesCount = newInterfacesCount;
    }
}

