/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import java.util.HashMap;
import java.util.Map;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryMember;
import proguard.classfile.Member;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberVisitor;

public class MethodLinker
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor {
    private final Map memberMap = new HashMap();

    public void visitAnyClass(Clazz clazz) {
        clazz.hierarchyAccept(true, true, true, false, new AllMethodVisitor(new MemberAccessFilter(0, 2, this)));
        this.memberMap.clear();
    }

    public void visitAnyMember(Clazz clazz, Member member) {
        String name = member.getName(clazz);
        String descriptor = member.getDescriptor(clazz);
        if (name.equals("<clinit>") || name.equals("<init>")) {
            return;
        }
        String key = name + ' ' + descriptor;
        Member otherMember = (Member)this.memberMap.get(key);
        if (otherMember == null) {
            Member thisLastMember = MethodLinker.lastMember(member);
            this.memberMap.put(key, thisLastMember);
        } else {
            MethodLinker.link(member, otherMember);
        }
    }

    private static void link(Member member1, Member member2) {
        Member lastMember2;
        Member lastMember1 = MethodLinker.lastMember(member1);
        if (!lastMember1.equals(lastMember2 = MethodLinker.lastMember(member2))) {
            if (lastMember2 instanceof LibraryMember) {
                lastMember1.setVisitorInfo(lastMember2);
            } else {
                lastMember2.setVisitorInfo(lastMember1);
            }
        }
    }

    public static Member lastMember(Member member) {
        Member lastMember = member;
        while (lastMember.getVisitorInfo() != null && lastMember.getVisitorInfo() instanceof Member) {
            lastMember = (Member)lastMember.getVisitorInfo();
        }
        return lastMember;
    }

    public static VisitorAccepter lastVisitorAccepter(VisitorAccepter visitorAccepter) {
        VisitorAccepter lastVisitorAccepter = visitorAccepter;
        while (lastVisitorAccepter.getVisitorInfo() != null && lastVisitorAccepter.getVisitorInfo() instanceof VisitorAccepter) {
            lastVisitorAccepter = (VisitorAccepter)lastVisitorAccepter.getVisitorInfo();
        }
        return lastVisitorAccepter;
    }
}

