/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.StoringInvocationUnit;

public class MemberDescriptorSpecializer
extends SimplifiedVisitor
implements MemberVisitor {
    private static final boolean DEBUG = true;
    private final MemberVisitor extraParameterMemberVisitor;

    public MemberDescriptorSpecializer() {
        this(null);
    }

    public MemberDescriptorSpecializer(MemberVisitor extraParameterMemberVisitor) {
        this.extraParameterMemberVisitor = extraParameterMemberVisitor;
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        Clazz referencedClass;
        Value parameterValue = StoringInvocationUnit.getFieldValue(programField);
        if (parameterValue.computationalType() == 5 && programField.referencedClass != (referencedClass = parameterValue.referenceValue().getReferencedClass())) {
            System.out.println("MemberDescriptorSpecializer: " + programClass.getName() + "." + programField.getName(programClass) + " " + programField.getDescriptor(programClass));
            System.out.println("  " + programField.referencedClass.getName() + " -> " + referencedClass.getName());
            programField.referencedClass = referencedClass;
            if (this.extraParameterMemberVisitor != null) {
                this.extraParameterMemberVisitor.visitProgramField(programClass, programField);
            }
        }
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        int firstParameterIndex = (programMethod.getAccessFlags() & 8) != 0 ? 0 : 1;
        int parameterCount = ClassUtil.internalMethodParameterCount(programMethod.getDescriptor(programClass));
        int classIndex = 0;
        for (int parameterIndex = firstParameterIndex; parameterIndex < parameterCount; ++parameterIndex) {
            Value parameterValue = StoringInvocationUnit.getMethodParameterValue(programMethod, parameterIndex);
            if (parameterValue.computationalType() != 5) continue;
            Clazz referencedClass = parameterValue.referenceValue().getReferencedClass();
            if (programMethod.referencedClasses[classIndex] != referencedClass) {
                System.out.println("MemberDescriptorSpecializer: " + programClass.getName() + "." + programMethod.getName(programClass) + programMethod.getDescriptor(programClass));
                System.out.println("  " + programMethod.referencedClasses[classIndex].getName() + " -> " + referencedClass.getName());
                programMethod.referencedClasses[classIndex] = referencedClass;
                if (this.extraParameterMemberVisitor != null) {
                    this.extraParameterMemberVisitor.visitProgramMethod(programClass, programMethod);
                }
            }
            ++classIndex;
        }
    }
}

