/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.TracedStack;
import proguard.evaluation.TracedVariables;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.info.ParameterUsageMarker;
import proguard.optimize.info.SideEffectInstructionChecker;

public class EvaluationShrinker
extends SimplifiedVisitor
implements AttributeVisitor {
    private static final boolean DEBUG_RESULTS = false;
    private static final boolean DEBUG = false;
    private final InstructionVisitor extraDeletedInstructionVisitor;
    private final InstructionVisitor extraAddedInstructionVisitor;
    private final PartialEvaluator partialEvaluator;
    private final PartialEvaluator simplePartialEvaluator = new PartialEvaluator();
    private final SideEffectInstructionChecker sideEffectInstructionChecker = new SideEffectInstructionChecker(true);
    private final MyUnusedParameterSimplifier unusedParameterSimplifier = new MyUnusedParameterSimplifier();
    private final MyProducerMarker producerMarker = new MyProducerMarker();
    private final MyVariableInitializationMarker variableInitializationMarker = new MyVariableInitializationMarker();
    private final MyStackConsistencyFixer stackConsistencyFixer = new MyStackConsistencyFixer();
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(false);
    private boolean[][] variablesNecessaryAfter = new boolean[1024][64];
    private boolean[][] stacksNecessaryAfter = new boolean[1024][16];
    private boolean[][] stacksSimplifiedBefore = new boolean[1024][16];
    private boolean[] instructionsNecessary = new boolean[1024];
    private int maxMarkedOffset;

    public EvaluationShrinker() {
        this(new PartialEvaluator(), null, null);
    }

    public EvaluationShrinker(PartialEvaluator partialEvaluator, InstructionVisitor extraDeletedInstructionVisitor, InstructionVisitor extraAddedInstructionVisitor) {
        this.partialEvaluator = partialEvaluator;
        this.extraDeletedInstructionVisitor = extraDeletedInstructionVisitor;
        this.extraAddedInstructionVisitor = extraAddedInstructionVisitor;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        try {
            this.visitCodeAttribute0(clazz, method, codeAttribute);
        }
        catch (RuntimeException ex) {
            System.err.println("Unexpected error while shrinking instructions after partial evaluation:");
            System.err.println("  Class       = [" + clazz.getName() + "]");
            System.err.println("  Method      = [" + method.getName(clazz) + method.getDescriptor(clazz) + "]");
            System.err.println("  Exception   = [" + ex.getClass().getName() + "] (" + ex.getMessage() + ")");
            System.err.println("Not optimizing this method");
        }
    }

    public void visitCodeAttribute0(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        Instruction instruction;
        int offset;
        this.initializeNecessary(codeAttribute);
        this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        int codeLength = codeAttribute.u4codeLength;
        this.codeAttributeEditor.reset(codeLength);
        for (int offset2 = 0; offset2 < codeLength; ++offset2) {
            if (!this.partialEvaluator.isTraced(offset2)) continue;
            Instruction instruction2 = InstructionFactory.create(codeAttribute.code, offset2);
            instruction2.accept(clazz, method, codeAttribute, offset2, this.unusedParameterSimplifier);
        }
        this.maxMarkedOffset = -1;
        int superInitializationOffset = this.partialEvaluator.superInitializationOffset();
        if (superInitializationOffset != -2) {
            this.markInstruction(superInitializationOffset);
        }
        for (offset = 0; offset < codeLength; ++offset) {
            if (!this.partialEvaluator.isTraced(offset)) continue;
            instruction = InstructionFactory.create(codeAttribute.code, offset);
            if (instruction.opcode == -89 && ((BranchInstruction)instruction).branchOffset == 0) {
                this.markInstruction(offset);
                continue;
            }
            if (!this.sideEffectInstructionChecker.hasSideEffects(clazz, method, codeAttribute, offset, instruction)) continue;
            this.markInstruction(offset);
        }
        while (this.maxMarkedOffset >= 0) {
            offset = this.maxMarkedOffset;
            this.maxMarkedOffset = offset - 1;
            if (!this.partialEvaluator.isTraced(offset)) continue;
            if (this.isInstructionNecessary(offset)) {
                instruction = InstructionFactory.create(codeAttribute.code, offset);
                instruction.accept(clazz, method, codeAttribute, offset, this.producerMarker);
            }
            this.markStraddlingBranches(offset, this.partialEvaluator.branchTargets(offset), true);
            this.markStraddlingBranches(offset, this.partialEvaluator.branchOrigins(offset), false);
        }
        for (offset = 0; offset < codeLength; ++offset) {
            if (!this.partialEvaluator.isTraced(offset) || this.isInstructionNecessary(offset)) continue;
            instruction = InstructionFactory.create(codeAttribute.code, offset);
            instruction.accept(clazz, method, codeAttribute, offset, this.variableInitializationMarker);
        }
        this.maxMarkedOffset = codeLength - 1;
        while (this.maxMarkedOffset >= 0) {
            offset = this.maxMarkedOffset;
            this.maxMarkedOffset = offset - 1;
            if (!this.partialEvaluator.isTraced(offset)) continue;
            instruction = InstructionFactory.create(codeAttribute.code, offset);
            instruction.accept(clazz, method, codeAttribute, offset, this.stackConsistencyFixer);
            this.markStraddlingBranches(offset, this.partialEvaluator.branchTargets(offset), true);
            this.markStraddlingBranches(offset, this.partialEvaluator.branchOrigins(offset), false);
        }
        for (offset = 0; offset < codeLength; ++offset) {
            if (!this.partialEvaluator.isTraced(offset) || this.isInstructionNecessary(offset) || !this.isAllSmallerThanOrEqual(this.partialEvaluator.branchTargets(offset), offset) || this.isAnyUnnecessaryInstructionBranchingOver(this.lastNecessaryInstructionOffset(offset), offset)) continue;
            this.replaceByInfiniteLoop(clazz, offset);
        }
        for (offset = 0; offset < codeLength; ++offset) {
            int nextOffset;
            if (!this.isInstructionNecessary(offset) || !this.partialEvaluator.isSubroutineInvocation(offset) || this.isInstructionNecessary(nextOffset = offset + (instruction = InstructionFactory.create(codeAttribute.code, offset)).length(offset))) continue;
            this.replaceByInfiniteLoop(clazz, nextOffset);
        }
        offset = 0;
        do {
            instruction = InstructionFactory.create(codeAttribute.code, offset);
            if (this.isInstructionNecessary(offset)) continue;
            this.codeAttributeEditor.deleteInstruction(offset);
            this.codeAttributeEditor.insertBeforeInstruction(offset, (Instruction)null);
            this.codeAttributeEditor.replaceInstruction(offset, (Instruction)null);
            this.codeAttributeEditor.insertAfterInstruction(offset, (Instruction)null);
            if (this.extraDeletedInstructionVisitor == null) continue;
            instruction.accept(clazz, method, codeAttribute, offset, this.extraDeletedInstructionVisitor);
        } while ((offset += instruction.length(offset)) < codeLength);
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    private void markVariableProducers(int consumerOffset, int variableIndex) {
        TracedVariables tracedVariables = this.partialEvaluator.getVariablesBefore(consumerOffset);
        this.markVariableProducers(tracedVariables.getProducerValue(variableIndex).instructionOffsetValue(), variableIndex);
    }

    private void markVariableProducers(InstructionOffsetValue producerOffsets, int variableIndex) {
        if (producerOffsets != null) {
            int offsetCount = producerOffsets.instructionOffsetCount();
            for (int offsetIndex = 0; offsetIndex < offsetCount; ++offsetIndex) {
                int offset = producerOffsets.instructionOffset(offsetIndex);
                this.markVariableAfter(offset, variableIndex);
                this.markInstruction(offset);
            }
        }
    }

    private void markStackProducers(Clazz clazz, int consumerOffset, Instruction consumer) {
        int popCount = consumer.stackPopCount(clazz);
        for (int stackIndex = 0; stackIndex < popCount; ++stackIndex) {
            this.markStackEntryProducers(consumerOffset, stackIndex);
        }
    }

    private void conditionallyMarkStackEntryProducers(int consumerOffset, int consumerStackIndex, int producerStackIndex) {
        int top = this.partialEvaluator.getStackAfter(consumerOffset).size() - 1;
        if (this.isStackEntryNecessaryAfter(consumerOffset, top - consumerStackIndex)) {
            this.markStackEntryProducers(consumerOffset, producerStackIndex);
        }
    }

    private void markStackEntryProducers(int consumerOffset, int stackIndex) {
        TracedStack tracedStack = this.partialEvaluator.getStackBefore(consumerOffset);
        int stackBottomIndex = tracedStack.size() - 1 - stackIndex;
        if (!this.isStackSimplifiedBefore(consumerOffset, stackBottomIndex)) {
            this.markStackEntryProducers(tracedStack.getTopProducerValue(stackIndex).instructionOffsetValue(), stackBottomIndex);
        }
    }

    private void markStackEntryProducers(InstructionOffsetValue producerOffsets, int stackIndex) {
        if (producerOffsets != null) {
            int offsetCount = producerOffsets.instructionOffsetCount();
            for (int offsetIndex = 0; offsetIndex < offsetCount; ++offsetIndex) {
                int offset = producerOffsets.instructionOffset(offsetIndex);
                this.markStackEntryAfter(offset, stackIndex);
                this.markInstruction(offset);
            }
        }
    }

    private void markInitialization(int newInstructionOffset) {
        int initializationOffset = this.partialEvaluator.initializationOffset(newInstructionOffset);
        TracedStack tracedStack = this.partialEvaluator.getStackAfter(newInstructionOffset);
        this.markStackEntryAfter(initializationOffset, tracedStack.size() - 1);
        this.markInstruction(initializationOffset);
    }

    private void markStraddlingBranches(int instructionOffset, InstructionOffsetValue branchOffsets, boolean isPointingToTargets) {
        if (branchOffsets != null) {
            int branchCount = branchOffsets.instructionOffsetCount();
            for (int branchIndex = 0; branchIndex < branchCount; ++branchIndex) {
                int branchOffset = branchOffsets.instructionOffset(branchIndex);
                if (isPointingToTargets) {
                    this.markStraddlingBranch(instructionOffset, branchOffset, instructionOffset, branchOffset);
                    continue;
                }
                this.markStraddlingBranch(instructionOffset, branchOffset, branchOffset, instructionOffset);
            }
        }
    }

    private void markStraddlingBranch(int instructionOffsetStart, int instructionOffsetEnd, int branchOrigin, int branchTarget) {
        if (!this.isInstructionNecessary(branchOrigin) && this.isAnyInstructionNecessary(instructionOffsetStart, instructionOffsetEnd)) {
            this.markInstruction(branchOrigin);
        }
    }

    private void fixDupInstruction(Clazz clazz, CodeAttribute codeAttribute, int dupOffset, Instruction instruction) {
        int top = this.partialEvaluator.getStackAfter(dupOffset).size() - 1;
        int oldOpcode = instruction.opcode;
        int newOpcode = 0;
        switch (oldOpcode) {
            case 89: {
                boolean stackEntryPresent0 = this.isStackEntryNecessaryAfter(dupOffset, top - 0);
                boolean stackEntryPresent1 = this.isStackEntryNecessaryAfter(dupOffset, top - 1);
                if (!stackEntryPresent0 && !stackEntryPresent1 || !stackEntryPresent0 || !stackEntryPresent1) break;
                newOpcode = 89;
                break;
            }
            case 90: {
                int skipCount;
                boolean stackEntryPresent0 = this.isStackEntryNecessaryAfter(dupOffset, top - 0);
                boolean stackEntryPresent1 = this.isStackEntryNecessaryAfter(dupOffset, top - 1);
                boolean stackEntryPresent2 = this.isStackEntryNecessaryAfter(dupOffset, top - 2);
                if (!stackEntryPresent0 && !stackEntryPresent2 || !stackEntryPresent2) break;
                int n = skipCount = stackEntryPresent1 ? 1 : 0;
                if (stackEntryPresent0) {
                    newOpcode = (byte)(89 + skipCount);
                    break;
                }
                if (skipCount != 1) break;
                newOpcode = 95;
                break;
            }
            case 91: {
                boolean stackEntryPresent0 = this.isStackEntryNecessaryAfter(dupOffset, top - 0);
                boolean stackEntryPresent1 = this.isStackEntryNecessaryAfter(dupOffset, top - 1);
                boolean stackEntryPresent2 = this.isStackEntryNecessaryAfter(dupOffset, top - 2);
                boolean stackEntryPresent3 = this.isStackEntryNecessaryAfter(dupOffset, top - 3);
                if (!stackEntryPresent0 && !stackEntryPresent3 || !stackEntryPresent3) break;
                int skipCount = (stackEntryPresent1 ? 1 : 0) + (stackEntryPresent2 ? 1 : 0);
                if (stackEntryPresent0) {
                    newOpcode = (byte)(89 + skipCount);
                    break;
                }
                if (skipCount == 1) {
                    newOpcode = 95;
                    break;
                }
                if (skipCount != 2) break;
                throw new UnsupportedOperationException("Can't handle dup_x2 instruction moving original element across two elements at [" + dupOffset + "]");
            }
            case 92: {
                boolean stackEntriesPresent01 = this.isStackEntriesNecessaryAfter(dupOffset, top - 0, top - 1);
                boolean stackEntriesPresent23 = this.isStackEntriesNecessaryAfter(dupOffset, top - 2, top - 3);
                if (!stackEntriesPresent01 && !stackEntriesPresent23 || !stackEntriesPresent01 || !stackEntriesPresent23) break;
                newOpcode = 92;
                break;
            }
            case 93: {
                int skipCount;
                boolean stackEntriesPresent01 = this.isStackEntriesNecessaryAfter(dupOffset, top - 0, top - 1);
                boolean stackEntryPresent2 = this.isStackEntryNecessaryAfter(dupOffset, top - 2);
                boolean stackEntriesPresent34 = this.isStackEntriesNecessaryAfter(dupOffset, top - 3, top - 4);
                if (!stackEntriesPresent01 && !stackEntriesPresent34 || !stackEntriesPresent34) break;
                int n = skipCount = stackEntryPresent2 ? 1 : 0;
                if (stackEntriesPresent01) {
                    newOpcode = (byte)(92 + skipCount);
                    break;
                }
                if (skipCount <= 0) break;
                throw new UnsupportedOperationException("Can't handle dup2_x1 instruction moving original element across " + skipCount + " elements at [" + dupOffset + "]");
            }
            case 94: {
                boolean stackEntriesPresent01 = this.isStackEntriesNecessaryAfter(dupOffset, top - 0, top - 1);
                boolean stackEntryPresent2 = this.isStackEntryNecessaryAfter(dupOffset, top - 2);
                boolean stackEntryPresent3 = this.isStackEntryNecessaryAfter(dupOffset, top - 3);
                boolean stackEntriesPresent45 = this.isStackEntriesNecessaryAfter(dupOffset, top - 4, top - 5);
                if (!stackEntriesPresent01 && !stackEntriesPresent45 || !stackEntriesPresent45) break;
                int skipCount = (stackEntryPresent2 ? 1 : 0) + (stackEntryPresent3 ? 1 : 0);
                if (stackEntriesPresent01) {
                    newOpcode = (byte)(92 + skipCount);
                    break;
                }
                if (skipCount <= 0) break;
                throw new UnsupportedOperationException("Can't handle dup2_x2 instruction moving original element across " + skipCount + " elements at [" + dupOffset + "]");
            }
            case 95: {
                boolean stackEntryPresent0 = this.isStackEntryNecessaryAfter(dupOffset, top - 0);
                boolean stackEntryPresent1 = this.isStackEntryNecessaryAfter(dupOffset, top - 1);
                if (!stackEntryPresent0 && !stackEntryPresent1 || !stackEntryPresent0 || !stackEntryPresent1) break;
                newOpcode = 95;
                break;
            }
        }
        if (newOpcode == 0) {
            this.codeAttributeEditor.deleteInstruction(dupOffset);
            if (this.extraDeletedInstructionVisitor != null) {
                this.extraDeletedInstructionVisitor.visitSimpleInstruction(null, null, null, dupOffset, null);
            }
        } else if (newOpcode == oldOpcode) {
            this.codeAttributeEditor.undeleteInstruction(dupOffset);
        } else {
            SimpleInstruction replacementInstruction = new SimpleInstruction((byte)newOpcode);
            this.codeAttributeEditor.replaceInstruction(dupOffset, replacementInstruction);
        }
    }

    private void insertPushInstructions(int offset, boolean replace, int computationalType) {
        this.markInstruction(offset);
        SimpleInstruction replacementInstruction = new SimpleInstruction(this.pushOpcode(computationalType));
        if (replace) {
            this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
        } else {
            this.codeAttributeEditor.insertBeforeInstruction(offset, replacementInstruction);
            if (this.extraAddedInstructionVisitor != null) {
                ((Instruction)replacementInstruction).accept(null, null, null, offset, this.extraAddedInstructionVisitor);
            }
        }
    }

    private byte pushOpcode(int computationalType) {
        switch (computationalType) {
            case 1: {
                return 3;
            }
            case 2: {
                return 9;
            }
            case 3: {
                return 11;
            }
            case 4: {
                return 14;
            }
            case 5: 
            case 6: {
                return 1;
            }
        }
        throw new IllegalArgumentException("No push opcode for computational type [" + computationalType + "]");
    }

    private void insertPopInstructions(int offset, boolean replace, int popCount) {
        this.markInstruction(offset);
        switch (popCount) {
            case 1: {
                SimpleInstruction popInstruction = new SimpleInstruction(87);
                if (replace) {
                    this.codeAttributeEditor.replaceInstruction(offset, popInstruction);
                    break;
                }
                this.codeAttributeEditor.insertAfterInstruction(offset, popInstruction);
                if (this.extraAddedInstructionVisitor == null) break;
                ((Instruction)popInstruction).accept(null, null, null, offset, this.extraAddedInstructionVisitor);
                break;
            }
            case 2: {
                SimpleInstruction popInstruction = new SimpleInstruction(88);
                if (replace) {
                    this.codeAttributeEditor.replaceInstruction(offset, popInstruction);
                    break;
                }
                this.codeAttributeEditor.insertAfterInstruction(offset, popInstruction);
                if (this.extraAddedInstructionVisitor == null) break;
                ((Instruction)popInstruction).accept(null, null, null, offset, this.extraAddedInstructionVisitor);
                break;
            }
            default: {
                int index;
                Instruction[] popInstructions = new Instruction[popCount / 2 + popCount % 2];
                SimpleInstruction popInstruction = new SimpleInstruction(88);
                for (index = 0; index < popCount / 2; ++index) {
                    popInstructions[index] = popInstruction;
                }
                if (popCount % 2 == 1) {
                    popInstruction = new SimpleInstruction(87);
                    popInstructions[popCount / 2] = popInstruction;
                }
                if (replace) {
                    this.codeAttributeEditor.replaceInstruction(offset, popInstructions);
                    for (index = 1; index < popInstructions.length; ++index) {
                        if (this.extraAddedInstructionVisitor == null) continue;
                        popInstructions[index].accept(null, null, null, offset, this.extraAddedInstructionVisitor);
                    }
                } else {
                    this.codeAttributeEditor.insertAfterInstruction(offset, popInstructions);
                    for (index = 0; index < popInstructions.length; ++index) {
                        if (this.extraAddedInstructionVisitor == null) continue;
                        popInstructions[index].accept(null, null, null, offset, this.extraAddedInstructionVisitor);
                    }
                }
                break;
            }
        }
    }

    private void replaceByStaticInvocation(Clazz clazz, int offset, ConstantInstruction constantInstruction) {
        Instruction replacementInstruction = new ConstantInstruction(-72, constantInstruction.constantIndex).shrink();
        this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
    }

    private void replaceByInfiniteLoop(Clazz clazz, int offset) {
        this.markInstruction(offset);
        BranchInstruction replacementInstruction = new BranchInstruction(-89, 0);
        this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
    }

    private boolean isDupOrSwap(Instruction instruction) {
        return instruction.opcode >= 89 && instruction.opcode <= 95;
    }

    private boolean isPop(Instruction instruction) {
        return instruction.opcode == 87 || instruction.opcode == 88;
    }

    private boolean isAnyUnnecessaryInstructionBranchingOver(int instructionOffset1, int instructionOffset2) {
        for (int offset = instructionOffset1; offset < instructionOffset2; ++offset) {
            if (!this.partialEvaluator.isTraced(offset) || this.isInstructionNecessary(offset) || !this.isAnyLargerThan(this.partialEvaluator.branchTargets(offset), instructionOffset2)) continue;
            return true;
        }
        return false;
    }

    private boolean isAllSmallerThanOrEqual(InstructionOffsetValue instructionOffsets, int instructionOffset) {
        int branchCount;
        if (instructionOffsets != null && (branchCount = instructionOffsets.instructionOffsetCount()) > 0) {
            for (int branchIndex = 0; branchIndex < branchCount; ++branchIndex) {
                if (instructionOffsets.instructionOffset(branchIndex) <= instructionOffset) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isAnyLargerThan(InstructionOffsetValue instructionOffsets, int instructionOffset) {
        int branchCount;
        if (instructionOffsets != null && (branchCount = instructionOffsets.instructionOffsetCount()) > 0) {
            for (int branchIndex = 0; branchIndex < branchCount; ++branchIndex) {
                if (instructionOffsets.instructionOffset(branchIndex) <= instructionOffset) continue;
                return true;
            }
        }
        return false;
    }

    private void initializeNecessary(CodeAttribute codeAttribute) {
        int index;
        int offset;
        int codeLength = codeAttribute.u4codeLength;
        int maxLocals = codeAttribute.u2maxLocals;
        int maxStack = codeAttribute.u2maxStack;
        if (this.variablesNecessaryAfter.length < codeLength || this.variablesNecessaryAfter[0].length < maxLocals) {
            this.variablesNecessaryAfter = new boolean[codeLength][maxLocals];
        } else {
            for (offset = 0; offset < codeLength; ++offset) {
                for (index = 0; index < maxLocals; ++index) {
                    this.variablesNecessaryAfter[offset][index] = false;
                }
            }
        }
        if (this.stacksNecessaryAfter.length < codeLength || this.stacksNecessaryAfter[0].length < maxStack) {
            this.stacksNecessaryAfter = new boolean[codeLength][maxStack];
        } else {
            for (offset = 0; offset < codeLength; ++offset) {
                for (index = 0; index < maxStack; ++index) {
                    this.stacksNecessaryAfter[offset][index] = false;
                }
            }
        }
        if (this.stacksSimplifiedBefore.length < codeLength || this.stacksSimplifiedBefore[0].length < maxStack) {
            this.stacksSimplifiedBefore = new boolean[codeLength][maxStack];
        } else {
            for (offset = 0; offset < codeLength; ++offset) {
                for (index = 0; index < maxStack; ++index) {
                    this.stacksSimplifiedBefore[offset][index] = false;
                }
            }
        }
        if (this.instructionsNecessary.length < codeLength) {
            this.instructionsNecessary = new boolean[codeLength];
        } else {
            for (int index2 = 0; index2 < codeLength; ++index2) {
                this.instructionsNecessary[index2] = false;
            }
        }
    }

    private boolean isStackEntriesNecessaryAfter(int instructionOffset, int stackIndex1, int stackIndex2) {
        boolean present1 = this.isStackEntryNecessaryAfter(instructionOffset, stackIndex1);
        boolean present2 = this.isStackEntryNecessaryAfter(instructionOffset, stackIndex2);
        return present1 || present2;
    }

    private boolean isVariableInitialization(int instructionOffset, int variableIndex) {
        Value valueBefore = this.partialEvaluator.getVariablesBefore(instructionOffset).getValue(variableIndex);
        if (valueBefore == null) {
            return true;
        }
        Value valueAfter = this.partialEvaluator.getVariablesAfter(instructionOffset).getValue(variableIndex);
        if (valueAfter.computationalType() != valueBefore.computationalType()) {
            return true;
        }
        Value producersBefore = this.partialEvaluator.getVariablesBefore(instructionOffset).getProducerValue(variableIndex);
        return producersBefore.instructionOffsetValue().instructionOffsetCount() == 1 && producersBefore.instructionOffsetValue().instructionOffset(0) == -1;
    }

    private boolean isVariableInitializationNecessary(Clazz clazz, Method method, CodeAttribute codeAttribute, int initializationOffset, int variableIndex) {
        int codeLength = codeAttribute.u4codeLength;
        if (this.isVariableNecessaryAfterAny(0, codeLength, variableIndex)) {
            this.simplePartialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
            for (int offset = 0; offset < codeLength; ++offset) {
                Value simpleProducer;
                Value producer;
                if (!this.partialEvaluator.isTraced(offset) || (producer = this.partialEvaluator.getVariablesBefore(offset).getProducerValue(variableIndex)) == null || (simpleProducer = this.simplePartialEvaluator.getVariablesBefore(offset).getProducerValue(variableIndex)) == null) continue;
                InstructionOffsetValue producerOffsets = producer.instructionOffsetValue();
                InstructionOffsetValue simpleProducerOffsets = simpleProducer.instructionOffsetValue();
                if (!this.isVariableNecessaryAfterAny(producerOffsets, variableIndex) || this.isVariableNecessaryAfterAll(simpleProducerOffsets, variableIndex)) continue;
                return true;
            }
        }
        return false;
    }

    private void markVariableAfter(int instructionOffset, int variableIndex) {
        if (!this.isVariableNecessaryAfter(instructionOffset, variableIndex)) {
            this.variablesNecessaryAfter[instructionOffset][variableIndex] = true;
            if (this.maxMarkedOffset < instructionOffset) {
                this.maxMarkedOffset = instructionOffset;
            }
        }
    }

    private boolean isVariableNecessaryAfterAny(int startOffset, int endOffset, int variableIndex) {
        for (int offset = startOffset; offset < endOffset; ++offset) {
            if (!this.isVariableNecessaryAfter(offset, variableIndex)) continue;
            return true;
        }
        return false;
    }

    private boolean isVariableNecessaryAfterAny(InstructionOffsetValue instructionOffsetValue, int variableIndex) {
        int count = instructionOffsetValue.instructionOffsetCount();
        for (int index = 0; index < count; ++index) {
            if (!this.isVariableNecessaryAfter(instructionOffsetValue.instructionOffset(index), variableIndex)) continue;
            return true;
        }
        return false;
    }

    private boolean isVariableNecessaryAfterAll(InstructionOffsetValue instructionOffsetValue, int variableIndex) {
        int count = instructionOffsetValue.instructionOffsetCount();
        for (int index = 0; index < count; ++index) {
            if (this.isVariableNecessaryAfter(instructionOffsetValue.instructionOffset(index), variableIndex)) continue;
            return false;
        }
        return true;
    }

    private boolean isVariableNecessaryAfter(int instructionOffset, int variableIndex) {
        return instructionOffset == -1 || this.variablesNecessaryAfter[instructionOffset][variableIndex];
    }

    private void markStackEntryAfter(int instructionOffset, int stackIndex) {
        if (!this.isStackEntryNecessaryAfter(instructionOffset, stackIndex)) {
            this.stacksNecessaryAfter[instructionOffset][stackIndex] = true;
            if (this.maxMarkedOffset < instructionOffset) {
                this.maxMarkedOffset = instructionOffset;
            }
        }
    }

    private boolean isAnyStackEntryNecessaryAfter(InstructionOffsetValue instructionOffsets, int stackIndex) {
        int offsetCount = instructionOffsets.instructionOffsetCount();
        for (int offsetIndex = 0; offsetIndex < offsetCount; ++offsetIndex) {
            if (!this.isStackEntryNecessaryAfter(instructionOffsets.instructionOffset(offsetIndex), stackIndex)) continue;
            return true;
        }
        return false;
    }

    private boolean isStackEntryNecessaryAfter(int instructionOffset, int stackIndex) {
        return instructionOffset == -1 || this.stacksNecessaryAfter[instructionOffset][stackIndex];
    }

    private void markStackSimplificationBefore(int instructionOffset, int stackIndex) {
        this.stacksSimplifiedBefore[instructionOffset][stackIndex] = true;
    }

    private boolean isStackSimplifiedBefore(int instructionOffset, int stackIndex) {
        return this.stacksSimplifiedBefore[instructionOffset][stackIndex];
    }

    private void markInstruction(int instructionOffset) {
        if (!this.isInstructionNecessary(instructionOffset)) {
            this.instructionsNecessary[instructionOffset] = true;
            if (this.maxMarkedOffset < instructionOffset) {
                this.maxMarkedOffset = instructionOffset;
            }
        }
    }

    private boolean isAnyInstructionNecessary(int instructionOffset1, int instructionOffset2) {
        for (int instructionOffset = instructionOffset1; instructionOffset < instructionOffset2; ++instructionOffset) {
            if (!this.isInstructionNecessary(instructionOffset)) continue;
            return true;
        }
        return false;
    }

    private int lastNecessaryInstructionOffset(int instructionOffset) {
        for (int offset = instructionOffset - 1; offset >= 0; --offset) {
            if (!this.isInstructionNecessary(instructionOffset)) continue;
            return offset;
        }
        return 0;
    }

    private boolean isInstructionNecessary(int instructionOffset) {
        return instructionOffset == -1 || this.instructionsNecessary[instructionOffset];
    }

    private class MyStackConsistencyFixer
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyStackConsistencyFixer() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
            if (EvaluationShrinker.this.isInstructionNecessary(offset)) {
                int pushCount;
                int popCount = instruction.stackPopCount(clazz);
                if (popCount > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.partialEvaluator.getStackBefore(offset);
                    int top = tracedStack.size() - 1;
                    int requiredPushCount = 0;
                    for (int stackIndex = 0; stackIndex < popCount; ++stackIndex) {
                        if (EvaluationShrinker.this.isStackSimplifiedBefore(offset, top - stackIndex) || EvaluationShrinker.this.isAnyStackEntryNecessaryAfter(tracedStack.getTopProducerValue(stackIndex).instructionOffsetValue(), top - stackIndex)) continue;
                        ++requiredPushCount;
                    }
                    if (requiredPushCount > 0) {
                        if (requiredPushCount > (instruction.isCategory2() ? 2 : 1)) {
                            throw new IllegalArgumentException("Unsupported stack size increment [" + requiredPushCount + "]");
                        }
                        EvaluationShrinker.this.insertPushInstructions(offset, false, tracedStack.getTop(0).computationalType());
                    }
                }
                if ((pushCount = instruction.stackPushCount(clazz)) > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.partialEvaluator.getStackAfter(offset);
                    int top = tracedStack.size() - 1;
                    int requiredPopCount = 0;
                    for (int stackIndex = 0; stackIndex < pushCount; ++stackIndex) {
                        if (EvaluationShrinker.this.isStackEntryNecessaryAfter(offset, top - stackIndex)) continue;
                        ++requiredPopCount;
                    }
                    if (requiredPopCount > 0) {
                        EvaluationShrinker.this.insertPopInstructions(offset, false, requiredPopCount);
                    }
                }
            } else {
                int pushCount;
                int popCount = instruction.stackPopCount(clazz);
                if (popCount > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.partialEvaluator.getStackBefore(offset);
                    int top = tracedStack.size() - 1;
                    int expectedPopCount = 0;
                    for (int stackIndex = 0; stackIndex < popCount; ++stackIndex) {
                        if (!EvaluationShrinker.this.isAnyStackEntryNecessaryAfter(tracedStack.getTopProducerValue(stackIndex).instructionOffsetValue(), top - stackIndex)) continue;
                        ++expectedPopCount;
                    }
                    if (expectedPopCount > 0) {
                        EvaluationShrinker.this.insertPopInstructions(offset, true, expectedPopCount);
                    }
                }
                if ((pushCount = instruction.stackPushCount(clazz)) > 0) {
                    TracedStack tracedStack = EvaluationShrinker.this.partialEvaluator.getStackAfter(offset);
                    int top = tracedStack.size() - 1;
                    int expectedPushCount = 0;
                    for (int stackIndex = 0; stackIndex < pushCount; ++stackIndex) {
                        if (!EvaluationShrinker.this.isStackEntryNecessaryAfter(offset, top - stackIndex)) continue;
                        ++expectedPushCount;
                    }
                    if (expectedPushCount > 0) {
                        EvaluationShrinker.this.insertPushInstructions(offset, true, tracedStack.getTop(0).computationalType());
                    }
                }
            }
        }

        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
            if (EvaluationShrinker.this.isInstructionNecessary(offset) && EvaluationShrinker.this.isDupOrSwap(simpleInstruction)) {
                EvaluationShrinker.this.fixDupInstruction(clazz, codeAttribute, offset, simpleInstruction);
            } else {
                this.visitAnyInstruction(clazz, method, codeAttribute, offset, simpleInstruction);
            }
        }
    }

    private class MyVariableInitializationMarker
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyVariableInitializationMarker() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        }

        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
            int variableIndex;
            if (!variableInstruction.isLoad() && EvaluationShrinker.this.isVariableInitialization(offset, variableIndex = variableInstruction.variableIndex) && EvaluationShrinker.this.isVariableInitializationNecessary(clazz, method, codeAttribute, offset, variableIndex)) {
                EvaluationShrinker.this.markInstruction(offset);
            }
        }
    }

    private class MyProducerMarker
    extends SimplifiedVisitor
    implements InstructionVisitor {
        private MyProducerMarker() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
            EvaluationShrinker.this.markStackProducers(clazz, offset, instruction);
        }

        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
            switch (simpleInstruction.opcode) {
                case 89: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 0, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 1, 0);
                    break;
                }
                case 90: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 0, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 1, 1);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 2, 0);
                    break;
                }
                case 91: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 0, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 1, 1);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 2, 2);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 3, 0);
                    break;
                }
                case 92: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 0, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 1, 1);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 2, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 3, 1);
                    break;
                }
                case 93: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 0, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 1, 1);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 2, 2);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 3, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 4, 1);
                    break;
                }
                case 94: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 0, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 1, 1);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 2, 2);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 3, 3);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 4, 0);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 5, 1);
                    break;
                }
                case 95: {
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 0, 1);
                    EvaluationShrinker.this.conditionallyMarkStackEntryProducers(offset, 1, 0);
                    break;
                }
                default: {
                    EvaluationShrinker.this.markStackProducers(clazz, offset, simpleInstruction);
                }
            }
        }

        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
            if (variableInstruction.opcode < 54) {
                EvaluationShrinker.this.markVariableProducers(offset, variableInstruction.variableIndex);
            } else {
                EvaluationShrinker.this.markStackProducers(clazz, offset, variableInstruction);
            }
        }

        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            if (constantInstruction.opcode == -69) {
                EvaluationShrinker.this.markInitialization(offset);
            }
            EvaluationShrinker.this.markStackProducers(clazz, offset, constantInstruction);
        }

        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
            if (branchInstruction.opcode == -88 || branchInstruction.opcode == -55) {
                EvaluationShrinker.this.markStackEntryAfter(offset, 0);
            } else {
                EvaluationShrinker.this.markStackProducers(clazz, offset, branchInstruction);
            }
        }
    }

    private class MyUnusedParameterSimplifier
    extends SimplifiedVisitor
    implements InstructionVisitor,
    ConstantVisitor,
    MemberVisitor {
        private int invocationOffset;
        private ConstantInstruction invocationInstruction;

        private MyUnusedParameterSimplifier() {
        }

        public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        }

        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            switch (constantInstruction.opcode) {
                case -74: 
                case -73: 
                case -72: 
                case -71: {
                    this.invocationOffset = offset;
                    this.invocationInstruction = constantInstruction;
                    clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                }
            }
        }

        public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
            refConstant.referencedMemberAccept(this);
        }

        public void visitAnyMember(Clazz clazz, Member member) {
        }

        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
            int parameterSize = ParameterUsageMarker.getParameterSize(programMethod);
            if ((programMethod.getAccessFlags() & 8) == 0 && !ParameterUsageMarker.isParameterUsed(programMethod, 0)) {
                EvaluationShrinker.this.replaceByStaticInvocation(programClass, this.invocationOffset, this.invocationInstruction);
            }
            for (int index = 0; index < parameterSize; ++index) {
                if (ParameterUsageMarker.isParameterUsed(programMethod, index)) continue;
                TracedStack stack = EvaluationShrinker.this.partialEvaluator.getStackBefore(this.invocationOffset);
                int stackIndex = stack.size() - parameterSize + index;
                EvaluationShrinker.this.markStackSimplificationBefore(this.invocationOffset, stackIndex);
            }
        }
    }
}

