/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.VariableRemapper;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.evaluation.LivenessAnalyzer;

public class VariableOptimizer
extends SimplifiedVisitor
implements AttributeVisitor {
    private static final boolean DEBUG = false;
    private static final int MAX_VARIABLES_SIZE = 64;
    private final boolean reuseThis;
    private final MemberVisitor extraVariableMemberVisitor;
    private final LivenessAnalyzer livenessAnalyzer = new LivenessAnalyzer();
    private final VariableRemapper variableRemapper = new VariableRemapper();
    private int[] variableMap = new int[64];

    public VariableOptimizer(boolean reuseThis) {
        this(reuseThis, null);
    }

    public VariableOptimizer(boolean reuseThis, MemberVisitor extraVariableMemberVisitor) {
        this.reuseThis = reuseThis;
        this.extraVariableMemberVisitor = extraVariableMemberVisitor;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.initializeArrays(codeAttribute);
        this.livenessAnalyzer.visitCodeAttribute(clazz, method, codeAttribute);
        int startIndex = (method.getAccessFlags() & 8) != 0 || this.reuseThis ? 0 : 1;
        int parameterSize = ClassUtil.internalMethodParameterSize(method.getDescriptor(clazz), method.getAccessFlags());
        int variableSize = codeAttribute.u2maxLocals;
        int codeLength = codeAttribute.u4codeLength;
        boolean remapping = false;
        block0: for (int oldIndex = 0; oldIndex < variableSize; ++oldIndex) {
            this.variableMap[oldIndex] = oldIndex;
            if (oldIndex < parameterSize || oldIndex >= 64) continue;
            for (int newIndex = startIndex; newIndex < oldIndex; ++newIndex) {
                if (!this.areNonOverlapping(oldIndex, newIndex, codeLength)) continue;
                this.variableMap[oldIndex] = newIndex;
                this.updateLiveness(oldIndex, newIndex, codeLength);
                remapping = true;
                continue block0;
            }
        }
        if (remapping) {
            this.variableRemapper.setVariableMap(this.variableMap);
            this.variableRemapper.visitCodeAttribute(clazz, method, codeAttribute);
            if (this.extraVariableMemberVisitor != null) {
                method.accept(clazz, this.extraVariableMemberVisitor);
            }
        }
    }

    private void initializeArrays(CodeAttribute codeAttribute) {
        int codeLength = codeAttribute.u4codeLength;
        if (this.variableMap.length < codeLength) {
            this.variableMap = new int[codeLength];
        }
    }

    private boolean areNonOverlapping(int variableIndex1, int variableIndex2, int codeLength) {
        for (int offset = 0; offset < codeLength; ++offset) {
            if (!(this.livenessAnalyzer.isAliveBefore(offset, variableIndex1) && this.livenessAnalyzer.isAliveBefore(offset, variableIndex2) || this.livenessAnalyzer.isAliveAfter(offset, variableIndex1) && this.livenessAnalyzer.isAliveAfter(offset, variableIndex2)) && !this.livenessAnalyzer.isCategory2(offset, variableIndex1)) continue;
            return false;
        }
        return true;
    }

    private void updateLiveness(int oldVariableIndex, int newVariableIndex, int codeLength) {
        for (int offset = 0; offset < codeLength; ++offset) {
            if (this.livenessAnalyzer.isAliveBefore(offset, oldVariableIndex)) {
                this.livenessAnalyzer.setAliveBefore(offset, oldVariableIndex, false);
                this.livenessAnalyzer.setAliveBefore(offset, newVariableIndex, true);
            }
            if (!this.livenessAnalyzer.isAliveAfter(offset, oldVariableIndex)) continue;
            this.livenessAnalyzer.setAliveAfter(offset, oldVariableIndex, false);
            this.livenessAnalyzer.setAliveAfter(offset, newVariableIndex, true);
        }
    }
}

