/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;
import proguard.optimize.info.NoSideEffectMethodMarker;
import proguard.optimize.info.ReadWriteFieldMarker;
import proguard.optimize.info.SideEffectMethodMarker;

public class SideEffectInstructionChecker
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor,
MemberVisitor {
    private final boolean includeReturnInstructions;
    private boolean hasSideEffects;

    public SideEffectInstructionChecker(boolean includeReturnInstructions) {
        this.includeReturnInstructions = includeReturnInstructions;
    }

    public boolean hasSideEffects(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        this.hasSideEffects = false;
        instruction.accept(clazz, method, codeAttribute, offset, this);
        return this.hasSideEffects;
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        byte opcode = simpleInstruction.opcode;
        if (opcode == 79 || opcode == 80 || opcode == 81 || opcode == 82 || opcode == 83 || opcode == 84 || opcode == 85 || opcode == 86 || opcode == -65 || opcode == -62 || opcode == -61 || this.includeReturnInstructions && (opcode == -84 || opcode == -83 || opcode == -82 || opcode == -81 || opcode == -80 || opcode == -79)) {
            this.hasSideEffects = true;
        }
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        byte opcode = variableInstruction.opcode;
        if (this.includeReturnInstructions && opcode == -87) {
            this.hasSideEffects = true;
        }
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        byte opcode = constantInstruction.opcode;
        if (opcode == -77 || opcode == -75 || opcode == -74 || opcode == -73 || opcode == -72 || opcode == -71) {
            clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
        }
    }

    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        byte opcode = branchInstruction.opcode;
        if (this.includeReturnInstructions && (opcode == -88 || opcode == -55)) {
            this.hasSideEffects = true;
        }
    }

    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        this.hasSideEffects = true;
        fieldrefConstant.referencedMemberAccept(this);
    }

    public void visitAnyMethodrefConstant(Clazz clazz, RefConstant refConstant) {
        Member referencedMember = refConstant.referencedMember;
        if (referencedMember == null) {
            this.hasSideEffects = true;
        } else {
            refConstant.referencedMemberAccept(this);
            if (!this.hasSideEffects) {
                Clazz referencedClass = refConstant.referencedClass;
                Method referencedMethod = (Method)referencedMember;
                if ((referencedMethod.getAccessFlags() & 2) == 0) {
                    clazz.hierarchyAccept(false, false, false, true, new NamedMethodVisitor(referencedMethod.getName(referencedClass), referencedMethod.getDescriptor(referencedClass), this));
                }
            }
        }
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.hasSideEffects = ReadWriteFieldMarker.isRead(programField);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.hasSideEffects = this.hasSideEffects || SideEffectMethodMarker.hasSideEffects(programMethod);
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        this.hasSideEffects = true;
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        this.hasSideEffects = this.hasSideEffects || !NoSideEffectMethodMarker.hasNoSideEffects(libraryMethod);
    }
}

