/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.List;
import proguard.KeepClassSpecification;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassVisitor;

public class KeepClassMemberChecker
extends SimplifiedVisitor
implements ClassVisitor {
    private final WarningPrinter notePrinter;

    public KeepClassMemberChecker(WarningPrinter notePrinter) {
        this.notePrinter = notePrinter;
    }

    public void checkClassSpecifications(List keepClassSpecifications) {
        if (keepClassSpecifications != null) {
            for (int index = 0; index < keepClassSpecifications.size(); ++index) {
                String className;
                KeepClassSpecification keepClassSpecification = (KeepClassSpecification)keepClassSpecifications.get(index);
                if (keepClassSpecification.markClasses || keepClassSpecification.fieldSpecifications != null && keepClassSpecification.fieldSpecifications.size() != 0 || keepClassSpecification.methodSpecifications != null && keepClassSpecification.methodSpecifications.size() != 0 || !this.notePrinter.accepts(className = keepClassSpecification.className)) continue;
                this.notePrinter.print(className, "Note: the configuration doesn't specify which class members to keep for class '" + ClassUtil.externalClassName(className) + "'");
            }
        }
    }
}

