/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import java.util.HashSet;
import java.util.Set;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassCollector;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.NoSideEffectMethodMarker;
import proguard.optimize.info.ReadWriteFieldMarker;
import proguard.optimize.info.SideEffectMethodMarker;
import proguard.optimize.info.StaticInitializerContainingClassFilter;

public class SideEffectInstructionChecker
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor,
MemberVisitor {
    private final boolean includeReturnInstructions;
    private Clazz referencingClass;
    private boolean hasSideEffects;

    public SideEffectInstructionChecker(boolean includeReturnInstructions) {
        this.includeReturnInstructions = includeReturnInstructions;
    }

    public boolean hasSideEffects(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        this.hasSideEffects = false;
        instruction.accept(clazz, method, codeAttribute, offset, this);
        return this.hasSideEffects;
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        byte opcode = simpleInstruction.opcode;
        if (opcode == 79 || opcode == 80 || opcode == 81 || opcode == 82 || opcode == 83 || opcode == 84 || opcode == 85 || opcode == 86 || opcode == -65 || opcode == -62 || opcode == -61 || this.includeReturnInstructions && (opcode == -84 || opcode == -83 || opcode == -82 || opcode == -81 || opcode == -80 || opcode == -79)) {
            this.hasSideEffects = true;
        }
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        byte opcode = variableInstruction.opcode;
        if (this.includeReturnInstructions && opcode == -87) {
            this.hasSideEffects = true;
        }
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        byte opcode = constantInstruction.opcode;
        if (opcode == -78 || opcode == -77 || opcode == -76 || opcode == -75 || opcode == -74 || opcode == -73 || opcode == -72 || opcode == -71) {
            clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
        }
    }

    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        byte opcode = branchInstruction.opcode;
        if (this.includeReturnInstructions && (opcode == -88 || opcode == -55)) {
            this.hasSideEffects = true;
        }
    }

    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        this.referencingClass = clazz;
        this.hasSideEffects = true;
        fieldrefConstant.referencedMemberAccept(this);
    }

    public void visitAnyMethodrefConstant(Clazz clazz, RefConstant refConstant) {
        this.referencingClass = clazz;
        this.hasSideEffects = true;
        refConstant.referencedMemberAccept(this);
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.hasSideEffects = ReadWriteFieldMarker.isRead(programField) && ReadWriteFieldMarker.isWritten(programField) || (programField.getAccessFlags() & 0x40) != 0 || !programClass.equals(this.referencingClass) && !this.initializedSuperClasses(this.referencingClass).containsAll(this.initializedSuperClasses(programClass));
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.hasSideEffects = !NoSideEffectMethodMarker.hasNoSideEffects(programMethod) && (SideEffectMethodMarker.hasSideEffects(programMethod) || !programClass.equals(this.referencingClass) && !this.initializedSuperClasses(this.referencingClass).containsAll(this.initializedSuperClasses(programClass)));
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        this.hasSideEffects = true;
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        this.hasSideEffects = !NoSideEffectMethodMarker.hasNoSideEffects(libraryMethod);
    }

    private Set initializedSuperClasses(Clazz clazz) {
        HashSet set = new HashSet();
        clazz.hierarchyAccept(true, true, true, false, new StaticInitializerContainingClassFilter(new ClassCollector(set)));
        return set;
    }
}

