/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;

public class ConstantInstruction
extends Instruction
implements ConstantVisitor {
    public int constantIndex;
    public int constant;
    private int parameterStackDelta;
    private int typeStackDelta;

    public ConstantInstruction() {
    }

    public ConstantInstruction(byte opcode, int constantIndex) {
        this(opcode, constantIndex, 0);
    }

    public ConstantInstruction(byte opcode, int constantIndex, int constant) {
        this.opcode = opcode;
        this.constantIndex = constantIndex;
        this.constant = constant;
    }

    public ConstantInstruction copy(ConstantInstruction constantInstruction) {
        this.opcode = constantInstruction.opcode;
        this.constantIndex = constantInstruction.constantIndex;
        this.constant = constantInstruction.constant;
        return this;
    }

    public byte canonicalOpcode() {
        return this.opcode == 19 ? (byte)18 : (byte)this.opcode;
    }

    public Instruction shrink() {
        if (this.requiredConstantIndexSize() == 1) {
            if (this.opcode == 19) {
                this.opcode = (byte)18;
            }
        } else if (this.opcode == 18) {
            this.opcode = (byte)19;
        }
        return this;
    }

    protected void readInfo(byte[] code, int offset) {
        int constantIndexSize = this.constantIndexSize();
        int constantSize = this.constantSize();
        this.constantIndex = ConstantInstruction.readValue(code, offset, constantIndexSize);
        this.constant = ConstantInstruction.readValue(code, offset += constantIndexSize, constantSize);
    }

    protected void writeInfo(byte[] code, int offset) {
        int constantIndexSize = this.constantIndexSize();
        int constantSize = this.constantSize();
        if (this.requiredConstantIndexSize() > constantIndexSize) {
            throw new IllegalArgumentException("Instruction has invalid constant index size (" + this.toString(offset) + ")");
        }
        ConstantInstruction.writeValue(code, offset, this.constantIndex, constantIndexSize);
        ConstantInstruction.writeValue(code, offset += constantIndexSize, this.constant, constantSize);
    }

    public int length(int offset) {
        return 1 + this.constantIndexSize() + this.constantSize();
    }

    public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, InstructionVisitor instructionVisitor) {
        instructionVisitor.visitConstantInstruction(clazz, method, codeAttribute, offset, this);
    }

    public int stackPopCount(Clazz clazz) {
        int stackPopCount = super.stackPopCount(clazz);
        switch (this.opcode) {
            case -59: {
                stackPopCount += this.constant;
                break;
            }
            case -77: 
            case -75: {
                clazz.constantPoolEntryAccept(this.constantIndex, this);
                stackPopCount += this.typeStackDelta;
                break;
            }
            case -74: 
            case -73: 
            case -72: 
            case -71: 
            case -70: {
                clazz.constantPoolEntryAccept(this.constantIndex, this);
                stackPopCount += this.parameterStackDelta;
            }
        }
        return stackPopCount;
    }

    public int stackPushCount(Clazz clazz) {
        int stackPushCount = super.stackPushCount(clazz);
        switch (this.opcode) {
            case -78: 
            case -76: 
            case -74: 
            case -73: 
            case -72: 
            case -71: 
            case -70: {
                clazz.constantPoolEntryAccept(this.constantIndex, this);
                stackPushCount += this.typeStackDelta;
            }
        }
        return stackPushCount;
    }

    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
    }

    public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
    }

    public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
    }

    public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
    }

    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
    }

    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
    }

    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
    }

    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        String type = fieldrefConstant.getType(clazz);
        this.typeStackDelta = ClassUtil.internalTypeSize(ClassUtil.internalMethodReturnType(type));
    }

    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        clazz.constantPoolEntryAccept(invokeDynamicConstant.u2nameAndTypeIndex, this);
    }

    public void visitInterfaceMethodrefConstant(Clazz clazz, InterfaceMethodrefConstant interfaceMethodrefConstant) {
        clazz.constantPoolEntryAccept(interfaceMethodrefConstant.u2nameAndTypeIndex, this);
    }

    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        clazz.constantPoolEntryAccept(methodrefConstant.u2nameAndTypeIndex, this);
    }

    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        String type = nameAndTypeConstant.getType(clazz);
        this.parameterStackDelta = ClassUtil.internalMethodParameterSize(type);
        this.typeStackDelta = ClassUtil.internalTypeSize(ClassUtil.internalMethodReturnType(type));
    }

    public String toString() {
        return this.getName() + " #" + this.constantIndex;
    }

    private int constantIndexSize() {
        return this.opcode == 18 ? 1 : 2;
    }

    private int constantSize() {
        return this.opcode == -59 ? 1 : (this.opcode == -70 || this.opcode == -71 ? 2 : 0);
    }

    private int requiredConstantIndexSize() {
        return (this.constantIndex & 0xFF) == this.constantIndex ? 1 : ((this.constantIndex & 0xFFFF) == this.constantIndex ? 2 : 4);
    }
}

