/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.IOException;
import java.io.OutputStream;
import proguard.io.DataEntry;
import proguard.io.DataEntryFilter;
import proguard.io.DataEntryWriter;
import proguard.io.Finisher;

public class FilteredDataEntryWriter
implements DataEntryWriter {
    private final DataEntryFilter dataEntryFilter;
    private DataEntryWriter acceptedDataEntryWriter;
    private DataEntryWriter rejectedDataEntryWriter;

    public FilteredDataEntryWriter(DataEntryFilter dataEntryFilter, DataEntryWriter acceptedDataEntryWriter) {
        this(dataEntryFilter, acceptedDataEntryWriter, null);
    }

    public FilteredDataEntryWriter(DataEntryFilter dataEntryFilter, DataEntryWriter acceptedDataEntryWriter, DataEntryWriter rejectedDataEntryWriter) {
        this.dataEntryFilter = dataEntryFilter;
        this.acceptedDataEntryWriter = acceptedDataEntryWriter;
        this.rejectedDataEntryWriter = rejectedDataEntryWriter;
    }

    public boolean createDirectory(DataEntry dataEntry) throws IOException {
        DataEntryWriter dataEntryWriter = this.dataEntryFilter.accepts(dataEntry) ? this.acceptedDataEntryWriter : this.rejectedDataEntryWriter;
        return dataEntryWriter != null && dataEntryWriter.createDirectory(dataEntry);
    }

    public OutputStream getOutputStream(DataEntry dataEntry) throws IOException {
        return this.getOutputStream(dataEntry, null);
    }

    public OutputStream getOutputStream(DataEntry dataEntry, Finisher finisher) throws IOException {
        DataEntryWriter dataEntryWriter = this.dataEntryFilter.accepts(dataEntry) ? this.acceptedDataEntryWriter : this.rejectedDataEntryWriter;
        return dataEntryWriter != null ? dataEntryWriter.getOutputStream(dataEntry, finisher) : null;
    }

    public void close() throws IOException {
        if (this.acceptedDataEntryWriter != null) {
            this.acceptedDataEntryWriter.close();
            this.acceptedDataEntryWriter = null;
        }
        if (this.rejectedDataEntryWriter != null) {
            this.rejectedDataEntryWriter.close();
            this.rejectedDataEntryWriter = null;
        }
    }
}

