/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantAdder;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.InstructionSequenceMatcher;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.optimize.peephole.BranchTargetFinder;

public class InstructionSequenceReplacer
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor {
    private static final boolean DEBUG = false;
    public static final int X = 0x40000000;
    public static final int Y = 0x40000001;
    public static final int Z = 0x40000002;
    public static final int A = 0x40000003;
    public static final int B = 0x40000004;
    public static final int C = 0x40000005;
    public static final int D = 0x40000006;
    private static final int BOOLEAN_STRING = 1;
    private static final int CHAR_STRING = 2;
    private static final int INT_STRING = 3;
    private static final int LONG_STRING = 4;
    private static final int FLOAT_STRING = 5;
    private static final int DOUBLE_STRING = 6;
    private static final int STRING_STRING = 7;
    public static final int STRING_A_LENGTH = 0x20000000;
    public static final int BOOLEAN_A_STRING = 0x20000001;
    public static final int CHAR_A_STRING = 0x20000002;
    public static final int INT_A_STRING = 0x20000003;
    public static final int LONG_A_STRING = 0x20000004;
    public static final int FLOAT_A_STRING = 0x20000005;
    public static final int DOUBLE_A_STRING = 0x20000006;
    public static final int STRING_A_STRING = 0x20000007;
    public static final int BOOLEAN_B_STRING = 0x20000010;
    public static final int CHAR_B_STRING = 0x20000020;
    public static final int INT_B_STRING = 0x20000030;
    public static final int LONG_B_STRING = 0x20000040;
    public static final int FLOAT_B_STRING = 0x20000050;
    public static final int DOUBLE_B_STRING = 0x20000060;
    public static final int STRING_B_STRING = 0x20000070;
    private final InstructionSequenceMatcher instructionSequenceMatcher;
    private final Constant[] patternConstants;
    private final Instruction[] replacementInstructions;
    private final BranchTargetFinder branchTargetFinder;
    private final CodeAttributeEditor codeAttributeEditor;
    private final InstructionVisitor extraInstructionVisitor;
    private final MyReplacementInstructionFactory replacementInstructionFactory = new MyReplacementInstructionFactory();

    public InstructionSequenceReplacer(Constant[] patternConstants, Instruction[] patternInstructions, Instruction[] replacementInstructions, BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor) {
        this(patternConstants, patternInstructions, replacementInstructions, branchTargetFinder, codeAttributeEditor, null);
    }

    public InstructionSequenceReplacer(Constant[] patternConstants, Instruction[] patternInstructions, Instruction[] replacementInstructions, BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor, InstructionVisitor extraInstructionVisitor) {
        this.instructionSequenceMatcher = new InstructionSequenceMatcher(patternConstants, patternInstructions);
        this.patternConstants = patternConstants;
        this.replacementInstructions = replacementInstructions;
        this.branchTargetFinder = branchTargetFinder;
        this.codeAttributeEditor = codeAttributeEditor;
        this.extraInstructionVisitor = extraInstructionVisitor;
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        if (this.branchTargetFinder.isTarget(offset) || this.codeAttributeEditor.isModified(offset)) {
            this.instructionSequenceMatcher.reset();
        }
        instruction.accept(clazz, method, codeAttribute, offset, this.instructionSequenceMatcher);
        if (this.instructionSequenceMatcher.isMatching() && this.matchedInstructionsUnmodified()) {
            int index;
            for (index = 0; index < this.replacementInstructions.length; ++index) {
                this.codeAttributeEditor.replaceInstruction(this.instructionSequenceMatcher.matchedInstructionOffset(index), this.replacementInstructionFactory.create(clazz, index).shrink());
            }
            for (index = this.replacementInstructions.length; index < this.instructionSequenceMatcher.instructionCount(); ++index) {
                this.codeAttributeEditor.deleteInstruction(this.instructionSequenceMatcher.matchedInstructionOffset(index));
            }
            if (this.extraInstructionVisitor != null) {
                instruction.accept(clazz, method, codeAttribute, offset, this.extraInstructionVisitor);
            }
        }
    }

    private boolean matchedInstructionsUnmodified() {
        for (int index = 0; index < this.instructionSequenceMatcher.instructionCount(); ++index) {
            if (!this.codeAttributeEditor.isModified(this.instructionSequenceMatcher.matchedInstructionOffset(index))) continue;
            return false;
        }
        return true;
    }

    private class MyReplacementInstructionFactory
    implements InstructionVisitor {
        private Instruction replacementInstruction;

        private MyReplacementInstructionFactory() {
        }

        public Instruction create(Clazz clazz, int index) {
            InstructionSequenceReplacer.this.replacementInstructions[index].accept(clazz, null, null, InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedInstructionOffset(index), this);
            return this.replacementInstruction.shrink();
        }

        public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
            this.replacementInstruction = new SimpleInstruction(simpleInstruction.opcode, this.matchedArgument(clazz, simpleInstruction.constant));
        }

        public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
            this.replacementInstruction = new VariableInstruction(variableInstruction.opcode, InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(variableInstruction.variableIndex), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(variableInstruction.constant));
        }

        public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
            this.replacementInstruction = new ConstantInstruction(constantInstruction.opcode, this.matchedConstantIndex((ProgramClass)clazz, constantInstruction.constantIndex), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(constantInstruction.constant));
        }

        public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
            this.replacementInstruction = new BranchInstruction(branchInstruction.opcode, InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedBranchOffset(offset, branchInstruction.branchOffset));
        }

        public void visitTableSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, TableSwitchInstruction tableSwitchInstruction) {
            this.replacementInstruction = new TableSwitchInstruction(tableSwitchInstruction.opcode, InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedBranchOffset(offset, tableSwitchInstruction.defaultOffset), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(tableSwitchInstruction.lowCase), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(tableSwitchInstruction.highCase), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedJumpOffsets(offset, tableSwitchInstruction.jumpOffsets));
        }

        public void visitLookUpSwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, LookUpSwitchInstruction lookUpSwitchInstruction) {
            this.replacementInstruction = new LookUpSwitchInstruction(lookUpSwitchInstruction.opcode, InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedBranchOffset(offset, lookUpSwitchInstruction.defaultOffset), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArguments(lookUpSwitchInstruction.cases), InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedJumpOffsets(offset, lookUpSwitchInstruction.jumpOffsets));
        }

        private int matchedArgument(Clazz clazz, int argument) {
            if (argument == 0x20000000) {
                return clazz.getStringString(InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(0x40000003)).length();
            }
            return InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(argument);
        }

        private int matchedConstantIndex(ProgramClass programClass, int constantIndex) {
            if (constantIndex >= 0x20000001 && constantIndex <= 0x20000077) {
                return new ConstantPoolEditor(programClass).addStringConstant(this.argumentAsString(programClass, constantIndex & 0xF, 0x40000003) + this.argumentAsString(programClass, constantIndex >>> 4 & 0xF, 0x40000004), null, null);
            }
            int matchedConstantIndex = InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedConstantIndex(constantIndex);
            if (matchedConstantIndex > 0) {
                return matchedConstantIndex;
            }
            ProgramClass dummyClass = new ProgramClass();
            dummyClass.constantPool = InstructionSequenceReplacer.this.patternConstants;
            return new ConstantAdder(programClass).addConstant((Clazz)dummyClass, constantIndex);
        }

        private String argumentAsString(ProgramClass programClass, int valueType, int argument) {
            switch (valueType) {
                case 1: {
                    return Boolean.toString((InstructionSequenceReplacer.this.instructionSequenceMatcher.wasConstant(argument) ? ((IntegerConstant)programClass.getConstant(InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedConstantIndex(argument))).getValue() : InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(argument)) != 0);
                }
                case 2: {
                    return Character.toString((char)(InstructionSequenceReplacer.this.instructionSequenceMatcher.wasConstant(argument) ? ((IntegerConstant)programClass.getConstant(InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedConstantIndex(argument))).getValue() : InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(argument)));
                }
                case 3: {
                    return Integer.toString(InstructionSequenceReplacer.this.instructionSequenceMatcher.wasConstant(argument) ? ((IntegerConstant)programClass.getConstant(InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedConstantIndex(argument))).getValue() : InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(argument));
                }
                case 4: {
                    return Long.toString(InstructionSequenceReplacer.this.instructionSequenceMatcher.wasConstant(argument) ? ((LongConstant)programClass.getConstant(InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedConstantIndex(argument))).getValue() : (long)InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(argument));
                }
                case 5: {
                    return Float.toString(InstructionSequenceReplacer.this.instructionSequenceMatcher.wasConstant(argument) ? ((FloatConstant)programClass.getConstant(InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedConstantIndex(argument))).getValue() : (float)InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(argument));
                }
                case 6: {
                    return Double.toString(InstructionSequenceReplacer.this.instructionSequenceMatcher.wasConstant(argument) ? ((DoubleConstant)programClass.getConstant(InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedConstantIndex(argument))).getValue() : (double)InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedArgument(argument));
                }
                case 7: {
                    return programClass.getStringString(InstructionSequenceReplacer.this.instructionSequenceMatcher.matchedConstantIndex(argument));
                }
            }
            return "";
        }
    }
}

