/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;

public class GPL {
    public static void check() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        new Exception().printStackTrace(new PrintStream(out));
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
        Set unknownPackageNames = GPL.unknownPackageNames(reader);
        if (unknownPackageNames.size() > 0) {
            String uniquePackageNames = GPL.uniquePackageNames(unknownPackageNames);
            System.out.println("ProGuard is released under the GNU General Public License. You therefore");
            System.out.println("must ensure that programs that link to it (" + uniquePackageNames + "...)");
            System.out.println("carry the GNU General Public License as well. Alternatively, you can");
            System.out.println("apply for an exception with the author of ProGuard.");
        }
    }

    private static Set unknownPackageNames(LineNumberReader reader) {
        HashSet<String> packageNames = new HashSet<String>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!(line = line.trim()).startsWith("at ")) continue;
                line = line.substring(2).trim();
                line = GPL.trimSuffix(line, '(');
                line = GPL.trimSuffix(line, '.');
                if ((line = GPL.trimSuffix(line, '.')).length() <= 0 || GPL.isKnown(line)) continue;
                packageNames.add(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return packageNames;
    }

    private static String uniquePackageNames(Set packageNames) {
        StringBuffer buffer = new StringBuffer();
        for (String packageName : packageNames) {
            if (GPL.containsPrefix(packageNames, packageName)) continue;
            buffer.append(packageName).append(", ");
        }
        return buffer.toString();
    }

    private static String trimSuffix(String string, char separator) {
        int index = string.lastIndexOf(separator);
        return index < 0 ? "" : string.substring(0, index);
    }

    private static boolean containsPrefix(Set set, String name) {
        int index = 0;
        while (!set.contains(name.substring(0, index))) {
            if ((index = name.indexOf(46, index + 1)) >= 0) continue;
            return false;
        }
        return true;
    }

    private static boolean isKnown(String packageName) {
        return packageName.startsWith("java") || packageName.startsWith("sun.reflect") || packageName.startsWith("proguard") || packageName.startsWith("org.apache.tools.ant") || packageName.startsWith("org.apache.tools.maven") || packageName.startsWith("org.gradle") || packageName.startsWith("org.codehaus.groovy") || packageName.startsWith("org.eclipse") || packageName.startsWith("org.netbeans") || packageName.startsWith("com.android") || packageName.startsWith("com.sun.kvem") || packageName.startsWith("com.intel") || packageName.startsWith("net.certiv.proguarddt") || packageName.startsWith("groovy") || packageName.startsWith("scala") || packageName.startsWith("sbt") || packageName.startsWith("xsbt") || packageName.startsWith("eclipseme") || packageName.startsWith("com.neomades") || packageName.startsWith("jg.j2me") || packageName.startsWith("jg.common") || packageName.startsWith("jg.buildengine");
    }

    public static void main(String[] args) {
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(System.in));
        Set unknownPackageNames = GPL.unknownPackageNames(reader);
        if (unknownPackageNames.size() > 0) {
            String uniquePackageNames = GPL.uniquePackageNames(unknownPackageNames);
            System.out.println(uniquePackageNames);
        }
    }
}

