/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import proguard.util.EmptyStringMatcher;
import proguard.util.FixedStringMatcher;
import proguard.util.OrMatcher;
import proguard.util.SettableMatcher;
import proguard.util.StringMatcher;
import proguard.util.StringParser;
import proguard.util.VariableStringMatcher;

public class ClassNameParser
implements StringParser {
    private static final char[] INTERNAL_PRIMITIVE_TYPES = new char[]{'V', 'Z', 'B', 'C', 'S', 'I', 'J', 'F', 'D'};

    public StringMatcher parse(String regularExpression) {
        int index;
        StringMatcher nextMatcher = new EmptyStringMatcher();
        for (index = 0; index < regularExpression.length(); ++index) {
            if (regularExpression.regionMatches(index, "L///;", 0, 5)) {
                SettableMatcher settableMatcher = new SettableMatcher();
                nextMatcher = new OrMatcher(this.parse(regularExpression.substring(index + 5)), this.createAnyTypeMatcher(settableMatcher));
                settableMatcher.setMatcher(nextMatcher);
                break;
            }
            if (regularExpression.regionMatches(index, "L***;", 0, 5)) {
                nextMatcher = this.createAnyTypeMatcher(this.parse(regularExpression.substring(index + 5)));
                break;
            }
            if (regularExpression.regionMatches(index, "**", 0, 2)) {
                nextMatcher = new VariableStringMatcher(null, new char[]{';'}, 0, Integer.MAX_VALUE, this.parse(regularExpression.substring(index + 2)));
                break;
            }
            if (regularExpression.charAt(index) == '*') {
                nextMatcher = new VariableStringMatcher(null, new char[]{';', '/'}, 0, Integer.MAX_VALUE, this.parse(regularExpression.substring(index + 1)));
                break;
            }
            if (regularExpression.charAt(index) == '?') {
                nextMatcher = new VariableStringMatcher(null, new char[]{';', '/'}, 1, 1, this.parse(regularExpression.substring(index + 1)));
                break;
            }
            if (regularExpression.charAt(index) != '%') continue;
            nextMatcher = new VariableStringMatcher(INTERNAL_PRIMITIVE_TYPES, null, 1, 1, this.parse(regularExpression.substring(index + 1)));
            break;
        }
        return index != 0 ? new FixedStringMatcher(regularExpression.substring(0, index), nextMatcher) : nextMatcher;
    }

    private VariableStringMatcher createAnyTypeMatcher(StringMatcher nextMatcher) {
        return new VariableStringMatcher(new char[]{'['}, null, 0, 255, new OrMatcher(new VariableStringMatcher(INTERNAL_PRIMITIVE_TYPES, null, 1, 1, nextMatcher), new VariableStringMatcher(new char[]{'L'}, null, 1, 1, new VariableStringMatcher(null, new char[]{';'}, 0, Integer.MAX_VALUE, new VariableStringMatcher(new char[]{';'}, null, 1, 1, nextMatcher)))));
    }

    public static void main(String[] args) {
        try {
            System.out.println("Regular expression [" + args[0] + "]");
            ClassNameParser parser = new ClassNameParser();
            StringMatcher matcher = parser.parse(args[0]);
            for (int index = 1; index < args.length; ++index) {
                String string = args[index];
                System.out.print("String             [" + string + "]");
                System.out.println(" -> match = " + matcher.matches(args[index]));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

