/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;

public class InterfaceSorter
extends SimplifiedVisitor
implements ClassVisitor,
AttributeVisitor {
    public void visitProgramClass(ProgramClass programClass) {
        int[] interfaces = programClass.u2interfaces;
        int interfacesCount = programClass.u2interfacesCount;
        if (interfacesCount > 1) {
            Arrays.sort(interfaces, 0, interfacesCount);
            int newInterfacesCount = 0;
            int previousInterfaceIndex = 0;
            for (int index = 0; index < interfacesCount; ++index) {
                int interfaceIndex = interfaces[index];
                if (interfaceIndex == previousInterfaceIndex) continue;
                interfaces[newInterfacesCount++] = interfaceIndex;
                previousInterfaceIndex = interfaceIndex;
            }
            programClass.u2interfacesCount = newInterfacesCount;
            programClass.attributesAccept(this);
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        String signature = signatureAttribute.getSignature(clazz);
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(signature);
        int count = 0;
        int interfacesCount = -1;
        while (internalTypeEnumeration.hasMoreTypes()) {
            String internalType = internalTypeEnumeration.nextType();
            ++count;
            if (!ClassUtil.isInternalClassType(internalType)) continue;
            ++interfacesCount;
        }
        internalTypeEnumeration = new InternalTypeEnumeration(signature);
        Object[] internalTypes = new String[count];
        for (int index = 0; index < count; ++index) {
            String internalType = internalTypeEnumeration.nextType();
            internalTypes[index] = internalType;
        }
        Arrays.sort(internalTypes, count - interfacesCount, count);
        StringBuffer newSignatureBuffer = new StringBuffer();
        for (int index = 0; index < count; ++index) {
            if (index >= count - interfacesCount && ((String)internalTypes[index]).equals(internalTypes[index - 1])) continue;
            newSignatureBuffer.append((String)internalTypes[index]);
        }
        String newSignature = newSignatureBuffer.toString();
        if (!newSignature.equals(signature)) {
            ((Utf8Constant)((ProgramClass)clazz).constantPool[signatureAttribute.u2signatureIndex]).setString(newSignatureBuffer.toString());
            signatureAttribute.referencedClasses = null;
        }
    }
}

