/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import proguard.classfile.Clazz;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.util.WarningPrinter;

public class GetSignatureChecker
extends SimplifiedVisitor
implements ConstantVisitor {
    private final WarningPrinter notePrinter;

    public GetSignatureChecker(WarningPrinter notePrinter) {
        this.notePrinter = notePrinter;
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        String methodName;
        String className = methodrefConstant.getClassName(clazz);
        if ((className.equals("java/lang/Class") || className.equals("java/lang/reflect/Field") || className.equals("java/lang/reflect/Method")) && ((methodName = methodrefConstant.getName(clazz)).startsWith("getType") || methodName.startsWith("getGeneric"))) {
            this.notePrinter.print(clazz.getName(), "Note: " + ClassUtil.externalClassName(clazz.getName()) + " calls '" + ClassUtil.externalShortClassName(ClassUtil.externalClassName(className)) + "." + methodName + "'");
        }
    }
}

