/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.editor.InterfaceDeleter;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;

public class InterfaceSorter
extends SimplifiedVisitor
implements ClassVisitor,
AttributeVisitor {
    public void visitProgramClass(ProgramClass programClass) {
        int[] interfaces = programClass.u2interfaces;
        int interfacesCount = programClass.u2interfacesCount;
        if (interfacesCount > 1) {
            Arrays.sort(interfaces, 0, interfacesCount);
            programClass.attributesAccept(this);
            boolean[] delete = null;
            for (int index = 1; index < interfacesCount; ++index) {
                Clazz interfaceClass = programClass.getInterface(index);
                if (interfaces[index] != interfaces[index - 1]) continue;
                if (delete == null) {
                    delete = new boolean[interfacesCount];
                }
                delete[index] = true;
            }
            if (delete != null) {
                new InterfaceDeleter(delete).visitProgramClass(programClass);
            }
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        String signature = signatureAttribute.getSignature(clazz);
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(signature);
        int count = 0;
        int interfacesCount = -1;
        while (internalTypeEnumeration.hasMoreTypes()) {
            String internalType = internalTypeEnumeration.nextType();
            ++count;
            if (!ClassUtil.isInternalClassType(internalType)) continue;
            ++interfacesCount;
        }
        internalTypeEnumeration = new InternalTypeEnumeration(signature);
        Object[] internalTypes = new String[count];
        for (int index = 0; index < count; ++index) {
            String internalType = internalTypeEnumeration.nextType();
            internalTypes[index] = internalType;
        }
        Arrays.sort(internalTypes, count - interfacesCount, count);
        StringBuffer newSignatureBuffer = new StringBuffer();
        for (int index = 0; index < count; ++index) {
            newSignatureBuffer.append((String)internalTypes[index]);
        }
        String newSignature = newSignatureBuffer.toString();
        if (!newSignature.equals(signature)) {
            ((Utf8Constant)((ProgramClass)clazz).constantPool[signatureAttribute.u2signatureIndex]).setString(newSignatureBuffer.toString());
            signatureAttribute.referencedClasses = null;
        }
    }
}

