/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

public class InternalTypeEnumeration {
    private String descriptor;
    private int firstIndex;
    private int lastIndex;
    private int index;

    public InternalTypeEnumeration(String descriptor) {
        this.descriptor = descriptor;
        this.firstIndex = descriptor.indexOf(40);
        this.lastIndex = descriptor.indexOf(41);
        this.index = this.firstIndex + 1;
        if (this.lastIndex < 0) {
            this.lastIndex = descriptor.length();
        }
    }

    public boolean isMethodSignature() {
        return this.firstIndex >= 0;
    }

    public String formalTypeParameters() {
        return this.descriptor.substring(0, this.firstIndex);
    }

    public boolean hasMoreTypes() {
        return this.index < this.lastIndex;
    }

    public String nextType() {
        int startIndex = this.index;
        this.skipArray();
        char c = this.descriptor.charAt(this.index++);
        switch (c) {
            case 'L': 
            case 'T': {
                this.skipClass();
                break;
            }
            case '<': {
                this.skipGeneric();
            }
        }
        return this.descriptor.substring(startIndex, this.index);
    }

    public String returnType() {
        return this.descriptor.substring(this.lastIndex + 1);
    }

    private void skipArray() {
        while (this.descriptor.charAt(this.index) == '[') {
            ++this.index;
        }
    }

    private void skipClass() {
        while (true) {
            char c = this.descriptor.charAt(this.index++);
            switch (c) {
                case '<': {
                    this.skipGeneric();
                    break;
                }
                case ';': {
                    return;
                }
            }
        }
    }

    private void skipGeneric() {
        int nestingLevel = 1;
        do {
            char c = this.descriptor.charAt(this.index++);
            switch (c) {
                case '<': {
                    ++nestingLevel;
                    break;
                }
                case '>': {
                    --nestingLevel;
                }
            }
        } while (nestingLevel > 0);
    }

    public static void main(String[] args) {
        try {
            for (int index = 0; index < args.length; ++index) {
                String descriptor = args[index];
                System.out.println("Descriptor [" + descriptor + "]");
                InternalTypeEnumeration enumeration = new InternalTypeEnumeration(descriptor);
                if (enumeration.firstIndex >= 0) {
                    System.out.println("  Formal type parameters [" + enumeration.formalTypeParameters() + "]");
                }
                while (enumeration.hasMoreTypes()) {
                    System.out.println("  Type [" + enumeration.nextType() + "]");
                }
                if (enumeration.lastIndex >= descriptor.length()) continue;
                System.out.println("  Return type [" + enumeration.returnType() + "]");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

