/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import proguard.ArgumentWordReader;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.ClassSpecification;
import proguard.Configuration;
import proguard.ConfigurationConstants;
import proguard.FileWordReader;
import proguard.KeepClassSpecification;
import proguard.LineWordReader;
import proguard.MemberSpecification;
import proguard.ParseException;
import proguard.WordReader;
import proguard.classfile.util.ClassUtil;
import proguard.util.ListUtil;

public class ConfigurationParser {
    private final WordReader reader;
    private final Properties properties;
    private String nextWord;
    private String lastComments;

    public ConfigurationParser(String[] args, Properties properties) throws IOException {
        this(args, null, properties);
    }

    public ConfigurationParser(String[] args, File baseDir, Properties properties) throws IOException {
        this(new ArgumentWordReader(args, baseDir), properties);
    }

    public ConfigurationParser(String lines, String description, File baseDir, Properties properties) throws IOException {
        this(new LineWordReader(new LineNumberReader(new StringReader(lines)), description, baseDir), properties);
    }

    public ConfigurationParser(File file) throws IOException {
        this(file, System.getProperties());
    }

    public ConfigurationParser(File file, Properties properties) throws IOException {
        this(new FileWordReader(file), properties);
    }

    public ConfigurationParser(URL url, Properties properties) throws IOException {
        this(new FileWordReader(url), properties);
    }

    public ConfigurationParser(WordReader reader, Properties properties) throws IOException {
        this.reader = reader;
        this.properties = properties;
        this.readNextWord();
    }

    public void parse(Configuration configuration) throws ParseException, IOException {
        while (this.nextWord != null) {
            this.lastComments = this.reader.lastComments();
            if ("@".startsWith(this.nextWord) || "-include".startsWith(this.nextWord)) {
                configuration.lastModified = this.parseIncludeArgument(configuration.lastModified);
                continue;
            }
            if ("-basedirectory".startsWith(this.nextWord)) {
                this.parseBaseDirectoryArgument();
                continue;
            }
            if ("-injars".startsWith(this.nextWord)) {
                configuration.programJars = this.parseClassPathArgument(configuration.programJars, false);
                continue;
            }
            if ("-outjars".startsWith(this.nextWord)) {
                configuration.programJars = this.parseClassPathArgument(configuration.programJars, true);
                continue;
            }
            if ("-libraryjars".startsWith(this.nextWord)) {
                configuration.libraryJars = this.parseClassPathArgument(configuration.libraryJars, false);
                continue;
            }
            if ("-resourcejars".startsWith(this.nextWord)) {
                throw new ParseException("The '-resourcejars' option is no longer supported. Please use the '-injars' option for all input");
            }
            if ("-skipnonpubliclibraryclasses".startsWith(this.nextWord)) {
                configuration.skipNonPublicLibraryClasses = this.parseNoArgument(true);
                continue;
            }
            if ("-dontskipnonpubliclibraryclasses".startsWith(this.nextWord)) {
                configuration.skipNonPublicLibraryClasses = this.parseNoArgument(false);
                continue;
            }
            if ("-dontskipnonpubliclibraryclassmembers".startsWith(this.nextWord)) {
                configuration.skipNonPublicLibraryClassMembers = this.parseNoArgument(false);
                continue;
            }
            if ("-target".startsWith(this.nextWord)) {
                configuration.targetClassVersion = this.parseClassVersion();
                continue;
            }
            if ("-forceprocessing".startsWith(this.nextWord)) {
                configuration.lastModified = this.parseNoArgument(Long.MAX_VALUE);
                continue;
            }
            if ("-keep".startsWith(this.nextWord)) {
                configuration.keep = this.parseKeepClassSpecificationArguments(configuration.keep, true, false, false);
                continue;
            }
            if ("-keepclassmembers".startsWith(this.nextWord)) {
                configuration.keep = this.parseKeepClassSpecificationArguments(configuration.keep, false, false, false);
                continue;
            }
            if ("-keepclasseswithmembers".startsWith(this.nextWord)) {
                configuration.keep = this.parseKeepClassSpecificationArguments(configuration.keep, false, true, false);
                continue;
            }
            if ("-keepnames".startsWith(this.nextWord)) {
                configuration.keep = this.parseKeepClassSpecificationArguments(configuration.keep, true, false, true);
                continue;
            }
            if ("-keepclassmembernames".startsWith(this.nextWord)) {
                configuration.keep = this.parseKeepClassSpecificationArguments(configuration.keep, false, false, true);
                continue;
            }
            if ("-keepclasseswithmembernames".startsWith(this.nextWord)) {
                configuration.keep = this.parseKeepClassSpecificationArguments(configuration.keep, false, true, true);
                continue;
            }
            if ("-printseeds".startsWith(this.nextWord)) {
                configuration.printSeeds = this.parseOptionalFile();
                continue;
            }
            if ("-keepdirectories".startsWith(this.nextWord)) {
                configuration.keepDirectories = this.parseCommaSeparatedList("directory name", true, true, false, true, false, true, false, false, configuration.keepDirectories);
                continue;
            }
            if ("-dontshrink".startsWith(this.nextWord)) {
                configuration.shrink = this.parseNoArgument(false);
                continue;
            }
            if ("-printusage".startsWith(this.nextWord)) {
                configuration.printUsage = this.parseOptionalFile();
                continue;
            }
            if ("-whyareyoukeeping".startsWith(this.nextWord)) {
                configuration.whyAreYouKeeping = this.parseClassSpecificationArguments(configuration.whyAreYouKeeping);
                continue;
            }
            if ("-dontoptimize".startsWith(this.nextWord)) {
                configuration.optimize = this.parseNoArgument(false);
                continue;
            }
            if ("-optimizationpasses".startsWith(this.nextWord)) {
                configuration.optimizationPasses = this.parseIntegerArgument();
                continue;
            }
            if ("-optimizations".startsWith(this.nextWord)) {
                configuration.optimizations = this.parseCommaSeparatedList("optimization name", true, false, false, false, false, false, false, false, configuration.optimizations);
                continue;
            }
            if ("-assumenosideeffects".startsWith(this.nextWord)) {
                configuration.assumeNoSideEffects = this.parseClassSpecificationArguments(configuration.assumeNoSideEffects);
                continue;
            }
            if ("-allowaccessmodification".startsWith(this.nextWord)) {
                configuration.allowAccessModification = this.parseNoArgument(true);
                continue;
            }
            if ("-mergeinterfacesaggressively".startsWith(this.nextWord)) {
                configuration.mergeInterfacesAggressively = this.parseNoArgument(true);
                continue;
            }
            if ("-dontobfuscate".startsWith(this.nextWord)) {
                configuration.obfuscate = this.parseNoArgument(false);
                continue;
            }
            if ("-printmapping".startsWith(this.nextWord)) {
                configuration.printMapping = this.parseOptionalFile();
                continue;
            }
            if ("-applymapping".startsWith(this.nextWord)) {
                configuration.applyMapping = this.parseFile();
                continue;
            }
            if ("-obfuscationdictionary".startsWith(this.nextWord)) {
                configuration.obfuscationDictionary = this.parseFile();
                continue;
            }
            if ("-classobfuscationdictionary".startsWith(this.nextWord)) {
                configuration.classObfuscationDictionary = this.parseFile();
                continue;
            }
            if ("-packageobfuscationdictionary".startsWith(this.nextWord)) {
                configuration.packageObfuscationDictionary = this.parseFile();
                continue;
            }
            if ("-overloadaggressively".startsWith(this.nextWord)) {
                configuration.overloadAggressively = this.parseNoArgument(true);
                continue;
            }
            if ("-useuniqueclassmembernames".startsWith(this.nextWord)) {
                configuration.useUniqueClassMemberNames = this.parseNoArgument(true);
                continue;
            }
            if ("-dontusemixedcaseclassnames".startsWith(this.nextWord)) {
                configuration.useMixedCaseClassNames = this.parseNoArgument(false);
                continue;
            }
            if ("-keeppackagenames".startsWith(this.nextWord)) {
                configuration.keepPackageNames = this.parseCommaSeparatedList("package name", true, true, false, false, true, false, true, false, configuration.keepPackageNames);
                continue;
            }
            if ("-flattenpackagehierarchy".startsWith(this.nextWord)) {
                configuration.flattenPackageHierarchy = ClassUtil.internalClassName(this.parseOptionalArgument());
                continue;
            }
            if ("-repackageclasses".startsWith(this.nextWord)) {
                configuration.repackageClasses = ClassUtil.internalClassName(this.parseOptionalArgument());
                continue;
            }
            if ("-defaultpackage".startsWith(this.nextWord)) {
                configuration.repackageClasses = ClassUtil.internalClassName(this.parseOptionalArgument());
                continue;
            }
            if ("-keepattributes".startsWith(this.nextWord)) {
                configuration.keepAttributes = this.parseCommaSeparatedList("attribute name", true, true, false, false, true, false, false, false, configuration.keepAttributes);
                continue;
            }
            if ("-keepparameternames".startsWith(this.nextWord)) {
                configuration.keepParameterNames = this.parseNoArgument(true);
                continue;
            }
            if ("-renamesourcefileattribute".startsWith(this.nextWord)) {
                configuration.newSourceFileAttribute = this.parseOptionalArgument();
                continue;
            }
            if ("-adaptclassstrings".startsWith(this.nextWord)) {
                configuration.adaptClassStrings = this.parseCommaSeparatedList("class name", true, true, false, false, true, false, true, false, configuration.adaptClassStrings);
                continue;
            }
            if ("-adaptresourcefilenames".startsWith(this.nextWord)) {
                configuration.adaptResourceFileNames = this.parseCommaSeparatedList("resource file name", true, true, false, true, false, false, false, false, configuration.adaptResourceFileNames);
                continue;
            }
            if ("-adaptresourcefilecontents".startsWith(this.nextWord)) {
                configuration.adaptResourceFileContents = this.parseCommaSeparatedList("resource file name", true, true, false, true, false, false, false, false, configuration.adaptResourceFileContents);
                continue;
            }
            if ("-dontpreverify".startsWith(this.nextWord)) {
                configuration.preverify = this.parseNoArgument(false);
                continue;
            }
            if ("-microedition".startsWith(this.nextWord)) {
                configuration.microEdition = this.parseNoArgument(true);
                continue;
            }
            if ("-verbose".startsWith(this.nextWord)) {
                configuration.verbose = this.parseNoArgument(true);
                continue;
            }
            if ("-dontnote".startsWith(this.nextWord)) {
                configuration.note = this.parseCommaSeparatedList("class name", true, true, false, false, true, false, true, false, configuration.note);
                continue;
            }
            if ("-dontwarn".startsWith(this.nextWord)) {
                configuration.warn = this.parseCommaSeparatedList("class name", true, true, false, false, true, false, true, false, configuration.warn);
                continue;
            }
            if ("-ignorewarnings".startsWith(this.nextWord)) {
                configuration.ignoreWarnings = this.parseNoArgument(true);
                continue;
            }
            if ("-printconfiguration".startsWith(this.nextWord)) {
                configuration.printConfiguration = this.parseOptionalFile();
                continue;
            }
            if ("-dump".startsWith(this.nextWord)) {
                configuration.dump = this.parseOptionalFile();
                continue;
            }
            throw new ParseException("Unknown option " + this.reader.locationDescription());
        }
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    private long parseIncludeArgument(long lastModified) throws ParseException, IOException {
        this.readNextWord("configuration file name", true, false);
        File file = this.file(this.nextWord);
        this.reader.includeWordReader(new FileWordReader(file));
        this.readNextWord();
        return Math.max(lastModified, file.lastModified());
    }

    private void parseBaseDirectoryArgument() throws ParseException, IOException {
        this.readNextWord("base directory name", true, false);
        this.reader.setBaseDir(this.file(this.nextWord));
        this.readNextWord();
    }

    private ClassPath parseClassPathArgument(ClassPath classPath, boolean isOutput) throws ParseException, IOException {
        if (classPath == null) {
            classPath = new ClassPath();
        }
        do {
            this.readNextWord("jar or directory name", true, false);
            ClassPathEntry entry = new ClassPathEntry(this.file(this.nextWord), isOutput);
            this.readNextWord();
            if (!this.configurationEnd() && "(".equals(this.nextWord)) {
                List[] filters = new List[7];
                int counter = 0;
                do {
                    filters[counter++] = this.parseCommaSeparatedList("filter", true, true, true, true, false, true, false, false, null);
                } while (counter < filters.length && ";".equals(this.nextWord));
                if (!")".equals(this.nextWord)) {
                    throw new ParseException("Expecting separating ',' or ';', or closing ')' before " + this.reader.locationDescription());
                }
                entry.setFilter(filters[--counter]);
                if (counter > 0) {
                    entry.setJarFilter(filters[--counter]);
                    if (counter > 0) {
                        entry.setWarFilter(filters[--counter]);
                        if (counter > 0) {
                            entry.setEarFilter(filters[--counter]);
                            if (counter > 0) {
                                entry.setZipFilter(filters[--counter]);
                                if (counter > 0) {
                                    entry.setApkFilter(filters[--counter]);
                                    if (counter > 0) {
                                        entry.setAarFilter(filters[--counter]);
                                    }
                                }
                            }
                        }
                    }
                }
                this.readNextWord();
            }
            classPath.add(entry);
            if (!this.configurationEnd()) continue;
            return classPath;
        } while (this.nextWord.equals(ConfigurationConstants.JAR_SEPARATOR_KEYWORD));
        throw new ParseException("Expecting class path separator '" + ConfigurationConstants.JAR_SEPARATOR_KEYWORD + "' before " + this.reader.locationDescription());
    }

    private int parseClassVersion() throws ParseException, IOException {
        this.readNextWord("java version");
        int classVersion = ClassUtil.internalClassVersion(this.nextWord);
        if (classVersion == 0) {
            throw new ParseException("Unsupported java version " + this.reader.locationDescription());
        }
        this.readNextWord();
        return classVersion;
    }

    private int parseIntegerArgument() throws ParseException, IOException {
        try {
            this.readNextWord("integer");
            int integer = Integer.parseInt(this.nextWord);
            this.readNextWord();
            return integer;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Expecting integer argument instead of '" + this.nextWord + "' before " + this.reader.locationDescription());
        }
    }

    private File parseFile() throws ParseException, IOException {
        this.readNextWord("file name", true, false);
        File file = this.file(this.nextWord);
        this.readNextWord();
        return file;
    }

    private File parseOptionalFile() throws ParseException, IOException {
        this.readNextWord(true);
        if (this.configurationEnd()) {
            return Configuration.STD_OUT;
        }
        File file = this.file(this.nextWord);
        this.readNextWord();
        return file;
    }

    private String parseOptionalArgument() throws IOException {
        this.readNextWord();
        if (this.configurationEnd()) {
            return "";
        }
        String argument = this.nextWord;
        this.readNextWord();
        return argument;
    }

    private boolean parseNoArgument(boolean value) throws IOException {
        this.readNextWord();
        return value;
    }

    private long parseNoArgument(long value) throws IOException {
        this.readNextWord();
        return value;
    }

    private List parseKeepClassSpecificationArguments(List keepClassSpecifications, boolean markClasses, boolean markConditionally, boolean allowShrinking) throws ParseException, IOException {
        boolean allowObfuscation;
        boolean allowOptimization;
        boolean markDescriptorClasses;
        block5: {
            if (keepClassSpecifications == null) {
                keepClassSpecifications = new ArrayList<KeepClassSpecification>();
            }
            markDescriptorClasses = false;
            allowOptimization = false;
            allowObfuscation = false;
            while (true) {
                this.readNextWord("keyword 'class', 'interface', or 'enum'", false, true);
                if (!",".equals(this.nextWord)) break block5;
                this.readNextWord("keyword 'allowshrinking', 'allowoptimization', or 'allowobfuscation'");
                if ("includedescriptorclasses".startsWith(this.nextWord)) {
                    markDescriptorClasses = true;
                    continue;
                }
                if ("allowshrinking".startsWith(this.nextWord)) {
                    allowShrinking = true;
                    continue;
                }
                if ("allowoptimization".startsWith(this.nextWord)) {
                    allowOptimization = true;
                    continue;
                }
                if (!"allowobfuscation".startsWith(this.nextWord)) break;
                allowObfuscation = true;
            }
            throw new ParseException("Expecting keyword 'includedescriptorclasses', 'allowshrinking', 'allowoptimization', or 'allowobfuscation' before " + this.reader.locationDescription());
        }
        ClassSpecification classSpecification = this.parseClassSpecificationArguments();
        keepClassSpecifications.add(new KeepClassSpecification(markClasses, markConditionally, markDescriptorClasses, allowShrinking, allowOptimization, allowObfuscation, classSpecification));
        return keepClassSpecifications;
    }

    private List parseClassSpecificationArguments(List classSpecifications) throws ParseException, IOException {
        if (classSpecifications == null) {
            classSpecifications = new ArrayList<ClassSpecification>();
        }
        this.readNextWord("keyword 'class', 'interface', or 'enum'", false, true);
        classSpecifications.add(this.parseClassSpecificationArguments());
        return classSpecifications;
    }

    public ClassSpecification parseClassSpecificationArguments() throws ParseException, IOException {
        String externalClassName;
        String annotationType = null;
        int requiredSetClassAccessFlags = 0;
        int requiredUnsetClassAccessFlags = 0;
        while (!"class".equals(this.nextWord)) {
            int accessFlag;
            String strippedWord;
            boolean negated = this.nextWord.startsWith("!");
            String string = strippedWord = negated ? this.nextWord.substring(1) : this.nextWord;
            int n = strippedWord.equals("public") ? 1 : (strippedWord.equals("final") ? 16 : (strippedWord.equals("interface") ? 512 : (strippedWord.equals("abstract") ? 1024 : (strippedWord.equals("synthetic") ? 4096 : (strippedWord.equals("@") ? 8192 : (accessFlag = strippedWord.equals("enum") ? 16384 : this.unknownAccessFlag()))))));
            if (accessFlag == 8192) {
                this.readNextWord("annotation type or keyword 'interface'", false, false);
                if (!(this.nextWord.equals("interface") || this.nextWord.equals("enum") || this.nextWord.equals("class"))) {
                    annotationType = ListUtil.commaSeparatedString(this.parseCommaSeparatedList("annotation type", false, false, false, false, true, false, false, true, null), false);
                    continue;
                }
            }
            if (!negated) {
                requiredSetClassAccessFlags |= accessFlag;
            } else {
                requiredUnsetClassAccessFlags |= accessFlag;
            }
            if ((requiredSetClassAccessFlags & requiredUnsetClassAccessFlags) != 0) {
                throw new ParseException("Conflicting class access modifiers for '" + strippedWord + "' before " + this.reader.locationDescription());
            }
            if (strippedWord.equals("interface") || strippedWord.equals("enum") || strippedWord.equals("class")) break;
            if (accessFlag == 8192) continue;
            this.readNextWord("keyword 'class', 'interface', or 'enum'", false, true);
        }
        String className = "*".equals(externalClassName = ListUtil.commaSeparatedString(this.parseCommaSeparatedList("class name or interface name", true, false, false, false, true, false, false, false, null), false)) ? null : ClassUtil.internalClassName(externalClassName);
        String extendsAnnotationType = null;
        String extendsClassName = null;
        if (!this.configurationEnd() && ("implements".equals(this.nextWord) || "extends".equals(this.nextWord))) {
            String externalExtendsClassName;
            this.readNextWord("class name or interface name", false, true);
            if ("@".equals(this.nextWord)) {
                extendsAnnotationType = ListUtil.commaSeparatedString(this.parseCommaSeparatedList("annotation type", true, false, false, false, true, false, false, true, null), false);
            }
            extendsClassName = "*".equals(externalExtendsClassName = ListUtil.commaSeparatedString(this.parseCommaSeparatedList("class name or interface name", false, false, false, false, true, false, false, false, null), false)) ? null : ClassUtil.internalClassName(externalExtendsClassName);
        }
        ClassSpecification classSpecification = new ClassSpecification(this.lastComments, requiredSetClassAccessFlags, requiredUnsetClassAccessFlags, annotationType, className, extendsAnnotationType, extendsClassName);
        if (!this.configurationEnd()) {
            if (!"{".equals(this.nextWord)) {
                throw new ParseException("Expecting opening '{' at " + this.reader.locationDescription());
            }
            while (true) {
                this.readNextWord("class member description or closing '}'", false, true);
                if (this.nextWord.equals("}")) {
                    this.readNextWord();
                    break;
                }
                this.parseMemberSpecificationArguments(externalClassName, classSpecification);
            }
        }
        return classSpecification;
    }

    private void parseMemberSpecificationArguments(String externalClassName, ClassSpecification classSpecification) throws ParseException, IOException {
        String annotationType = null;
        int requiredSetMemberAccessFlags = 0;
        int requiredUnsetMemberAccessFlags = 0;
        while (!this.configurationEnd(true)) {
            int accessFlag;
            String strippedWord;
            if ("@".equals(this.nextWord)) {
                annotationType = ListUtil.commaSeparatedString(this.parseCommaSeparatedList("annotation type", true, false, false, false, true, false, false, true, null), false);
                continue;
            }
            String string = strippedWord = this.nextWord.startsWith("!") ? this.nextWord.substring(1) : this.nextWord;
            int n = strippedWord.equals("public") ? 1 : (strippedWord.equals("private") ? 2 : (strippedWord.equals("protected") ? 4 : (strippedWord.equals("static") ? 8 : (strippedWord.equals("final") ? 16 : (strippedWord.equals("synchronized") ? 32 : (strippedWord.equals("volatile") ? 64 : (strippedWord.equals("transient") ? 128 : (strippedWord.equals("bridge") ? 64 : (strippedWord.equals("varargs") ? 128 : (strippedWord.equals("native") ? 256 : (strippedWord.equals("abstract") ? 1024 : (strippedWord.equals("strictfp") ? 2048 : (accessFlag = strippedWord.equals("synthetic") ? 4096 : 0)))))))))))));
            if (accessFlag == 0) break;
            if (strippedWord.equals(this.nextWord)) {
                requiredSetMemberAccessFlags |= accessFlag;
            } else {
                requiredUnsetMemberAccessFlags |= accessFlag;
            }
            if ((requiredSetMemberAccessFlags & requiredUnsetMemberAccessFlags) != 0) {
                throw new ParseException("Conflicting class member access modifiers for " + this.reader.locationDescription());
            }
            this.readNextWord("class member description");
        }
        if ("*".equals(this.nextWord) || "<fields>".equals(this.nextWord) || "<methods>".equals(this.nextWord)) {
            if ("*".equals(this.nextWord)) {
                this.checkFieldAccessFlags(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags);
                this.checkMethodAccessFlags(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags);
                classSpecification.addField(new MemberSpecification(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags, annotationType, null, null));
                classSpecification.addMethod(new MemberSpecification(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags, annotationType, null, null));
            } else if ("<fields>".equals(this.nextWord)) {
                this.checkFieldAccessFlags(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags);
                classSpecification.addField(new MemberSpecification(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags, annotationType, null, null));
            } else if ("<methods>".equals(this.nextWord)) {
                this.checkMethodAccessFlags(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags);
                classSpecification.addMethod(new MemberSpecification(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags, annotationType, null, null));
            }
            this.readNextWord("separator ';'");
            if (!";".equals(this.nextWord)) {
                throw new ParseException("Expecting separator ';' before " + this.reader.locationDescription());
            }
        } else {
            this.checkJavaIdentifier("java type");
            String type = this.nextWord;
            this.readNextWord("class member name");
            String name = this.nextWord;
            if ("(".equals(name)) {
                if (!(type.equals("<init>") || type.equals(externalClassName) || type.equals(ClassUtil.externalShortClassName(externalClassName)))) {
                    throw new ParseException("Expecting type and name instead of just '" + type + "' before " + this.reader.locationDescription());
                }
                type = "void";
                name = "<init>";
            } else {
                this.checkJavaIdentifier("class member name");
                this.readNextWord("opening '(' or separator ';'");
            }
            if (";".equals(this.nextWord)) {
                this.checkFieldAccessFlags(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags);
                String descriptor = ClassUtil.internalType(type);
                classSpecification.addField(new MemberSpecification(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags, annotationType, name, descriptor));
            } else if ("(".equals(this.nextWord)) {
                this.checkMethodAccessFlags(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags);
                String descriptor = ClassUtil.internalMethodDescriptor(type, this.parseCommaSeparatedList("argument", true, true, true, false, true, false, false, false, null));
                if (!")".equals(this.nextWord)) {
                    throw new ParseException("Expecting separating ',' or closing ')' before " + this.reader.locationDescription());
                }
                this.readNextWord("separator ';'");
                if (!";".equals(this.nextWord)) {
                    throw new ParseException("Expecting separator ';' before " + this.reader.locationDescription());
                }
                classSpecification.addMethod(new MemberSpecification(requiredSetMemberAccessFlags, requiredUnsetMemberAccessFlags, annotationType, name, descriptor));
            } else {
                throw new ParseException("Expecting opening '(' or separator ';' before " + this.reader.locationDescription());
            }
        }
    }

    private List parseCommaSeparatedList(String expectedDescription, boolean readFirstWord, boolean allowEmptyList, boolean expectClosingParenthesis, boolean isFileName, boolean checkJavaIdentifiers, boolean replaceSystemProperties, boolean replaceExternalClassNames, boolean replaceExternalTypes, List list) throws ParseException, IOException {
        if (list == null) {
            list = new ArrayList<String>();
        }
        if (readFirstWord) {
            if (!allowEmptyList) {
                this.readNextWord(expectedDescription, isFileName, false);
            } else if (expectClosingParenthesis) {
                this.readNextWord(expectedDescription, isFileName, false);
                if (this.nextWord.length() == 0) {
                    this.readNextWord("closing ')'");
                    return list;
                }
                if (this.nextWord.equals(")")) {
                    return list;
                }
            } else {
                this.readNextWord(isFileName);
                if (this.configurationEnd()) {
                    return list;
                }
            }
        }
        while (true) {
            if (checkJavaIdentifiers) {
                this.checkJavaIdentifier("java type");
            }
            if (replaceSystemProperties) {
                this.nextWord = this.replaceSystemProperties(this.nextWord);
            }
            if (replaceExternalClassNames) {
                this.nextWord = ClassUtil.internalClassName(this.nextWord);
            }
            if (replaceExternalTypes) {
                this.nextWord = ClassUtil.internalType(this.nextWord);
            }
            list.add(this.nextWord);
            if (expectClosingParenthesis) {
                this.readNextWord("separating ',' or closing ')'");
            } else {
                this.readNextWord();
            }
            if (!",".equals(this.nextWord)) {
                return list;
            }
            this.readNextWord(expectedDescription, isFileName, false);
        }
    }

    private int unknownAccessFlag() throws ParseException {
        throw new ParseException("Unexpected keyword " + this.reader.locationDescription());
    }

    private File file(String word) throws ParseException {
        String fileName = this.replaceSystemProperties(word);
        File file = new File(fileName);
        if (!file.isAbsolute()) {
            file = new File(this.reader.getBaseDir(), fileName);
        }
        return file;
    }

    private String replaceSystemProperties(String word) throws ParseException {
        int toIndex;
        int fromIndex = 0;
        while ((fromIndex = word.indexOf(60, fromIndex)) >= 0 && (toIndex = word.indexOf(62, fromIndex + 1)) >= 0) {
            String propertyName = word.substring(fromIndex + 1, toIndex);
            String propertyValue = this.properties.getProperty(propertyName);
            if (propertyValue == null) {
                throw new ParseException("Value of system property '" + propertyName + "' is undefined in " + this.reader.locationDescription());
            }
            word = word.substring(0, fromIndex) + propertyValue + word.substring(toIndex + 1);
            fromIndex += propertyValue.length();
        }
        return word;
    }

    private void readNextWord(String expectedDescription) throws ParseException, IOException {
        this.readNextWord(expectedDescription, false, false);
    }

    private void readNextWord(String expectedDescription, boolean isFileName, boolean expectingAtCharacter) throws ParseException, IOException {
        this.readNextWord(isFileName);
        if (this.configurationEnd(expectingAtCharacter)) {
            throw new ParseException("Expecting " + expectedDescription + " before " + this.reader.locationDescription());
        }
    }

    private void readNextWord() throws IOException {
        this.readNextWord(false);
    }

    private void readNextWord(boolean isFileName) throws IOException {
        this.nextWord = this.reader.nextWord(isFileName);
    }

    private boolean configurationEnd() {
        return this.configurationEnd(false);
    }

    private boolean configurationEnd(boolean expectingAtCharacter) {
        return this.nextWord == null || this.nextWord.startsWith("-") || !expectingAtCharacter && this.nextWord.equals("@");
    }

    private void checkJavaIdentifier(String expectedDescription) throws ParseException {
        if (!this.isJavaIdentifier(this.nextWord)) {
            throw new ParseException("Expecting " + expectedDescription + " before " + this.reader.locationDescription());
        }
    }

    private boolean isJavaIdentifier(String aWord) {
        if (aWord.length() == 0) {
            return false;
        }
        for (int index = 0; index < aWord.length(); ++index) {
            char c = aWord.charAt(index);
            if (Character.isJavaIdentifierPart(c) || c == '.' || c == '[' || c == ']' || c == '<' || c == '>' || c == '-' || c == '!' || c == '*' || c == '?' || c == '%') continue;
            return false;
        }
        return true;
    }

    private void checkFieldAccessFlags(int requiredSetMemberAccessFlags, int requiredUnsetMemberAccessFlags) throws ParseException {
        if (((requiredSetMemberAccessFlags | requiredUnsetMemberAccessFlags) & 0xFFFFAF20) != 0) {
            throw new ParseException("Invalid method access modifier for field before " + this.reader.locationDescription());
        }
    }

    private void checkMethodAccessFlags(int requiredSetMemberAccessFlags, int requiredUnsetMemberAccessFlags) throws ParseException {
        if (((requiredSetMemberAccessFlags | requiredUnsetMemberAccessFlags) & 0xFFFFE200) != 0) {
            throw new ParseException("Invalid field access modifier for method before " + this.reader.locationDescription());
        }
    }

    public static void main(String[] args) {
        try {
            ConfigurationParser parser = new ConfigurationParser(args, System.getProperties());
            try {
                parser.parse(new Configuration());
            }
            catch (ParseException ex) {
                ex.printStackTrace();
            }
            finally {
                parser.close();
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

