/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.ConstantValueAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.evaluation.ConstantValueFactory;
import proguard.evaluation.value.InitialValueFactory;
import proguard.evaluation.value.ParticularValueFactory;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;
import proguard.optimize.info.SideEffectInstructionChecker;

public class FieldOptimizationInfo
extends SimplifiedVisitor
implements AttributeVisitor {
    private static final ParticularValueFactory VALUE_FACTORY = new ParticularValueFactory();
    private static final ConstantValueFactory CONSTANT_VALUE_FACTORY = new ConstantValueFactory(VALUE_FACTORY);
    private static final InitialValueFactory INITIAL_VALUE_FACTORY = new InitialValueFactory(VALUE_FACTORY);
    private boolean isWritten;
    private boolean isRead;
    private boolean canBeMadePrivate = true;
    private ReferenceValue referencedClass;
    private Value value;

    public FieldOptimizationInfo(Clazz clazz, Field field) {
        int accessFlags = field.getAccessFlags();
        this.isRead = (accessFlags & 0x40) != 0;
        this.isWritten = this.isRead;
        this.resetValue(clazz, field);
    }

    public FieldOptimizationInfo(FieldOptimizationInfo FieldOptimizationInfo2) {
        this.isWritten = FieldOptimizationInfo2.isWritten;
        this.isRead = FieldOptimizationInfo2.isRead;
        this.canBeMadePrivate = FieldOptimizationInfo2.canBeMadePrivate;
        this.referencedClass = FieldOptimizationInfo2.referencedClass;
        this.value = FieldOptimizationInfo2.value;
    }

    public void setWritten() {
        this.isWritten = true;
    }

    public boolean isWritten() {
        return this.isWritten;
    }

    public void setRead() {
        this.isRead = true;
    }

    public boolean isRead() {
        return this.isRead;
    }

    public void setCanNotBeMadePrivate() {
        this.canBeMadePrivate = false;
    }

    public boolean canBeMadePrivate() {
        return this.canBeMadePrivate;
    }

    public void generalizeReferencedClass(ReferenceValue referencedClass) {
        this.referencedClass = this.referencedClass != null ? this.referencedClass.generalize(referencedClass) : referencedClass;
    }

    public ReferenceValue getReferencedClass() {
        return this.referencedClass;
    }

    public void resetValue(Clazz clazz, Field field) {
        int accessFlags = field.getAccessFlags();
        this.value = null;
        if ((accessFlags & 8) != 0) {
            field.accept(clazz, new AllAttributeVisitor(this));
        }
        if (this.value == null && (SideEffectInstructionChecker.OPTIMIZE_CONSERVATIVELY || (accessFlags & 0x10) == 0)) {
            this.value = INITIAL_VALUE_FACTORY.createValue(field.getDescriptor(clazz));
        }
    }

    public void generalizeValue(Value value) {
        this.value = this.value != null ? this.value.generalize(value) : value;
    }

    public Value getValue() {
        return this.value;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitConstantValueAttribute(Clazz clazz, Field field, ConstantValueAttribute constantValueAttribute) {
        this.value = CONSTANT_VALUE_FACTORY.constantValue(clazz, constantValueAttribute.u2constantValueIndex);
    }

    public static void setFieldOptimizationInfo(Clazz clazz, Field field) {
        field.setVisitorInfo(new FieldOptimizationInfo(clazz, field));
    }

    public static FieldOptimizationInfo getFieldOptimizationInfo(Field field) {
        Object visitorInfo = field.getVisitorInfo();
        return visitorInfo instanceof FieldOptimizationInfo ? (FieldOptimizationInfo)visitorInfo : null;
    }
}

