/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import proguard.classfile.ClassConstants;
import proguard.io.DataEntry;
import proguard.io.DataEntryNameFilter;
import proguard.io.DataEntryParentFilter;
import proguard.io.DataEntryReader;
import proguard.io.DataEntryWriter;
import proguard.io.DirectoryPump;
import proguard.io.DirectoryWriter;
import proguard.io.FilteredDataEntryReader;
import proguard.io.FilteredDataEntryWriter;
import proguard.io.JarReader;
import proguard.io.JarWriter;
import proguard.util.ExtensionMatcher;

public class DataEntryCopier
implements DataEntryReader {
    private static final int BUFFER_SIZE = 1024;
    private final DataEntryWriter dataEntryWriter;
    private final byte[] buffer = new byte[1024];

    public DataEntryCopier(DataEntryWriter dataEntryWriter) {
        this.dataEntryWriter = dataEntryWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(DataEntry dataEntry) throws IOException {
        block10: {
            try {
                if (dataEntry.isDirectory()) {
                    this.dataEntryWriter.createDirectory(dataEntry);
                    break block10;
                }
                OutputStream outputStream = this.dataEntryWriter.createOutputStream(dataEntry);
                if (outputStream == null) break block10;
                try {
                    InputStream inputStream = dataEntry.getInputStream();
                    try {
                        this.copyData(inputStream, outputStream);
                        outputStream.flush();
                    }
                    finally {
                        dataEntry.closeInputStream();
                    }
                }
                finally {
                    outputStream.close();
                }
            }
            catch (IOException ex) {
                System.err.println("Warning: can't write resource [" + dataEntry.getName() + "] (" + ex.getMessage() + ")");
            }
            catch (Exception ex) {
                throw (IOException)new IOException("Can't write resource [" + dataEntry.getName() + "] (" + ex.getMessage() + ")").initCause(ex);
            }
        }
    }

    protected void copyData(InputStream inputStream, OutputStream outputStream) throws IOException {
        int count;
        while ((count = inputStream.read(this.buffer)) >= 0) {
            outputStream.write(this.buffer, 0, count);
        }
    }

    public static void main(String[] args) {
        try {
            String input = args[0];
            String output = args[1];
            boolean outputIsApk = output.endsWith(".apk") || output.endsWith(".ap_");
            boolean outputIsJar = output.endsWith(".jar");
            boolean outputIsAar = output.endsWith(".aar");
            boolean outputIsWar = output.endsWith(".war");
            boolean outputIsEar = output.endsWith(".ear");
            boolean outputIsJmod = output.endsWith(".jmod");
            boolean outputIsZip = output.endsWith(".zip");
            DataEntryWriter writer = new DirectoryWriter(new File(output), outputIsApk || outputIsJar || outputIsAar || outputIsWar || outputIsEar || outputIsJmod || outputIsZip);
            JarWriter zipWriter = new JarWriter(writer);
            writer = outputIsZip ? zipWriter : new FilteredDataEntryWriter(new DataEntryParentFilter(new DataEntryNameFilter(new ExtensionMatcher(".zip"))), zipWriter, writer);
            JarWriter jmodWriter = new JarWriter(ClassConstants.JMOD_HEADER, writer);
            writer = outputIsJmod ? jmodWriter : new FilteredDataEntryWriter(new DataEntryParentFilter(new DataEntryNameFilter(new ExtensionMatcher(".jmod"))), jmodWriter, writer);
            JarWriter warWriter = new JarWriter(writer);
            writer = outputIsWar ? warWriter : new FilteredDataEntryWriter(new DataEntryParentFilter(new DataEntryNameFilter(new ExtensionMatcher(".war"))), warWriter, writer);
            JarWriter aarWriter = new JarWriter(writer);
            writer = outputIsWar ? aarWriter : new FilteredDataEntryWriter(new DataEntryParentFilter(new DataEntryNameFilter(new ExtensionMatcher(".aar"))), aarWriter, writer);
            JarWriter jarWriter = new JarWriter(writer);
            writer = outputIsJar ? jarWriter : new FilteredDataEntryWriter(new DataEntryParentFilter(new DataEntryNameFilter(new ExtensionMatcher(".jar"))), jarWriter, writer);
            JarWriter apkWriter = new JarWriter(writer);
            writer = outputIsApk ? apkWriter : new FilteredDataEntryWriter(new DataEntryParentFilter(new DataEntryNameFilter(new ExtensionMatcher(".apk"))), apkWriter, writer);
            DataEntryReader reader = new DataEntryCopier(writer);
            boolean inputIsApk = input.endsWith(".apk") || input.endsWith(".ap_");
            boolean inputIsJar = input.endsWith(".jar");
            boolean inputIsAar = input.endsWith(".aar");
            boolean inputIsWar = input.endsWith(".war");
            boolean inputIsEar = input.endsWith(".ear");
            boolean inputIsJmod = input.endsWith(".jmod");
            boolean inputIsZip = input.endsWith(".zip");
            JarReader apkReader = new JarReader(reader);
            if (inputIsApk) {
                reader = apkReader;
            } else {
                reader = new FilteredDataEntryReader(new DataEntryNameFilter(new ExtensionMatcher(".apk")), apkReader, reader);
                JarReader jarReader = new JarReader(reader);
                if (inputIsJar) {
                    reader = jarReader;
                } else {
                    reader = new FilteredDataEntryReader(new DataEntryNameFilter(new ExtensionMatcher(".jar")), jarReader, reader);
                    JarReader aarReader = new JarReader(reader);
                    if (inputIsAar) {
                        reader = aarReader;
                    } else {
                        reader = new FilteredDataEntryReader(new DataEntryNameFilter(new ExtensionMatcher(".aar")), aarReader, reader);
                        JarReader warReader = new JarReader(reader);
                        if (inputIsWar) {
                            reader = warReader;
                        } else {
                            reader = new FilteredDataEntryReader(new DataEntryNameFilter(new ExtensionMatcher(".war")), warReader, reader);
                            JarReader earReader = new JarReader(reader);
                            if (inputIsEar) {
                                reader = earReader;
                            } else {
                                reader = new FilteredDataEntryReader(new DataEntryNameFilter(new ExtensionMatcher(".ear")), earReader, reader);
                                JarReader jmodReader = new JarReader(reader, true);
                                if (inputIsJmod) {
                                    reader = jmodReader;
                                } else {
                                    reader = new FilteredDataEntryReader(new DataEntryNameFilter(new ExtensionMatcher(".jmod")), jmodReader, reader);
                                    JarReader zipReader = new JarReader(reader);
                                    reader = inputIsZip ? zipReader : new FilteredDataEntryReader(new DataEntryNameFilter(new ExtensionMatcher(".zip")), zipReader, reader);
                                }
                            }
                        }
                    }
                }
            }
            DirectoryPump directoryReader = new DirectoryPump(new File(input));
            directoryReader.pumpDataEntries(reader);
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

