/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.attribute.CodeAttribute;
import proguard.evaluation.BranchUnit;
import proguard.evaluation.value.InstructionOffsetValue;

public class BasicBranchUnit
implements BranchUnit {
    protected InstructionOffsetValue traceBranchTargets;
    protected boolean wasCalled;

    public void reset() {
        this.traceBranchTargets = InstructionOffsetValue.EMPTY_VALUE;
        this.wasCalled = false;
    }

    public boolean wasCalled() {
        return this.wasCalled;
    }

    public InstructionOffsetValue getTraceBranchTargets() {
        return this.traceBranchTargets;
    }

    public void branch(Clazz clazz, CodeAttribute codeAttribute, int offset, int branchTarget) {
        this.traceBranchTargets = new InstructionOffsetValue(branchTarget);
        this.wasCalled = true;
    }

    public void branchConditionally(Clazz clazz, CodeAttribute codeAttribute, int offset, int branchTarget, int conditional) {
        this.traceBranchTargets = this.traceBranchTargets.add(branchTarget);
        this.wasCalled = true;
    }

    public void returnFromMethod() {
        this.traceBranchTargets = InstructionOffsetValue.EMPTY_VALUE;
        this.wasCalled = true;
    }

    public void throwException() {
        this.traceBranchTargets = InstructionOffsetValue.EMPTY_VALUE;
        this.wasCalled = true;
    }
}

