/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.info;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.FieldOptimizationInfo;
import proguard.optimize.info.MutableBoolean;
import proguard.optimize.info.ProgramFieldOptimizationInfo;

public class ReadWriteFieldMarker
extends SimplifiedVisitor
implements InstructionVisitor,
ConstantVisitor,
MemberVisitor {
    private static final boolean DEBUG = false;
    private final MutableBoolean repeatTrigger;
    private boolean reading = true;
    private boolean writing = true;

    public ReadWriteFieldMarker(MutableBoolean repeatTrigger) {
        this.repeatTrigger = repeatTrigger;
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        byte opcode = constantInstruction.opcode;
        switch (opcode) {
            case 18: 
            case 19: {
                this.reading = true;
                this.writing = true;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                break;
            }
            case -78: 
            case -76: {
                this.reading = true;
                this.writing = false;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
                break;
            }
            case -77: 
            case -75: {
                this.reading = false;
                this.writing = true;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
            }
        }
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        stringConstant.referencedMemberAccept(this);
    }

    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        fieldrefConstant.referencedMemberAccept(this);
    }

    public void visitAnyMember(Clazz Clazz2, Member member) {
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (this.reading) {
            this.markAsRead(programField);
        }
        if (this.writing) {
            this.markAsWritten(programField);
        }
    }

    private void markAsRead(Field field) {
        FieldOptimizationInfo fieldOptimizationInfo = FieldOptimizationInfo.getFieldOptimizationInfo(field);
        if (!fieldOptimizationInfo.isRead() && fieldOptimizationInfo instanceof ProgramFieldOptimizationInfo) {
            ((ProgramFieldOptimizationInfo)fieldOptimizationInfo).setRead();
            this.repeatTrigger.set();
        }
    }

    public static boolean isRead(Field field) {
        return FieldOptimizationInfo.getFieldOptimizationInfo(field).isRead();
    }

    private void markAsWritten(Field field) {
        FieldOptimizationInfo fieldOptimizationInfo = FieldOptimizationInfo.getFieldOptimizationInfo(field);
        if (!fieldOptimizationInfo.isWritten() && fieldOptimizationInfo instanceof ProgramFieldOptimizationInfo) {
            ((ProgramFieldOptimizationInfo)fieldOptimizationInfo).setWritten();
            this.repeatTrigger.set();
        }
    }

    public static boolean isWritten(Field field) {
        return FieldOptimizationInfo.getFieldOptimizationInfo(field).isWritten();
    }
}

