/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import java.util.List;
import proguard.classfile.util.ExternalTypeEnumeration;
import proguard.classfile.util.InternalTypeEnumeration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassUtil {
    private static final String EMPTY_STRING = "";

    public static void checkMagicNumber(int magicNumber) throws UnsupportedOperationException {
        if (magicNumber != -889275714) {
            throw new UnsupportedOperationException("Invalid magic number [" + Integer.toHexString(magicNumber) + "] in class");
        }
    }

    public static int internalClassVersion(int majorVersion, int minorVersion) {
        return majorVersion << 16 | minorVersion;
    }

    public static int internalMajorClassVersion(int internalClassVersion) {
        return internalClassVersion >>> 16;
    }

    public static int internalMinorClassVersion(int internalClassVersion) {
        return internalClassVersion & 0xFFFF;
    }

    public static int internalClassVersion(String externalClassVersion) {
        return externalClassVersion.equals("1.0") || externalClassVersion.equals("1.1") ? 2949123 : (externalClassVersion.equals("1.2") ? 0x2E0000 : (externalClassVersion.equals("1.3") ? 0x2F0000 : (externalClassVersion.equals("1.4") ? 0x300000 : (externalClassVersion.equals("5") || externalClassVersion.equals("1.5") ? 0x310000 : (externalClassVersion.equals("6") || externalClassVersion.equals("1.6") ? 0x320000 : (externalClassVersion.equals("7") || externalClassVersion.equals("1.7") ? 0x330000 : (externalClassVersion.equals("8") || externalClassVersion.equals("1.8") ? 0x340000 : (externalClassVersion.equals("9") || externalClassVersion.equals("1.9") ? 0x350000 : (externalClassVersion.equals("10") ? 0x360000 : 0)))))))));
    }

    public static String externalClassVersion(int internalClassVersion) {
        switch (internalClassVersion) {
            case 2949123: {
                return "1.0";
            }
            case 0x2E0000: {
                return "1.2";
            }
            case 0x2F0000: {
                return "1.3";
            }
            case 0x300000: {
                return "1.4";
            }
            case 0x310000: {
                return "1.5";
            }
            case 0x320000: {
                return "1.6";
            }
            case 0x330000: {
                return "1.7";
            }
            case 0x340000: {
                return "1.8";
            }
            case 0x350000: {
                return "1.9";
            }
            case 0x360000: {
                return "10";
            }
        }
        return null;
    }

    public static void checkVersionNumbers(int internalClassVersion) throws UnsupportedOperationException {
        if (internalClassVersion < 2949123 || internalClassVersion > 0x360000) {
            throw new UnsupportedOperationException("Unsupported version number [" + ClassUtil.internalMajorClassVersion(internalClassVersion) + "." + ClassUtil.internalMinorClassVersion(internalClassVersion) + "] (maximum " + 54 + "." + 0 + ", Java " + "10" + ")");
        }
    }

    public static String internalClassName(String externalClassName) {
        return externalClassName.replace('.', '/');
    }

    public static String externalFullClassDescription(int accessFlags, String internalClassName) {
        return ClassUtil.externalClassAccessFlags(accessFlags) + ClassUtil.externalClassName(internalClassName);
    }

    public static String externalClassName(String internalClassName) {
        return internalClassName.replace('/', '.');
    }

    public static String externalBaseType(String externalArrayType) {
        int index = externalArrayType.indexOf("[]");
        return index >= 0 ? externalArrayType.substring(0, index) : externalArrayType;
    }

    public static String externalShortClassName(String externalClassName) {
        int index = externalClassName.lastIndexOf(46);
        return externalClassName.substring(index + 1);
    }

    public static boolean isInternalArrayType(String internalType) {
        return internalType.length() > 1 && internalType.charAt(0) == '[';
    }

    public static int internalArrayTypeDimensionCount(String internalType) {
        int dimensions = 0;
        while (internalType.charAt(dimensions) == '[') {
            ++dimensions;
        }
        return dimensions;
    }

    public static boolean isInternalArrayInterfaceName(String internalClassName) {
        return "java/lang/Object".equals(internalClassName) || "java/lang/Cloneable".equals(internalClassName) || "java/io/Serializable".equals(internalClassName);
    }

    public static boolean isInternalPrimitiveType(char internalType) {
        return internalType == 'Z' || internalType == 'B' || internalType == 'C' || internalType == 'S' || internalType == 'I' || internalType == 'F' || internalType == 'J' || internalType == 'D';
    }

    public static boolean isInternalPrimitiveType(String internalType) {
        return ClassUtil.isInternalPrimitiveType(internalType.charAt(0));
    }

    public static boolean isInternalCategory2Type(String internalType) {
        return internalType.length() == 1 && (internalType.charAt(0) == 'J' || internalType.charAt(0) == 'D');
    }

    public static boolean isInternalClassType(String internalType) {
        int length = internalType.length();
        return length > 1 && internalType.charAt(length - 1) == ';';
    }

    public static String internalTypeFromClassName(String internalClassName) {
        return ClassUtil.internalArrayTypeFromClassName(internalClassName, 0);
    }

    public static String internalArrayTypeFromClassName(String internalClassName, int dimensionCount) {
        StringBuffer buffer = new StringBuffer(internalClassName.length() + dimensionCount + 2);
        for (int dimension = 0; dimension < dimensionCount; ++dimension) {
            buffer.append('[');
        }
        return buffer.append('L').append(internalClassName).append(';').toString();
    }

    public static String internalArrayTypeFromType(String internalType, int dimensionDelta) {
        StringBuffer buffer = new StringBuffer(internalType.length() + dimensionDelta);
        for (int dimension = 0; dimension < dimensionDelta; ++dimension) {
            buffer.append('[');
        }
        return buffer.append(internalType).toString();
    }

    public static String internalTypeFromArrayType(String internalArrayType) {
        int index = internalArrayType.lastIndexOf(91);
        return internalArrayType.substring(index + 1);
    }

    public static String internalClassTypeFromType(String internalType) {
        return ClassUtil.isInternalArrayType(internalType) ? internalType : ClassUtil.internalClassNameFromClassType(internalType);
    }

    public static String internalTypeFromClassType(String internalType) {
        return ClassUtil.isInternalArrayType(internalType) ? internalType : ClassUtil.internalTypeFromClassName(internalType);
    }

    public static String internalClassNameFromClassType(String internalClassType) {
        return ClassUtil.isInternalClassType(internalClassType) ? internalClassType.substring(internalClassType.indexOf(76) + 1, internalClassType.length() - 1) : internalClassType;
    }

    public static String internalClassNameFromType(String internalClassType) {
        if (!ClassUtil.isInternalClassType(internalClassType)) {
            return null;
        }
        if (ClassUtil.isInternalArrayType(internalClassType)) {
            internalClassType = ClassUtil.internalTypeFromArrayType(internalClassType);
        }
        return ClassUtil.internalClassNameFromClassType(internalClassType);
    }

    public static String internalNumericClassNameFromPrimitiveType(char internalPrimitiveType) {
        switch (internalPrimitiveType) {
            case 'V': {
                return "java/lang/Void";
            }
            case 'Z': {
                return "java/lang/Boolean";
            }
            case 'B': {
                return "java/lang/Byte";
            }
            case 'C': {
                return "java/lang/Character";
            }
            case 'S': {
                return "java/lang/Short";
            }
            case 'I': {
                return "java/lang/Integer";
            }
            case 'J': {
                return "java/lang/Long";
            }
            case 'F': {
                return "java/lang/Float";
            }
            case 'D': {
                return "java/lang/Double";
            }
            case '[': {
                return "java/lang/reflect/Array";
            }
        }
        throw new IllegalArgumentException("Unexpected primitive type [" + internalPrimitiveType + "]");
    }

    public static char internalPrimitiveTypeFromNumericClassName(String internalPrimitiveClassName) {
        if (internalPrimitiveClassName.equals("java/lang/Void")) {
            return 'V';
        }
        if (internalPrimitiveClassName.equals("java/lang/Boolean")) {
            return 'Z';
        }
        if (internalPrimitiveClassName.equals("java/lang/Byte")) {
            return 'B';
        }
        if (internalPrimitiveClassName.equals("java/lang/Character")) {
            return 'C';
        }
        if (internalPrimitiveClassName.equals("java/lang/Short")) {
            return 'S';
        }
        if (internalPrimitiveClassName.equals("java/lang/Integer")) {
            return 'I';
        }
        if (internalPrimitiveClassName.equals("java/lang/Long")) {
            return 'J';
        }
        if (internalPrimitiveClassName.equals("java/lang/Float")) {
            return 'F';
        }
        if (internalPrimitiveClassName.equals("java/lang/Double")) {
            return 'D';
        }
        if (internalPrimitiveClassName.equals("java/lang/reflect/Array")) {
            return '[';
        }
        throw new IllegalArgumentException("Unexpected primitive class name [" + internalPrimitiveClassName + "]");
    }

    public static boolean isInitializer(String internalMethodName) {
        return internalMethodName.equals("<clinit>") || internalMethodName.equals("<init>");
    }

    public static String internalMethodReturnType(String internalMethodDescriptor) {
        int index = internalMethodDescriptor.indexOf(41);
        return internalMethodDescriptor.substring(index + 1);
    }

    public static int internalMethodParameterCount(String internalMethodDescriptor) {
        return ClassUtil.internalMethodParameterCount(internalMethodDescriptor, true);
    }

    public static int internalMethodParameterCount(String internalMethodDescriptor, int accessFlags) {
        return ClassUtil.internalMethodParameterCount(internalMethodDescriptor, (accessFlags & 8) != 0);
    }

    public static int internalMethodParameterCount(String internalMethodDescriptor, boolean isStatic) {
        int counter = isStatic ? 0 : 1;
        int index = 1;
        block5: while (true) {
            char c = internalMethodDescriptor.charAt(index++);
            switch (c) {
                case '[': {
                    continue block5;
                }
                case 'L': {
                    ++counter;
                    index = internalMethodDescriptor.indexOf(59, index) + 1;
                    continue block5;
                }
                default: {
                    ++counter;
                    continue block5;
                }
                case ')': 
            }
            break;
        }
        return counter;
    }

    public static int internalMethodParameterSize(String internalMethodDescriptor) {
        return ClassUtil.internalMethodParameterSize(internalMethodDescriptor, true);
    }

    public static int internalMethodParameterSize(String internalMethodDescriptor, int accessFlags) {
        return ClassUtil.internalMethodParameterSize(internalMethodDescriptor, (accessFlags & 8) != 0);
    }

    public static int internalMethodParameterSize(String internalMethodDescriptor, boolean isStatic) {
        int size = isStatic ? 0 : 1;
        int index = 1;
        block6: while (true) {
            char c = internalMethodDescriptor.charAt(index++);
            switch (c) {
                case 'D': 
                case 'J': {
                    size += 2;
                    continue block6;
                }
                case 'L': {
                    ++size;
                    index = internalMethodDescriptor.indexOf(59, index) + 1;
                    continue block6;
                }
                case '[': {
                    ++size;
                    while ((c = internalMethodDescriptor.charAt(index++)) == '[') {
                    }
                    if (c != 'L') continue block6;
                    index = internalMethodDescriptor.indexOf(59, index) + 1;
                    continue block6;
                }
                default: {
                    ++size;
                    continue block6;
                }
                case ')': 
            }
            break;
        }
        return size;
    }

    public static int internalTypeSize(String internalType) {
        if (internalType.length() == 1) {
            char internalPrimitiveType = internalType.charAt(0);
            if (internalPrimitiveType == 'J' || internalPrimitiveType == 'D') {
                return 2;
            }
            if (internalPrimitiveType == 'V') {
                return 0;
            }
        }
        return 1;
    }

    public static String internalType(String externalType) {
        int dimensionCount = ClassUtil.externalArrayTypeDimensionCount(externalType);
        if (dimensionCount > 0) {
            externalType = externalType.substring(0, externalType.length() - dimensionCount * "[]".length());
        }
        int internalTypeChar = externalType.equals("void") ? 86 : (externalType.equals("boolean") ? 90 : (externalType.equals("byte") ? 66 : (externalType.equals("char") ? 67 : (externalType.equals("short") ? 83 : (externalType.equals("int") ? 73 : (externalType.equals("float") ? 70 : (externalType.equals("long") ? 74 : (externalType.equals("double") ? 68 : (externalType.equals("%") ? 37 : 0)))))))));
        String internalType = internalTypeChar != 0 ? String.valueOf((char)internalTypeChar) : 'L' + ClassUtil.internalClassName(externalType) + ';';
        for (int count = 0; count < dimensionCount; ++count) {
            internalType = '[' + internalType;
        }
        return internalType;
    }

    public static int externalArrayTypeDimensionCount(String externalType) {
        int dimensions = 0;
        int length = "[]".length();
        int offset = externalType.length() - length;
        while (externalType.regionMatches(offset, "[]", 0, length)) {
            ++dimensions;
            offset -= length;
        }
        return dimensions;
    }

    public static String externalType(String internalType) {
        String externalType;
        char internalTypeChar;
        int dimensionCount = ClassUtil.internalArrayTypeDimensionCount(internalType);
        if (dimensionCount > 0) {
            internalType = internalType.substring(dimensionCount);
        }
        String string = (internalTypeChar = internalType.charAt(0)) == 'V' ? "void" : (internalTypeChar == 'Z' ? "boolean" : (internalTypeChar == 'B' ? "byte" : (internalTypeChar == 'C' ? "char" : (internalTypeChar == 'S' ? "short" : (internalTypeChar == 'I' ? "int" : (internalTypeChar == 'F' ? "float" : (internalTypeChar == 'J' ? "long" : (internalTypeChar == 'D' ? "double" : (internalTypeChar == '%' ? "%" : (externalType = internalTypeChar == 'L' ? ClassUtil.externalClassName(internalType.substring(1, internalType.indexOf(59))) : null))))))))));
        if (externalType == null) {
            throw new IllegalArgumentException("Unknown type [" + internalType + "]");
        }
        for (int count = 0; count < dimensionCount; ++count) {
            externalType = externalType + "[]";
        }
        return externalType;
    }

    public static String externalClassForNameType(String internalType) {
        return ClassUtil.isInternalArrayType(internalType) ? ClassUtil.externalClassName(internalType) : ClassUtil.externalClassName(ClassUtil.internalClassNameFromClassType(internalType));
    }

    public static boolean isInternalMethodDescriptor(String internalDescriptor) {
        return internalDescriptor.charAt(0) == '(';
    }

    public static boolean isExternalMethodNameAndArguments(String externalMemberNameAndArguments) {
        return externalMemberNameAndArguments.indexOf(40) > 0;
    }

    public static String externalMethodName(String externalMethodNameAndArguments) {
        ExternalTypeEnumeration externalTypeEnumeration = new ExternalTypeEnumeration(externalMethodNameAndArguments);
        return externalTypeEnumeration.methodName();
    }

    public static String internalMethodDescriptor(String externalReturnType, String externalMethodNameAndArguments) {
        StringBuffer internalMethodDescriptor = new StringBuffer();
        internalMethodDescriptor.append('(');
        ExternalTypeEnumeration externalTypeEnumeration = new ExternalTypeEnumeration(externalMethodNameAndArguments);
        while (externalTypeEnumeration.hasMoreTypes()) {
            internalMethodDescriptor.append(ClassUtil.internalType(externalTypeEnumeration.nextType()));
        }
        internalMethodDescriptor.append(')');
        internalMethodDescriptor.append(ClassUtil.internalType(externalReturnType));
        return internalMethodDescriptor.toString();
    }

    public static String internalMethodDescriptor(String externalReturnType, List externalArguments) {
        StringBuffer internalMethodDescriptor = new StringBuffer();
        internalMethodDescriptor.append('(');
        for (int index = 0; index < externalArguments.size(); ++index) {
            internalMethodDescriptor.append(ClassUtil.internalType((String)externalArguments.get(index)));
        }
        internalMethodDescriptor.append(')');
        internalMethodDescriptor.append(ClassUtil.internalType(externalReturnType));
        return internalMethodDescriptor.toString();
    }

    public static String internalMethodDescriptorFromInternalTypes(String internalReturnType, List<String> internalArguments) {
        StringBuilder internalMethodDescriptor = new StringBuilder();
        internalMethodDescriptor.append('(');
        for (String argument : internalArguments) {
            internalMethodDescriptor.append(argument);
        }
        internalMethodDescriptor.append(')');
        internalMethodDescriptor.append(internalReturnType);
        return internalMethodDescriptor.toString();
    }

    public static String externalFullFieldDescription(int accessFlags, String fieldName, String internalFieldDescriptor) {
        return ClassUtil.externalFieldAccessFlags(accessFlags) + ClassUtil.externalType(internalFieldDescriptor) + ' ' + fieldName;
    }

    public static String externalFullMethodDescription(String internalClassName, int accessFlags, String internalMethodName, String internalMethodDescriptor) {
        return ClassUtil.externalMethodAccessFlags(accessFlags) + ClassUtil.externalMethodReturnTypeAndName(internalClassName, internalMethodName, internalMethodDescriptor) + '(' + ClassUtil.externalMethodArguments(internalMethodDescriptor) + ')';
    }

    public static String externalClassAccessFlags(int accessFlags) {
        return ClassUtil.externalClassAccessFlags(accessFlags, EMPTY_STRING);
    }

    public static String externalClassAccessFlags(int accessFlags, String prefix) {
        if (accessFlags == 0) {
            return EMPTY_STRING;
        }
        StringBuffer string = new StringBuffer(50);
        if ((accessFlags & 1) != 0) {
            string.append(prefix).append("public").append(' ');
        }
        if ((accessFlags & 2) != 0) {
            string.append(prefix).append("private").append(' ');
        }
        if ((accessFlags & 4) != 0) {
            string.append(prefix).append("protected").append(' ');
        }
        if ((accessFlags & 8) != 0) {
            string.append(prefix).append("static").append(' ');
        }
        if ((accessFlags & 0x10) != 0) {
            string.append(prefix).append("final").append(' ');
        }
        if ((accessFlags & 0x2000) != 0) {
            string.append(prefix).append("@");
        }
        if ((accessFlags & 0x200) != 0) {
            string.append(prefix).append("interface").append(' ');
        } else if ((accessFlags & 0x4000) != 0) {
            string.append(prefix).append("enum").append(' ');
        } else if ((accessFlags & 0x400) != 0) {
            string.append(prefix).append("abstract").append(' ');
        } else if ((accessFlags & 0x1000) != 0) {
            string.append(prefix).append("synthetic").append(' ');
        } else if ((accessFlags & 0x8000) != 0) {
            string.append(prefix).append("module").append(' ');
        }
        return string.toString();
    }

    public static String externalFieldAccessFlags(int accessFlags) {
        return ClassUtil.externalFieldAccessFlags(accessFlags, EMPTY_STRING);
    }

    public static String externalFieldAccessFlags(int accessFlags, String prefix) {
        if (accessFlags == 0) {
            return EMPTY_STRING;
        }
        StringBuffer string = new StringBuffer(50);
        if ((accessFlags & 1) != 0) {
            string.append(prefix).append("public").append(' ');
        }
        if ((accessFlags & 2) != 0) {
            string.append(prefix).append("private").append(' ');
        }
        if ((accessFlags & 4) != 0) {
            string.append(prefix).append("protected").append(' ');
        }
        if ((accessFlags & 8) != 0) {
            string.append(prefix).append("static").append(' ');
        }
        if ((accessFlags & 0x10) != 0) {
            string.append(prefix).append("final").append(' ');
        }
        if ((accessFlags & 0x40) != 0) {
            string.append(prefix).append("volatile").append(' ');
        }
        if ((accessFlags & 0x80) != 0) {
            string.append(prefix).append("transient").append(' ');
        }
        if ((accessFlags & 0x1000) != 0) {
            string.append(prefix).append("synthetic").append(' ');
        }
        return string.toString();
    }

    public static String externalMethodAccessFlags(int accessFlags) {
        return ClassUtil.externalMethodAccessFlags(accessFlags, EMPTY_STRING);
    }

    public static String externalMethodAccessFlags(int accessFlags, String prefix) {
        if (accessFlags == 0) {
            return EMPTY_STRING;
        }
        StringBuffer string = new StringBuffer(50);
        if ((accessFlags & 1) != 0) {
            string.append(prefix).append("public").append(' ');
        }
        if ((accessFlags & 2) != 0) {
            string.append(prefix).append("private").append(' ');
        }
        if ((accessFlags & 4) != 0) {
            string.append(prefix).append("protected").append(' ');
        }
        if ((accessFlags & 8) != 0) {
            string.append(prefix).append("static").append(' ');
        }
        if ((accessFlags & 0x10) != 0) {
            string.append(prefix).append("final").append(' ');
        }
        if ((accessFlags & 0x20) != 0) {
            string.append(prefix).append("synchronized").append(' ');
        }
        if ((accessFlags & 0x40) != 0) {
            string.append(prefix).append("bridge").append(' ');
        }
        if ((accessFlags & 0x80) != 0) {
            string.append(prefix).append("varargs").append(' ');
        }
        if ((accessFlags & 0x100) != 0) {
            string.append(prefix).append("native").append(' ');
        }
        if ((accessFlags & 0x400) != 0) {
            string.append(prefix).append("abstract").append(' ');
        }
        if ((accessFlags & 0x800) != 0) {
            string.append(prefix).append("strictfp").append(' ');
        }
        if ((accessFlags & 0x1000) != 0) {
            string.append(prefix).append("synthetic").append(' ');
        }
        return string.toString();
    }

    public static String externalParameterAccessFlags(int accessFlags) {
        return ClassUtil.externalParameterAccessFlags(accessFlags, EMPTY_STRING);
    }

    public static String externalParameterAccessFlags(int accessFlags, String prefix) {
        if (accessFlags == 0) {
            return EMPTY_STRING;
        }
        StringBuffer string = new StringBuffer(50);
        if ((accessFlags & 0x10) != 0) {
            string.append(prefix).append("final").append(' ');
        }
        if ((accessFlags & 0x1000) != 0) {
            string.append(prefix).append("synthetic").append(' ');
        }
        if ((accessFlags & 0x8000) != 0) {
            string.append(prefix).append("mandated").append(' ');
        }
        return string.toString();
    }

    public static String externalMethodReturnType(String internalMethodDescriptor) {
        return ClassUtil.externalType(ClassUtil.internalMethodReturnType(internalMethodDescriptor));
    }

    public static String externalModuleAccessFlags(int accessFlags) {
        return ClassUtil.externalModuleAccessFlags(accessFlags, EMPTY_STRING);
    }

    public static String externalModuleAccessFlags(int accessFlags, String prefix) {
        if (accessFlags == 0) {
            return EMPTY_STRING;
        }
        StringBuffer string = new StringBuffer(50);
        if ((accessFlags & 0x20) != 0) {
            string.append(prefix).append("open").append(' ');
        }
        if ((accessFlags & 0x1000) != 0) {
            string.append(prefix).append("synthetic").append(' ');
        }
        if ((accessFlags & 0x8000) != 0) {
            string.append(prefix).append("mandated").append(' ');
        }
        return string.toString();
    }

    public static String externalRequiresAccessFlags(int accessFlags) {
        return ClassUtil.externalRequiresAccessFlags(accessFlags, EMPTY_STRING);
    }

    public static String externalRequiresAccessFlags(int accessFlags, String prefix) {
        if (accessFlags == 0) {
            return EMPTY_STRING;
        }
        StringBuffer string = new StringBuffer(50);
        if ((accessFlags & 0x20) != 0) {
            string.append(prefix).append("transitive").append(' ');
        }
        if ((accessFlags & 0x40) != 0) {
            string.append(prefix).append("static").append(' ');
        }
        if ((accessFlags & 0x1000) != 0) {
            string.append(prefix).append("synthetic").append(' ');
        }
        if ((accessFlags & 0x8000) != 0) {
            string.append(prefix).append("mandated").append(' ');
        }
        return string.toString();
    }

    public static String externalExportsAccessFlags(int accessFlags) {
        return ClassUtil.externalExportsAccessFlags(accessFlags, EMPTY_STRING);
    }

    public static String externalExportsAccessFlags(int accessFlags, String prefix) {
        if (accessFlags == 0) {
            return EMPTY_STRING;
        }
        StringBuffer string = new StringBuffer(50);
        if ((accessFlags & 0x1000) != 0) {
            string.append(prefix).append("synthetic").append(' ');
        }
        if ((accessFlags & 0x8000) != 0) {
            string.append(prefix).append("mandated").append(' ');
        }
        return string.toString();
    }

    public static String externalOpensAccessFlags(int accessFlags) {
        return ClassUtil.externalOpensAccessFlags(accessFlags, EMPTY_STRING);
    }

    public static String externalOpensAccessFlags(int accessFlags, String prefix) {
        if (accessFlags == 0) {
            return EMPTY_STRING;
        }
        StringBuffer string = new StringBuffer(50);
        if ((accessFlags & 0x1000) != 0) {
            string.append(prefix).append("synthetic").append(' ');
        }
        if ((accessFlags & 0x8000) != 0) {
            string.append(prefix).append("mandated").append(' ');
        }
        return string.toString();
    }

    private static String externalMethodReturnTypeAndName(String internalClassName, String internalMethodName, String internalMethodDescriptor) {
        return internalMethodName.equals("<init>") ? ClassUtil.externalShortClassName(ClassUtil.externalClassName(internalClassName)) : ClassUtil.externalMethodReturnType(internalMethodDescriptor) + ' ' + internalMethodName;
    }

    public static String externalMethodArguments(String internalMethodDescriptor) {
        StringBuffer externalMethodNameAndArguments = new StringBuffer();
        InternalTypeEnumeration internalTypeEnumeration = new InternalTypeEnumeration(internalMethodDescriptor);
        while (internalTypeEnumeration.hasMoreTypes()) {
            externalMethodNameAndArguments.append(ClassUtil.externalType(internalTypeEnumeration.nextType()));
            if (!internalTypeEnumeration.hasMoreTypes()) continue;
            externalMethodNameAndArguments.append(',');
        }
        return externalMethodNameAndArguments.toString();
    }

    public static String internalPackageName(String internalClassName) {
        String internalPackagePrefix = ClassUtil.internalPackagePrefix(internalClassName);
        int length = internalPackagePrefix.length();
        return length > 0 ? internalPackagePrefix.substring(0, length - 1) : EMPTY_STRING;
    }

    public static String internalPackagePrefix(String internalClassName) {
        return internalClassName.substring(0, internalClassName.lastIndexOf(47, internalClassName.length() - 2) + 1);
    }

    public static String externalPackageName(String externalClassName) {
        String externalPackagePrefix = ClassUtil.externalPackagePrefix(externalClassName);
        int length = externalPackagePrefix.length();
        return length > 0 ? externalPackagePrefix.substring(0, length - 1) : EMPTY_STRING;
    }

    public static String externalPackagePrefix(String externalClassName) {
        return externalClassName.substring(0, externalClassName.lastIndexOf(46, externalClassName.length() - 2) + 1);
    }
}

