/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.info.WrapperClassMarker;
import proguard.optimize.peephole.ClassMerger;

public class WrapperClassMerger
extends SimplifiedVisitor
implements ClassVisitor {
    private final boolean allowAccessModification;
    private final ClassVisitor extraClassVisitor;

    public WrapperClassMerger(boolean allowAccessModification) {
        this(allowAccessModification, null);
    }

    public WrapperClassMerger(boolean allowAccessModification, ClassVisitor extraClassVisitor) {
        this.allowAccessModification = allowAccessModification;
        this.extraClassVisitor = extraClassVisitor;
    }

    public void visitProgramClass(ProgramClass programClass) {
        Clazz wrappedClass;
        if ("java/lang/Object".equals(programClass.getSuperName()) && (wrappedClass = WrapperClassMarker.getWrappedClass(programClass)) instanceof ProgramClass) {
            new ClassMerger((ProgramClass)wrappedClass, this.allowAccessModification, false, true, this.extraClassVisitor).visitProgramClass(programClass);
        }
    }
}

