/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.List;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.classfile.ClassConstants;
import proguard.classfile.ClassPool;
import proguard.io.CascadingDataEntryWriter;
import proguard.io.ClassDataEntryWriter;
import proguard.io.DataEntryNameFilter;
import proguard.io.DataEntryParentFilter;
import proguard.io.DataEntryWriter;
import proguard.io.DirectoryWriter;
import proguard.io.ExtraDataEntryWriter;
import proguard.io.FilteredDataEntryWriter;
import proguard.io.JarWriter;
import proguard.io.ParentDataEntryWriter;
import proguard.io.PrefixAddingDataEntryWriter;
import proguard.util.ExtensionMatcher;
import proguard.util.FileNameParser;
import proguard.util.ListParser;
import proguard.util.MultiValueMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataEntryWriterFactory {
    private final ClassPool programClassPool;
    private final MultiValueMap extraClassNameMap;

    public DataEntryWriterFactory(ClassPool programClassPool, MultiValueMap<String, String> extraClassNamemap) {
        this.programClassPool = programClassPool;
        this.extraClassNameMap = extraClassNamemap;
    }

    public DataEntryWriter createDataEntryWriter(ClassPath classPath, int fromIndex, int toIndex) {
        DataEntryWriter writer = null;
        for (int index = toIndex - 1; index >= fromIndex; --index) {
            ClassPathEntry entry = classPath.get(index);
            writer = this.createClassPathEntryWriter(entry, writer);
        }
        return writer;
    }

    private DataEntryWriter createClassPathEntryWriter(ClassPathEntry classPathEntry, DataEntryWriter alternativeWriter) {
        boolean isApk = classPathEntry.isApk();
        boolean isJar = classPathEntry.isJar();
        boolean isAar = classPathEntry.isAar();
        boolean isWar = classPathEntry.isWar();
        boolean isEar = classPathEntry.isEar();
        boolean isJmod = classPathEntry.isJmod();
        boolean isZip = classPathEntry.isZip();
        List filter = classPathEntry.getFilter();
        List apkFilter = classPathEntry.getApkFilter();
        List jarFilter = classPathEntry.getJarFilter();
        List aarFilter = classPathEntry.getAarFilter();
        List warFilter = classPathEntry.getWarFilter();
        List earFilter = classPathEntry.getEarFilter();
        List jmodFilter = classPathEntry.getJmodFilter();
        List zipFilter = classPathEntry.getZipFilter();
        System.out.println("Preparing output " + (isApk ? "apk" : (isJar ? "jar" : (isAar ? "aar" : (isWar ? "war" : (isEar ? "ear" : (isJmod ? "jmod" : (isZip ? "zip" : "directory"))))))) + " [" + classPathEntry.getName() + "]" + (filter != null || apkFilter != null || jarFilter != null || aarFilter != null || warFilter != null || earFilter != null || jmodFilter != null || zipFilter != null ? " (filtered)" : ""));
        DataEntryWriter writer = new DirectoryWriter(classPathEntry.getFile(), isApk || isJar || isAar || isWar || isEar || isJmod || isZip);
        writer = this.wrapInJarWriter(writer, false, null, isZip, zipFilter, ".zip", isApk || isJar || isAar || isWar || isEar || isJmod);
        writer = this.wrapInJarWriter(writer, true, ClassConstants.JMOD_HEADER, isJmod, jmodFilter, ".jmod", isApk || isJar || isAar || isWar || isEar);
        writer = this.wrapInJarWriter(writer, false, null, isEar, earFilter, ".ear", isApk || isJar || isAar || isWar);
        writer = this.wrapInJarWriter(writer, true, null, isWar, warFilter, ".war", isApk || isJar || isAar);
        writer = this.wrapInJarWriter(writer, false, null, isAar, aarFilter, ".aar", isApk || isJar);
        writer = this.wrapInJarWriter(writer, false, null, isJar, jarFilter, ".jar", isApk);
        writer = this.wrapInJarWriter(writer, false, null, isApk, apkFilter, ".apk", false);
        writer = new ClassDataEntryWriter(this.programClassPool, writer);
        writer = filter != null ? new FilteredDataEntryWriter(new DataEntryNameFilter(new ListParser(new FileNameParser()).parse(filter)), writer) : writer;
        writer = new ExtraDataEntryWriter(this.extraClassNameMap, writer, writer, ".class");
        return alternativeWriter != null ? new CascadingDataEntryWriter(writer, alternativeWriter) : writer;
    }

    private DataEntryWriter wrapInJarWriter(DataEntryWriter writer, boolean addClassesPrefix, byte[] header, boolean isJar, List jarFilter, String jarExtension, boolean dontWrap) {
        DataEntryWriter jarWriter;
        DataEntryWriter dataEntryWriter = jarWriter = dontWrap ? new ParentDataEntryWriter(writer) : new JarWriter(header, writer);
        if (addClassesPrefix) {
            writer = new FilteredDataEntryWriter(new DataEntryNameFilter(new ExtensionMatcher(".class")), new PrefixAddingDataEntryWriter("classes/", writer), writer);
        }
        DataEntryWriter filteredJarWriter = jarFilter != null ? new FilteredDataEntryWriter(new DataEntryParentFilter(new DataEntryNameFilter(new ListParser(new FileNameParser()).parse(jarFilter))), jarWriter) : jarWriter;
        return new FilteredDataEntryWriter(new DataEntryParentFilter(new DataEntryNameFilter(new ExtensionMatcher(jarExtension))), filteredJarWriter, isJar ? jarWriter : writer);
    }
}

