/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.PrimitiveArrayConstant;
import proguard.classfile.constant.visitor.ConstantCounter;
import proguard.classfile.constant.visitor.ConstantTagFilter;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.constant.visitor.PrimitiveArrayConstantElementVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolShrinker;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionUtil;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;

public class PrimitiveArrayConstantReplacer
extends SimplifiedVisitor
implements ClassVisitor,
AttributeVisitor,
InstructionVisitor,
ConstantVisitor,
PrimitiveArrayConstantElementVisitor {
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
    private final ConstantPoolShrinker constantPoolShrinker = new ConstantPoolShrinker();
    private boolean classModified;
    private InstructionSequenceBuilder builder;

    public void visitProgramClass(ProgramClass programClass) {
        ConstantCounter counter = new ConstantCounter();
        programClass.constantPoolEntriesAccept(new ConstantTagFilter(21, (ConstantVisitor)counter));
        if (counter.getCount() > 0) {
            this.classModified = false;
            programClass.methodsAccept(new AllAttributeVisitor(this));
            if (this.classModified) {
                programClass.accept(this.constantPoolShrinker);
            }
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
        codeAttribute.instructionsAccept(clazz, method, this);
        if (this.codeAttributeEditor.isModified()) {
            this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
            this.classModified = true;
        }
    }

    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        this.builder = null;
        clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this);
        if (this.builder != null) {
            this.codeAttributeEditor.replaceInstruction(offset, this.builder.instructions());
            this.classModified = true;
        }
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitPrimitiveArrayConstant(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant) {
        char primitiveType = primitiveArrayConstant.getPrimitiveType();
        int arrayLength = primitiveArrayConstant.getLength();
        this.builder = new InstructionSequenceBuilder((ProgramClass)clazz);
        this.builder.pushInt(primitiveArrayConstant.getLength());
        this.builder.newarray(InstructionUtil.arrayTypeFromInternalType(primitiveType));
        primitiveArrayConstant.primitiveArrayElementsAccept(clazz, this);
    }

    public void visitBooleanArrayConstantElement(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant, int index, boolean value) {
        this.builder.dup().pushInt(index).iconst(value ? 1 : 0).bastore();
    }

    public void visitByteArrayConstantElement(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant, int index, byte value) {
        this.builder.dup().pushInt(index).pushInt(value).bastore();
    }

    public void visitCharArrayConstantElement(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant, int index, char value) {
        this.builder.dup().pushInt(index).pushInt(value).castore();
    }

    public void visitShortArrayConstantElement(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant, int index, short value) {
        this.builder.dup().pushInt(index).pushInt(value).sastore();
    }

    public void visitIntArrayConstantElement(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant, int index, int value) {
        this.builder.dup().pushInt(index).pushInt(value).iastore();
    }

    public void visitFloatArrayConstantElement(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant, int index, float value) {
        this.builder.dup().pushInt(index).pushFloat(value).fastore();
    }

    public void visitLongArrayConstantElement(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant, int index, long value) {
        this.builder.dup().pushInt(index).pushLong(value).lastore();
    }

    public void visitDoubleArrayConstantElement(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant, int index, double value) {
        this.builder.dup().pushInt(index).pushDouble(value).dastore();
    }
}

