/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberCounter;

public class FunctionalInterfaceFilter
implements ClassVisitor {
    private final ClassVisitor classVisitor;

    public FunctionalInterfaceFilter(ClassVisitor classVisitor) {
        this.classVisitor = classVisitor;
    }

    public void visitProgramClass(ProgramClass programClass) {
        if (this.isFunctionalInterface(programClass)) {
            this.classVisitor.visitProgramClass(programClass);
        }
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        if (this.isFunctionalInterface(libraryClass)) {
            this.classVisitor.visitLibraryClass(libraryClass);
        }
    }

    private boolean isFunctionalInterface(Clazz clazz) {
        if ((clazz.getAccessFlags() & 0x200) == 0) {
            return false;
        }
        MemberCounter methodCounter = new MemberCounter();
        clazz.hierarchyAccept(true, false, true, false, new AllMethodVisitor(new MemberAccessFilter(1024, 0, methodCounter)));
        return methodCounter.getCount() == 1;
    }
}

