/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class ProgramClass
implements Clazz {
    private static final int[] EMPTY_INTERFACES = new int[0];
    private static final ProgramField[] EMPTY_FIELDS = new ProgramField[0];
    private static final ProgramMethod[] EMPTY_METHODS = new ProgramMethod[0];
    private static final Attribute[] EMPTY_ATTRIBUTES = new Attribute[0];
    public int u4version;
    public int u2constantPoolCount;
    public Constant[] constantPool;
    public int u2accessFlags;
    public int u2thisClass;
    public int u2superClass;
    public int u2interfacesCount;
    public int[] u2interfaces;
    public int u2fieldsCount;
    public ProgramField[] fields;
    public int u2methodsCount;
    public ProgramMethod[] methods;
    public int u2attributesCount;
    public Attribute[] attributes;
    public Clazz[] subClasses;
    public Object visitorInfo;

    public ProgramClass() {
    }

    public ProgramClass(int u4version, int u2constantPoolCount, Constant[] constantPool, int u2accessFlags, int u2thisClass, int u2superClass) {
        this(u4version, u2constantPoolCount, constantPool, u2accessFlags, u2thisClass, u2superClass, 0, EMPTY_INTERFACES, 0, EMPTY_FIELDS, 0, EMPTY_METHODS, 0, EMPTY_ATTRIBUTES, null);
    }

    public ProgramClass(int u4version, int u2constantPoolCount, Constant[] constantPool, int u2accessFlags, int u2thisClass, int u2superClass, int u2interfacesCount, int[] u2interfaces, int u2fieldsCount, ProgramField[] fields, int u2methodsCount, ProgramMethod[] methods, int u2attributesCount, Attribute[] attributes, Clazz[] subClasses) {
        this.u4version = u4version;
        this.u2constantPoolCount = u2constantPoolCount;
        this.constantPool = constantPool;
        this.u2accessFlags = u2accessFlags;
        this.u2thisClass = u2thisClass;
        this.u2superClass = u2superClass;
        this.u2interfacesCount = u2interfacesCount;
        this.u2interfaces = u2interfaces;
        this.u2fieldsCount = u2fieldsCount;
        this.fields = fields;
        this.u2methodsCount = u2methodsCount;
        this.methods = methods;
        this.u2attributesCount = u2attributesCount;
        this.attributes = attributes;
        this.subClasses = subClasses;
    }

    public Constant getConstant(int constantIndex) {
        return this.constantPool[constantIndex];
    }

    public int getAccessFlags() {
        return this.u2accessFlags;
    }

    public String getName() {
        return this.getClassName(this.u2thisClass);
    }

    public String getSuperName() {
        return this.u2superClass == 0 ? null : this.getClassName(this.u2superClass);
    }

    public int getInterfaceCount() {
        return this.u2interfacesCount;
    }

    public String getInterfaceName(int index) {
        return this.getClassName(this.u2interfaces[index]);
    }

    public int getTag(int constantIndex) {
        return this.constantPool[constantIndex].getTag();
    }

    public String getString(int constantIndex) {
        try {
            return ((Utf8Constant)this.constantPool[constantIndex]).getString();
        }
        catch (ClassCastException ex) {
            throw (IllegalStateException)new IllegalStateException("Expected Utf8Constant at index [" + constantIndex + "] in class [" + this.getName() + "]").initCause(ex);
        }
    }

    public String getStringString(int constantIndex) {
        try {
            return ((StringConstant)this.constantPool[constantIndex]).getString(this);
        }
        catch (ClassCastException ex) {
            throw (IllegalStateException)new IllegalStateException("Expected StringConstant at index [" + constantIndex + "] in class [" + this.getName() + "]").initCause(ex);
        }
    }

    public String getClassName(int constantIndex) {
        try {
            return ((ClassConstant)this.constantPool[constantIndex]).getName(this);
        }
        catch (ClassCastException ex) {
            throw (IllegalStateException)new IllegalStateException("Expected ClassConstant at index [" + constantIndex + "]").initCause(ex);
        }
    }

    public String getName(int constantIndex) {
        try {
            return ((NameAndTypeConstant)this.constantPool[constantIndex]).getName(this);
        }
        catch (ClassCastException ex) {
            throw (IllegalStateException)new IllegalStateException("Expected NameAndTypeConstant at index [" + constantIndex + "] in class [" + this.getName() + "]").initCause(ex);
        }
    }

    public String getType(int constantIndex) {
        try {
            return ((NameAndTypeConstant)this.constantPool[constantIndex]).getType(this);
        }
        catch (ClassCastException ex) {
            throw (IllegalStateException)new IllegalStateException("Expected NameAndTypeConstant at index [" + constantIndex + "] in class [" + this.getName() + "]").initCause(ex);
        }
    }

    public String getRefClassName(int constantIndex) {
        try {
            return ((RefConstant)this.constantPool[constantIndex]).getClassName(this);
        }
        catch (ClassCastException ex) {
            throw (IllegalStateException)new IllegalStateException("Expected RefConstant at index [" + constantIndex + "] in class [" + this.getName() + "]").initCause(ex);
        }
    }

    public String getRefName(int constantIndex) {
        try {
            return ((RefConstant)this.constantPool[constantIndex]).getName(this);
        }
        catch (ClassCastException ex) {
            throw (IllegalStateException)new IllegalStateException("Expected RefConstant at index [" + constantIndex + "] in class [" + this.getName() + "]").initCause(ex);
        }
    }

    public String getRefType(int constantIndex) {
        try {
            return ((RefConstant)this.constantPool[constantIndex]).getType(this);
        }
        catch (ClassCastException ex) {
            throw (IllegalStateException)new IllegalStateException("Expected RefConstant at index [" + constantIndex + "] in class [" + this.getName() + "]").initCause(ex);
        }
    }

    public void addSubClass(Clazz clazz) {
        if (this.subClasses == null) {
            this.subClasses = new Clazz[1];
        } else {
            Clazz[] newSubClasses = new Clazz[this.subClasses.length + 1];
            System.arraycopy(this.subClasses, 0, newSubClasses, 0, this.subClasses.length);
            this.subClasses = newSubClasses;
        }
        this.subClasses[this.subClasses.length - 1] = clazz;
    }

    public Clazz getSuperClass() {
        return this.u2superClass != 0 ? ((ClassConstant)this.constantPool[this.u2superClass]).referencedClass : null;
    }

    public Clazz getInterface(int index) {
        return ((ClassConstant)this.constantPool[this.u2interfaces[index]]).referencedClass;
    }

    public boolean extends_(Clazz clazz) {
        if (this.equals(clazz)) {
            return true;
        }
        Clazz superClass = this.getSuperClass();
        return superClass != null && superClass.extends_(clazz);
    }

    public boolean extends_(String className) {
        if (this.getName().equals(className)) {
            return true;
        }
        Clazz superClass = this.getSuperClass();
        return superClass != null && superClass.extends_(className);
    }

    public boolean extendsOrImplements(Clazz clazz) {
        if (this.equals(clazz)) {
            return true;
        }
        Clazz superClass = this.getSuperClass();
        if (superClass != null && superClass.extendsOrImplements(clazz)) {
            return true;
        }
        for (int index = 0; index < this.u2interfacesCount; ++index) {
            Clazz interfaceClass = this.getInterface(index);
            if (interfaceClass == null || !interfaceClass.extendsOrImplements(clazz)) continue;
            return true;
        }
        return false;
    }

    public boolean extendsOrImplements(String className) {
        if (this.getName().equals(className)) {
            return true;
        }
        Clazz superClass = this.getSuperClass();
        if (superClass != null && superClass.extendsOrImplements(className)) {
            return true;
        }
        for (int index = 0; index < this.u2interfacesCount; ++index) {
            Clazz interfaceClass = this.getInterface(index);
            if (interfaceClass == null || !interfaceClass.extendsOrImplements(className)) continue;
            return true;
        }
        return false;
    }

    public Field findField(String name, String descriptor) {
        for (int index = 0; index < this.u2fieldsCount; ++index) {
            ProgramField field = this.fields[index];
            if (name != null && !field.getName(this).equals(name) || descriptor != null && !field.getDescriptor(this).equals(descriptor)) continue;
            return field;
        }
        return null;
    }

    public Method findMethod(String name, String descriptor) {
        for (int index = 0; index < this.u2methodsCount; ++index) {
            ProgramMethod method = this.methods[index];
            if (name != null && !method.getName(this).equals(name) || descriptor != null && !method.getDescriptor(this).equals(descriptor)) continue;
            return method;
        }
        return null;
    }

    public void accept(ClassVisitor classVisitor) {
        classVisitor.visitProgramClass(this);
    }

    public void hierarchyAccept(boolean visitThisClass, boolean visitSuperClass, boolean visitInterfaces, boolean visitSubclasses, ClassVisitor classVisitor) {
        Clazz superClass;
        if (visitThisClass) {
            this.accept(classVisitor);
        }
        if (visitSuperClass && (superClass = this.getSuperClass()) != null) {
            superClass.hierarchyAccept(true, true, visitInterfaces, false, classVisitor);
        }
        if (visitInterfaces) {
            if (!visitSuperClass && (superClass = this.getSuperClass()) != null) {
                superClass.hierarchyAccept(false, false, true, false, classVisitor);
            }
            for (int index = 0; index < this.u2interfacesCount; ++index) {
                Clazz interfaceClass = this.getInterface(index);
                if (interfaceClass == null) continue;
                interfaceClass.hierarchyAccept(true, false, true, false, classVisitor);
            }
        }
        if (visitSubclasses && this.subClasses != null) {
            for (int index = 0; index < this.subClasses.length; ++index) {
                Clazz subClass = this.subClasses[index];
                subClass.hierarchyAccept(true, false, false, true, classVisitor);
            }
        }
    }

    public void subclassesAccept(ClassVisitor classVisitor) {
        if (this.subClasses != null) {
            for (int index = 0; index < this.subClasses.length; ++index) {
                this.subClasses[index].accept(classVisitor);
            }
        }
    }

    public void constantPoolEntriesAccept(ConstantVisitor constantVisitor) {
        for (int index = 1; index < this.u2constantPoolCount; ++index) {
            if (this.constantPool[index] == null) continue;
            this.constantPool[index].accept(this, constantVisitor);
        }
    }

    public void constantPoolEntryAccept(int index, ConstantVisitor constantVisitor) {
        this.constantPool[index].accept(this, constantVisitor);
    }

    public void thisClassConstantAccept(ConstantVisitor constantVisitor) {
        this.constantPool[this.u2thisClass].accept(this, constantVisitor);
    }

    public void superClassConstantAccept(ConstantVisitor constantVisitor) {
        if (this.u2superClass != 0) {
            this.constantPool[this.u2superClass].accept(this, constantVisitor);
        }
    }

    public void interfaceConstantsAccept(ConstantVisitor constantVisitor) {
        for (int index = 0; index < this.u2interfacesCount; ++index) {
            this.constantPool[this.u2interfaces[index]].accept(this, constantVisitor);
        }
    }

    public void fieldsAccept(MemberVisitor memberVisitor) {
        for (int index = 0; index < this.u2fieldsCount; ++index) {
            this.fields[index].accept(this, memberVisitor);
        }
    }

    public void fieldAccept(String name, String descriptor, MemberVisitor memberVisitor) {
        Field field = this.findField(name, descriptor);
        if (field != null) {
            field.accept(this, memberVisitor);
        }
    }

    public void methodsAccept(MemberVisitor memberVisitor) {
        for (int index = 0; index < this.u2methodsCount; ++index) {
            this.methods[index].accept(this, memberVisitor);
        }
    }

    public void methodAccept(String name, String descriptor, MemberVisitor memberVisitor) {
        Method method = this.findMethod(name, descriptor);
        if (method != null) {
            method.accept(this, memberVisitor);
        }
    }

    public boolean mayHaveImplementations(Method method) {
        return (this.u2accessFlags & 0x10) == 0 && (method == null || (method.getAccessFlags() & 0x1A) == 0 && !method.getName(this).equals("<init>"));
    }

    public void attributesAccept(AttributeVisitor attributeVisitor) {
        for (int index = 0; index < this.u2attributesCount; ++index) {
            this.attributes[index].accept(this, attributeVisitor);
        }
    }

    public void attributeAccept(String name, AttributeVisitor attributeVisitor) {
        for (int index = 0; index < this.u2attributesCount; ++index) {
            Attribute attribute = this.attributes[index];
            if (!attribute.getAttributeName(this).equals(name)) continue;
            attribute.accept(this, attributeVisitor);
        }
    }

    public Object getVisitorInfo() {
        return this.visitorInfo;
    }

    public void setVisitorInfo(Object visitorInfo) {
        this.visitorInfo = visitorInfo;
    }

    public String toString() {
        return "ProgramClass(" + this.getName() + ")";
    }
}

