/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.BasicValueFactory;
import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ParticularIntegerValue;
import proguard.evaluation.value.ParticularLongValue;
import proguard.evaluation.value.RangeValueFactory;

public final class RangeIntegerValue
extends IntegerValue {
    private final int min;
    private final int max;

    public RangeIntegerValue(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public int value() {
        return this.min;
    }

    public IntegerValue negate() {
        return new RangeIntegerValue(this.min == Integer.MIN_VALUE ? Integer.MIN_VALUE : -this.max, -this.min);
    }

    public IntegerValue convertToByte() {
        return this.min >= -128 && this.max <= 127 ? this : RangeValueFactory.INTEGER_VALUE_BYTE;
    }

    public IntegerValue convertToCharacter() {
        return this.min >= 0 && this.max <= 65535 ? this : RangeValueFactory.INTEGER_VALUE_CHAR;
    }

    public IntegerValue convertToShort() {
        return this.min >= Short.MIN_VALUE && this.max <= Short.MAX_VALUE ? this : RangeValueFactory.INTEGER_VALUE_SHORT;
    }

    public LongValue convertToLong() {
        return BasicValueFactory.LONG_VALUE;
    }

    public FloatValue convertToFloat() {
        return BasicValueFactory.FLOAT_VALUE;
    }

    public DoubleValue convertToDouble() {
        return BasicValueFactory.DOUBLE_VALUE;
    }

    public IntegerValue generalize(IntegerValue other) {
        return other.generalize(this);
    }

    public IntegerValue add(IntegerValue other) {
        return other.add(this);
    }

    public IntegerValue subtract(IntegerValue other) {
        return other.subtractFrom(this);
    }

    public IntegerValue subtractFrom(IntegerValue other) {
        return other.subtract(this);
    }

    public IntegerValue multiply(IntegerValue other) {
        return other.multiply(this);
    }

    public IntegerValue divide(IntegerValue other) throws ArithmeticException {
        return other.divideOf(this);
    }

    public IntegerValue divideOf(IntegerValue other) throws ArithmeticException {
        return other.divide(this);
    }

    public IntegerValue remainder(IntegerValue other) throws ArithmeticException {
        return other.remainderOf(this);
    }

    public IntegerValue remainderOf(IntegerValue other) throws ArithmeticException {
        return other.remainder(this);
    }

    public IntegerValue shiftLeft(IntegerValue other) {
        return other.shiftLeftOf(this);
    }

    public IntegerValue shiftLeftOf(IntegerValue other) {
        return other.shiftLeft(this);
    }

    public IntegerValue shiftRight(IntegerValue other) {
        return other.shiftRightOf(this);
    }

    public IntegerValue shiftRightOf(IntegerValue other) {
        return other.shiftRight(this);
    }

    public IntegerValue unsignedShiftRight(IntegerValue other) {
        return other.unsignedShiftRightOf(this);
    }

    public IntegerValue unsignedShiftRightOf(IntegerValue other) {
        return other.unsignedShiftRight(this);
    }

    public LongValue shiftLeftOf(LongValue other) {
        return other.shiftLeft(this);
    }

    public LongValue shiftRightOf(LongValue other) {
        return other.shiftRight(this);
    }

    public LongValue unsignedShiftRightOf(LongValue other) {
        return other.unsignedShiftRight(this);
    }

    public IntegerValue and(IntegerValue other) {
        return other.and(this);
    }

    public IntegerValue or(IntegerValue other) {
        return other.or(this);
    }

    public IntegerValue xor(IntegerValue other) {
        return other.xor(this);
    }

    public int equal(IntegerValue other) {
        return other.equal(this);
    }

    public int lessThan(IntegerValue other) {
        return other.greaterThan(this);
    }

    public int lessThanOrEqual(IntegerValue other) {
        return other.greaterThanOrEqual(this);
    }

    public IntegerValue generalize(ParticularIntegerValue other) {
        int value = other.value();
        return value < this.min ? new RangeIntegerValue(value, this.max) : (value > this.max ? new RangeIntegerValue(this.min, value) : this);
    }

    public IntegerValue add(ParticularIntegerValue other) {
        int value = other.value();
        return value == 0 ? this : ((value > 0 ? this.max + value < this.max : this.min + value > this.min) ? BasicValueFactory.INTEGER_VALUE : new RangeIntegerValue(this.min + value, this.max + value));
    }

    public IntegerValue subtract(ParticularIntegerValue other) {
        int value = other.value();
        return value == 0 ? this : ((value < 0 ? this.max - value < this.max : this.min - value > this.min) ? BasicValueFactory.INTEGER_VALUE : new RangeIntegerValue(this.min - value, this.max - value));
    }

    public IntegerValue subtractFrom(ParticularIntegerValue other) {
        int value = other.value();
        return (long)value - (long)this.max != (long)(value - this.max) || (long)value - (long)this.min != (long)(value - this.min) ? BasicValueFactory.INTEGER_VALUE : new RangeIntegerValue(value - this.max, value - this.min);
    }

    public IntegerValue multiply(ParticularIntegerValue other) {
        int value = other.value();
        return value == 0 ? other : (value == 1 ? this : ((long)this.min * (long)value != (long)(this.min * value) || (long)this.max * (long)value != (long)(this.max * value) ? BasicValueFactory.INTEGER_VALUE : (value < 0 ? new RangeIntegerValue(this.max * value, this.min * value) : new RangeIntegerValue(this.min * value, this.max * value))));
    }

    public IntegerValue divide(ParticularIntegerValue other) throws ArithmeticException {
        int value = other.value();
        return value == 0 ? BasicValueFactory.INTEGER_VALUE : (value == 1 ? this : ((long)this.min / (long)value != (long)(this.min / value) || (long)this.max / (long)value != (long)(this.max / value) ? BasicValueFactory.INTEGER_VALUE : (value < 0 ? new RangeIntegerValue(this.max / value, this.min / value) : new RangeIntegerValue(this.min / value, this.max / value))));
    }

    public IntegerValue divideOf(ParticularIntegerValue other) throws ArithmeticException {
        int value = other.value();
        return this.min <= 0 && this.max >= 0 ? BasicValueFactory.INTEGER_VALUE : ((long)value / (long)this.min != (long)(value / this.min) || (long)value / (long)this.max != (long)(value / this.max) ? BasicValueFactory.INTEGER_VALUE : (value < 0 ^ this.min < 0 ? new RangeIntegerValue(value / this.min, value / this.max) : new RangeIntegerValue(value / this.max, value / this.min)));
    }

    public IntegerValue remainder(ParticularIntegerValue other) throws ArithmeticException {
        int value = other.value();
        return value <= 0 || this.min < 0 ? BasicValueFactory.INTEGER_VALUE : (this.max < value ? this : new RangeIntegerValue(0, value - 1));
    }

    public IntegerValue remainderOf(ParticularIntegerValue other) throws ArithmeticException {
        int value = other.value();
        return value < 0 || this.min <= 0 ? BasicValueFactory.INTEGER_VALUE : (value < this.min ? other : (value < this.max ? new RangeIntegerValue(0, value) : new RangeIntegerValue(0, this.max - 1)));
    }

    public IntegerValue shiftLeft(ParticularIntegerValue other) {
        int value = other.value();
        return (value & 0x1F) == 0 ? this : ((long)this.min << value != (long)(this.min << value) || (long)this.max << value != (long)(this.max << value) ? BasicValueFactory.INTEGER_VALUE : new RangeIntegerValue(this.min << value, this.max << value));
    }

    public IntegerValue shiftRight(ParticularIntegerValue other) {
        int value = other.value();
        return (value & 0x1F) == 0 ? this : new RangeIntegerValue(this.min >> value, this.max >> value);
    }

    public IntegerValue unsignedShiftRight(ParticularIntegerValue other) {
        int value = other.value();
        return (value & 0x1F) == 0 ? this : (this.min < 0 ? (this.max > 0 ? new RangeIntegerValue(0, Integer.MIN_VALUE >>> value) : new RangeIntegerValue(this.max >>> value, this.min >>> value)) : new RangeIntegerValue(this.min >>> value, this.max >>> value));
    }

    public IntegerValue shiftLeftOf(ParticularIntegerValue other) {
        int value = other.value();
        return value == 0 ? other : (this.min < 0 || this.max >= 32 || (long)value << this.max != (long)(value << this.max) ? BasicValueFactory.INTEGER_VALUE : (value < 0 ? new RangeIntegerValue(value << this.max, value << this.min) : new RangeIntegerValue(value << this.min, value << this.max)));
    }

    public IntegerValue shiftRightOf(ParticularIntegerValue other) {
        int value = other.value();
        return value == 0 ? other : (this.min < 0 || this.max >= 32 ? BasicValueFactory.INTEGER_VALUE : (value < 0 ? new RangeIntegerValue(value >> this.min, value >> this.max) : new RangeIntegerValue(value >> this.max, value >> this.min)));
    }

    public IntegerValue unsignedShiftRightOf(ParticularIntegerValue other) {
        int value = other.value();
        return value == 0 ? other : (this.min < 0 || this.max >= 32 ? BasicValueFactory.INTEGER_VALUE : new RangeIntegerValue(value >>> this.max, value >>> this.min));
    }

    public LongValue shiftLeftOf(ParticularLongValue other) {
        long value = other.value();
        return value == 0L ? other : BasicValueFactory.LONG_VALUE;
    }

    public LongValue shiftRightOf(ParticularLongValue other) {
        long value = other.value();
        return value == 0L ? other : BasicValueFactory.LONG_VALUE;
    }

    public LongValue unsignedShiftRightOf(ParticularLongValue other) {
        long value = other.value();
        return value == 0L ? other : BasicValueFactory.LONG_VALUE;
    }

    public IntegerValue and(ParticularIntegerValue other) {
        int value = other.value();
        return value == 0 ? other : (value == -1 ? this : (value > 0 ? new RangeIntegerValue(0, value) : BasicValueFactory.INTEGER_VALUE));
    }

    public IntegerValue or(ParticularIntegerValue other) {
        int value = other.value();
        return value == 0 ? this : (value == -1 ? other : (value < 0 ? new RangeIntegerValue(value, -1) : BasicValueFactory.INTEGER_VALUE));
    }

    public IntegerValue xor(ParticularIntegerValue other) {
        int value = other.value();
        return value == 0 ? this : BasicValueFactory.INTEGER_VALUE;
    }

    public int equal(ParticularIntegerValue other) {
        int value = other.value();
        return this.min == value && this.max == value ? 1 : (value < this.min || value > this.max ? -1 : 0);
    }

    public int lessThan(ParticularIntegerValue other) {
        int value = other.value();
        return this.max < value ? 1 : (value <= this.min ? -1 : 0);
    }

    public int lessThanOrEqual(ParticularIntegerValue other) {
        int value = other.value();
        return this.max <= value ? 1 : (value < this.min ? -1 : 0);
    }

    public IntegerValue generalize(RangeIntegerValue other) {
        return this.min <= other.min && this.max >= other.max ? this : (other.min <= this.min && other.max >= this.max ? other : new RangeIntegerValue(Math.min(this.min, other.min), Math.max(this.max, other.max)));
    }

    public IntegerValue add(RangeIntegerValue other) {
        return (long)this.min + (long)other.min != (long)(this.min + other.min) || (long)this.max + (long)other.max != (long)(this.max + other.max) ? BasicValueFactory.INTEGER_VALUE : new RangeIntegerValue(this.min + other.min, this.max + other.max);
    }

    public IntegerValue subtract(RangeIntegerValue other) {
        return (long)this.min - (long)other.max != (long)(this.min - other.max) || (long)this.max - (long)other.min != (long)(this.max - other.min) ? BasicValueFactory.INTEGER_VALUE : new RangeIntegerValue(this.min - other.max, this.max - other.min);
    }

    public IntegerValue subtractFrom(RangeIntegerValue other) {
        return (long)other.min - (long)this.max != (long)(other.min - this.max) || (long)other.max - (long)this.min != (long)(other.max - this.min) ? BasicValueFactory.INTEGER_VALUE : new RangeIntegerValue(other.min - this.max, other.max - this.min);
    }

    public IntegerValue multiply(RangeIntegerValue other) {
        return BasicValueFactory.INTEGER_VALUE;
    }

    public IntegerValue divide(RangeIntegerValue other) throws ArithmeticException {
        return BasicValueFactory.INTEGER_VALUE;
    }

    public IntegerValue divideOf(RangeIntegerValue other) throws ArithmeticException {
        return BasicValueFactory.INTEGER_VALUE;
    }

    public IntegerValue remainder(RangeIntegerValue other) throws ArithmeticException {
        return BasicValueFactory.INTEGER_VALUE;
    }

    public IntegerValue remainderOf(RangeIntegerValue other) throws ArithmeticException {
        return BasicValueFactory.INTEGER_VALUE;
    }

    public IntegerValue shiftLeft(RangeIntegerValue other) {
        return BasicValueFactory.INTEGER_VALUE;
    }

    public IntegerValue shiftRight(RangeIntegerValue other) {
        return BasicValueFactory.INTEGER_VALUE;
    }

    public IntegerValue unsignedShiftRight(RangeIntegerValue other) {
        return BasicValueFactory.INTEGER_VALUE;
    }

    public IntegerValue shiftLeftOf(RangeIntegerValue other) {
        return BasicValueFactory.INTEGER_VALUE;
    }

    public IntegerValue shiftRightOf(RangeIntegerValue other) {
        return BasicValueFactory.INTEGER_VALUE;
    }

    public IntegerValue unsignedShiftRightOf(RangeIntegerValue other) {
        return BasicValueFactory.INTEGER_VALUE;
    }

    public IntegerValue and(RangeIntegerValue other) {
        return BasicValueFactory.INTEGER_VALUE;
    }

    public IntegerValue or(RangeIntegerValue other) {
        return BasicValueFactory.INTEGER_VALUE;
    }

    public IntegerValue xor(RangeIntegerValue other) {
        return BasicValueFactory.INTEGER_VALUE;
    }

    public int equal(RangeIntegerValue other) {
        return this.min == this.max && this.min == other.min && this.min == other.max ? 1 : (this.max < other.min || other.max < this.min ? -1 : 0);
    }

    public int lessThan(RangeIntegerValue other) {
        return this.max < other.min ? 1 : (other.max <= this.min ? -1 : 0);
    }

    public int lessThanOrEqual(RangeIntegerValue other) {
        return this.max <= other.min ? 1 : (other.max < this.min ? -1 : 0);
    }

    public boolean isParticular() {
        return this.min == this.max;
    }

    public boolean equals(Object object) {
        return super.equals(object) && this.min == ((RangeIntegerValue)object).min && this.max == ((RangeIntegerValue)object).max;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.min ^ this.max;
    }

    public String toString() {
        return this.min + ".." + this.max;
    }
}

