/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionFactory;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.AllParameterVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ParameterVisitor;
import proguard.classfile.visitor.ReferencedMemberVisitor;
import proguard.evaluation.value.InstructionOffsetValue;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.TypedReferenceValueFactory;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.info.SimpleEnumMarker;

public class SimpleEnumUseSimplifier
extends SimplifiedVisitor
implements AttributeVisitor,
InstructionVisitor,
ConstantVisitor,
ParameterVisitor {
    private static final boolean DEBUG = false;
    private final InstructionVisitor extraInstructionVisitor;
    private final PartialEvaluator partialEvaluator;
    private final CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor(true, true);
    private final ConstantVisitor nullParameterFixer = new ReferencedMemberVisitor(new AllParameterVisitor(false, this));
    private Clazz invocationClazz;
    private Method invocationMethod;
    private CodeAttribute invocationCodeAttribute;
    private int invocationOffset;
    private boolean isSimpleEnum;

    public SimpleEnumUseSimplifier() {
        this(new PartialEvaluator(new TypedReferenceValueFactory()), null);
    }

    public SimpleEnumUseSimplifier(PartialEvaluator partialEvaluator, InstructionVisitor extraInstructionVisitor) {
        this.partialEvaluator = partialEvaluator;
        this.extraInstructionVisitor = extraInstructionVisitor;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        if (SimpleEnumMarker.isSimpleEnum(clazz) && (method.getAccessFlags() & 8) == 0) {
            return;
        }
        this.partialEvaluator.visitCodeAttribute(clazz, method, codeAttribute);
        int codeLength = codeAttribute.u4codeLength;
        this.codeAttributeEditor.reset(codeLength);
        for (int offset = 0; offset < codeLength; ++offset) {
            if (!this.partialEvaluator.isTraced(offset)) continue;
            Instruction instruction = InstructionFactory.create(codeAttribute.code, offset);
            instruction.accept(clazz, method, codeAttribute, offset, this);
        }
        this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
    }

    public void visitSimpleInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SimpleInstruction simpleInstruction) {
        switch (simpleInstruction.opcode) {
            case 50: {
                if (!this.isPushingSimpleEnum(offset)) break;
                this.replaceInstruction(clazz, offset, simpleInstruction, new SimpleInstruction(46));
                break;
            }
            case 83: {
                if (!this.isPoppingSimpleEnumArray(offset, 2)) break;
                this.replaceInstruction(clazz, offset, simpleInstruction, new SimpleInstruction(79));
                this.replaceNullStackEntryProducers(clazz, method, codeAttribute, offset);
                break;
            }
            case -80: {
                if (!this.isReturningSimpleEnum(clazz, method)) break;
                this.replaceInstruction(clazz, offset, simpleInstruction, new SimpleInstruction(-84));
                this.replaceNullStackEntryProducers(clazz, method, codeAttribute, offset);
            }
        }
    }

    public void visitVariableInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VariableInstruction variableInstruction) {
        int variableIndex = variableInstruction.variableIndex;
        switch (variableInstruction.opcode) {
            case 25: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                if (!this.isPushingSimpleEnum(offset)) break;
                this.replaceInstruction(clazz, offset, variableInstruction, new VariableInstruction(21, variableIndex));
                this.replaceNullVariableProducers(clazz, method, codeAttribute, offset, variableIndex);
                break;
            }
            case 58: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                if (this.partialEvaluator.isSubroutineStart(offset) || !this.isPoppingSimpleEnum(offset)) break;
                this.replaceInstruction(clazz, offset, variableInstruction, new VariableInstruction(54, variableIndex));
                this.replaceNullStackEntryProducers(clazz, method, codeAttribute, offset);
            }
        }
    }

    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        switch (constantInstruction.opcode) {
            case -77: 
            case -75: {
                this.invocationClazz = clazz;
                this.invocationMethod = method;
                this.invocationCodeAttribute = codeAttribute;
                this.invocationOffset = offset;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.nullParameterFixer);
                break;
            }
            case -74: {
                String invokedMethodName = clazz.getRefName(constantInstruction.constantIndex);
                String invokedMethodType = clazz.getRefType(constantInstruction.constantIndex);
                int stackEntryIndex = ClassUtil.internalMethodParameterSize(invokedMethodType);
                if (this.isPoppingSimpleEnum(offset, stackEntryIndex)) {
                    this.replaceSupportedMethod(clazz, offset, constantInstruction, invokedMethodName, invokedMethodType);
                }
            }
            case -73: 
            case -72: 
            case -71: {
                this.invocationClazz = clazz;
                this.invocationMethod = method;
                this.invocationCodeAttribute = codeAttribute;
                this.invocationOffset = offset;
                clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.nullParameterFixer);
                break;
            }
            case -67: {
                int constantIndex = constantInstruction.constantIndex;
                if (!this.isReferencingSimpleEnum(clazz, constantIndex) || ClassUtil.isInternalArrayType(clazz.getClassName(constantIndex))) break;
                this.replaceInstruction(clazz, offset, constantInstruction, new SimpleInstruction(-68, 10));
                break;
            }
            case -64: {
                if (!this.isPoppingSimpleEnum(offset)) break;
                this.deleteInstruction(clazz, offset, constantInstruction);
                this.replaceNullStackEntryProducers(clazz, method, codeAttribute, offset);
                break;
            }
            case -63: {
                if (!this.isPoppingSimpleEnum(offset)) break;
                this.replaceInstruction(clazz, offset, constantInstruction, new SimpleInstruction(4));
                this.replaceNullStackEntryProducers(clazz, method, codeAttribute, offset);
            }
        }
    }

    public void visitBranchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, BranchInstruction branchInstruction) {
        switch (branchInstruction.opcode) {
            case -91: {
                if (!this.isPoppingSimpleEnum(offset)) break;
                this.replaceInstruction(clazz, offset, branchInstruction, new BranchInstruction(-97, branchInstruction.branchOffset));
                this.replaceNullStackEntryProducers(clazz, method, codeAttribute, offset, 0);
                this.replaceNullStackEntryProducers(clazz, method, codeAttribute, offset, 1);
                break;
            }
            case -90: {
                if (!this.isPoppingSimpleEnum(offset)) break;
                this.replaceInstruction(clazz, offset, branchInstruction, new BranchInstruction(-96, branchInstruction.branchOffset));
                this.replaceNullStackEntryProducers(clazz, method, codeAttribute, offset, 0);
                this.replaceNullStackEntryProducers(clazz, method, codeAttribute, offset, 1);
                break;
            }
            case -58: {
                if (!this.isPoppingSimpleEnum(offset)) break;
                this.replaceInstruction(clazz, offset, branchInstruction, new BranchInstruction(-103, branchInstruction.branchOffset));
                break;
            }
            case -57: {
                if (!this.isPoppingSimpleEnum(offset)) break;
                this.replaceInstruction(clazz, offset, branchInstruction, new BranchInstruction(-102, branchInstruction.branchOffset));
            }
        }
    }

    public void visitAnySwitchInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SwitchInstruction switchInstruction) {
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.isSimpleEnum = this.isSimpleEnum(stringConstant.referencedClass);
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.isSimpleEnum = this.isSimpleEnum(classConstant.referencedClass);
    }

    public void visitParameter(Clazz clazz, Member member, int parameterIndex, int parameterCount, int parameterOffset, int parameterSize, String parameterType, Clazz referencedClass) {
        if (!ClassUtil.isInternalPrimitiveType(parameterType.charAt(0)) && !ClassUtil.isInternalArrayType(parameterType) && this.isSimpleEnum(referencedClass)) {
            int stackEntryIndex = parameterSize - parameterOffset - 1;
            this.replaceNullStackEntryProducers(this.invocationClazz, this.invocationMethod, this.invocationCodeAttribute, this.invocationOffset, stackEntryIndex);
        }
    }

    private boolean isReferencingSimpleEnum(Clazz clazz, int constantIndex) {
        this.isSimpleEnum = false;
        clazz.constantPoolEntryAccept(constantIndex, this);
        return this.isSimpleEnum;
    }

    private boolean isReturningSimpleEnum(Clazz clazz, Method method) {
        Clazz[] referencedClasses;
        String descriptor = method.getDescriptor(clazz);
        String returnType = ClassUtil.internalMethodReturnType(descriptor);
        if (ClassUtil.isInternalClassType(returnType) && !ClassUtil.isInternalArrayType(returnType) && (referencedClasses = ((ProgramMethod)method).referencedClasses) != null) {
            Clazz returnedClass = referencedClasses[referencedClasses.length - 1];
            return this.isSimpleEnum(returnedClass);
        }
        return false;
    }

    private boolean isPushingSimpleEnum(int offset) {
        ReferenceValue referenceValue = this.partialEvaluator.getStackAfter(offset).getTop(0).referenceValue();
        Clazz referencedClass = referenceValue.getReferencedClass();
        return this.isSimpleEnum(referencedClass) && !ClassUtil.isInternalArrayType(referenceValue.getType());
    }

    private boolean isPoppingSimpleEnum(int offset) {
        return this.isPoppingSimpleEnum(offset, 0);
    }

    private boolean isPoppingSimpleEnum(int offset, int stackEntryIndex) {
        ReferenceValue referenceValue = this.partialEvaluator.getStackBefore(offset).getTop(stackEntryIndex).referenceValue();
        return this.isSimpleEnum(referenceValue.getReferencedClass()) && !ClassUtil.isInternalArrayType(referenceValue.getType());
    }

    private boolean isPoppingSimpleEnumType(int offset, int stackEntryIndex) {
        ReferenceValue referenceValue = this.partialEvaluator.getStackBefore(offset).getTop(stackEntryIndex).referenceValue();
        return this.isSimpleEnum(referenceValue.getReferencedClass());
    }

    private boolean isPoppingSimpleEnumArray(int offset, int stackEntryIndex) {
        ReferenceValue referenceValue = this.partialEvaluator.getStackBefore(offset).getTop(stackEntryIndex).referenceValue();
        return this.isSimpleEnum(referenceValue.getReferencedClass()) && ClassUtil.internalArrayTypeDimensionCount(referenceValue.getType()) == 1;
    }

    private boolean isSimpleEnum(Clazz clazz) {
        return clazz != null && SimpleEnumMarker.isSimpleEnum(clazz);
    }

    private void replaceSupportedMethod(Clazz clazz, int offset, Instruction instruction, String name, String type) {
        if (name.equals("ordinal") && type.equals("()I")) {
            Instruction[] replacementInstructions = new Instruction[]{new SimpleInstruction(4), new SimpleInstruction(100)};
            this.replaceInstructions(clazz, offset, instruction, replacementInstructions);
        }
    }

    private void replaceInstructions(Clazz clazz, int offset, Instruction instruction, Instruction[] replacementInstructions) {
        this.codeAttributeEditor.replaceInstruction(offset, replacementInstructions);
        if (this.extraInstructionVisitor != null) {
            instruction.accept(clazz, null, null, offset, this.extraInstructionVisitor);
        }
    }

    private void replaceInstruction(Clazz clazz, int offset, Instruction instruction, Instruction replacementInstruction) {
        int popCount = instruction.stackPopCount(clazz) - replacementInstruction.stackPopCount(clazz);
        this.insertPopInstructions(offset, popCount);
        this.codeAttributeEditor.replaceInstruction(offset, replacementInstruction);
        if (this.extraInstructionVisitor != null) {
            instruction.accept(clazz, null, null, offset, this.extraInstructionVisitor);
        }
    }

    private void deleteInstruction(Clazz clazz, int offset, Instruction instruction) {
        this.codeAttributeEditor.deleteInstruction(offset);
        if (this.extraInstructionVisitor != null) {
            instruction.accept(clazz, null, null, offset, this.extraInstructionVisitor);
        }
    }

    private void insertPopInstructions(int offset, int popCount) {
        switch (popCount) {
            case 0: {
                break;
            }
            case 1: {
                SimpleInstruction popInstruction = new SimpleInstruction(87);
                this.codeAttributeEditor.insertBeforeInstruction(offset, popInstruction);
                break;
            }
            case 2: {
                SimpleInstruction popInstruction = new SimpleInstruction(88);
                this.codeAttributeEditor.insertBeforeInstruction(offset, popInstruction);
                break;
            }
            default: {
                Instruction[] popInstructions = new Instruction[popCount / 2 + popCount % 2];
                SimpleInstruction popInstruction = new SimpleInstruction(88);
                for (int index = 0; index < popCount / 2; ++index) {
                    popInstructions[index] = popInstruction;
                }
                if (popCount % 2 == 1) {
                    popInstruction = new SimpleInstruction(87);
                    popInstructions[popCount / 2] = popInstruction;
                }
                this.codeAttributeEditor.insertBeforeInstruction(offset, popInstructions);
                break;
            }
        }
    }

    private void replaceNullStackEntryProducers(Clazz clazz, Method method, CodeAttribute codeAttribute, int consumerOffset) {
        this.replaceNullStackEntryProducers(clazz, method, codeAttribute, consumerOffset, 0);
    }

    private void replaceNullStackEntryProducers(Clazz clazz, Method method, CodeAttribute codeAttribute, int consumerOffset, int stackEntryIndex) {
        InstructionOffsetValue producerOffsets = this.partialEvaluator.getStackBefore(consumerOffset).getTopActualProducerValue(stackEntryIndex).instructionOffsetValue();
        block3: for (int index = 0; index < producerOffsets.instructionOffsetCount(); ++index) {
            int producerOffset = producerOffsets.instructionOffset(index);
            if (producerOffset < 0 || this.partialEvaluator.getStackAfter(producerOffset).getTop(0).referenceValue().isNull() != 1) continue;
            Instruction producerInstruction = InstructionFactory.create(codeAttribute.code[producerOffset]);
            switch (producerInstruction.opcode) {
                case 1: 
                case 25: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    this.replaceInstruction(clazz, producerOffset, producerInstruction, new SimpleInstruction(3));
                    continue block3;
                }
                default: {
                    this.replaceInstructions(clazz, producerOffset, producerInstruction, new Instruction[]{producerInstruction, new SimpleInstruction(87), new SimpleInstruction(3)});
                }
            }
        }
    }

    private void replaceNullVariableProducers(Clazz clazz, Method method, CodeAttribute codeAttribute, int consumerOffset, int variableIndex) {
        InstructionOffsetValue producerOffsets = this.partialEvaluator.getVariablesBefore(consumerOffset).getProducerValue(variableIndex).instructionOffsetValue();
        for (int index = 0; index < producerOffsets.instructionOffsetCount(); ++index) {
            int producerOffset;
            if (producerOffsets.isMethodParameter(index) || producerOffsets.isExceptionHandler(index) || this.partialEvaluator.getVariablesAfter(producerOffset = producerOffsets.instructionOffset(index)).getValue(variableIndex).referenceValue().isNull() != 1) continue;
            this.replaceInstruction(clazz, producerOffset, new VariableInstruction(58, variableIndex), new VariableInstruction(54, variableIndex));
            this.replaceNullStackEntryProducers(clazz, method, codeAttribute, producerOffset);
        }
    }
}

