/*
 * Decompiled with CFR 0.152.
 */
package proguard.backport;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import proguard.backport.LambdaExpression;
import proguard.backport.LambdaExpressionCollector;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.editor.ClassEditor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.CompactCodeAttributeComposer;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.editor.MemberRemover;
import proguard.classfile.editor.SimplifiedClassEditor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.AccessUtil;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassSubHierarchyInitializer;
import proguard.classfile.util.ClassSuperHierarchyInitializer;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.InternalTypeEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.util.MultiValueMap;

public class LambdaExpressionConverter
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
AttributeVisitor,
InstructionVisitor {
    private static final String LAMBDA_SINGLETON_FIELD_NAME = "INSTANCE";
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final MultiValueMap<String, String> injectedClassNameMap;
    private final ClassVisitor extraClassVisitor;
    private final Map<Integer, LambdaExpression> lambdaExpressionMap;
    private final CodeAttributeEditor codeAttributeEditor;
    private final MemberRemover memberRemover;
    private static final String METHOD_NAME_DESERIALIZE_LAMBDA = "$deserializeLambda$";
    private static final String METHOD_TYPE_DESERIALIZE_LAMBDA = "(Ljava/lang/invoke/SerializedLambda;)Ljava/lang/Object;";

    public LambdaExpressionConverter(ClassPool programClassPool, ClassPool libraryClassPool, MultiValueMap<String, String> injectedClassNameMap, ClassVisitor extraClassVisitor) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.injectedClassNameMap = injectedClassNameMap;
        this.extraClassVisitor = extraClassVisitor;
        this.lambdaExpressionMap = new HashMap<Integer, LambdaExpression>();
        this.codeAttributeEditor = new CodeAttributeEditor(true, true);
        this.memberRemover = new MemberRemover();
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.lambdaExpressionMap.clear();
        programClass.accept(new LambdaExpressionCollector(this.lambdaExpressionMap));
        for (LambdaExpression lambdaExpression : this.lambdaExpressionMap.values()) {
            ProgramClass lambdaClass = this.createLambdaClass(lambdaExpression);
            this.programClassPool.addClass(lambdaClass);
            this.injectedClassNameMap.put(programClass.getName(), lambdaClass.getName());
            if (this.extraClassVisitor == null) continue;
            this.extraClassVisitor.visitProgramClass(lambdaClass);
        }
        if (!this.lambdaExpressionMap.isEmpty()) {
            programClass.accept(new AllMethodVisitor(new AllAttributeVisitor(this)));
            for (LambdaExpression lambdaExpression : this.lambdaExpressionMap.values()) {
                lambdaExpression.lambdaClass.accept(new MultiClassVisitor(new ClassSuperHierarchyInitializer(this.programClassPool, this.libraryClassPool), new ClassSubHierarchyInitializer(), new ClassReferenceInitializer(this.programClassPool, this.libraryClassPool)));
            }
            programClass.methodsAccept(this);
            this.memberRemover.visitProgramClass(programClass);
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
        codeAttribute.instructionsAccept(clazz, method, this);
        if (this.codeAttributeEditor.isModified()) {
            this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        ProgramClass programClass;
        InvokeDynamicConstant invokeDynamicConstant;
        int bootstrapMethodIndex;
        if (constantInstruction.opcode == -70 && this.lambdaExpressionMap.containsKey(bootstrapMethodIndex = (invokeDynamicConstant = (InvokeDynamicConstant)(programClass = (ProgramClass)clazz).getConstant(constantInstruction.constantIndex)).getBootstrapMethodAttributeIndex())) {
            LambdaExpression lambdaExpression = this.lambdaExpressionMap.get(bootstrapMethodIndex);
            String lambdaClassName = lambdaExpression.getLambdaClassName();
            InstructionSequenceBuilder builder = new InstructionSequenceBuilder(programClass);
            if (lambdaExpression.isStateless()) {
                builder.getstatic(lambdaClassName, LAMBDA_SINGLETON_FIELD_NAME, ClassUtil.internalTypeFromClassName(lambdaClassName));
            } else {
                String type;
                int maxLocals = codeAttribute.u2maxLocals;
                String methodDescriptor = lambdaExpression.getConstructorDescriptor();
                int parameterSize = ClassUtil.internalMethodParameterSize(methodDescriptor);
                if (parameterSize == 1) {
                    // empty if block
                }
                InternalTypeEnumeration typeEnumeration = new InternalTypeEnumeration(methodDescriptor);
                ArrayList<String> types = new ArrayList<String>();
                while (typeEnumeration.hasMoreTypes()) {
                    types.add(typeEnumeration.nextType());
                }
                int variableIndex = maxLocals;
                ListIterator typeIterator = types.listIterator(types.size());
                while (typeIterator.hasPrevious()) {
                    type = (String)typeIterator.previous();
                    builder.store(variableIndex, type);
                    variableIndex += ClassUtil.internalTypeSize(type);
                }
                builder.new_(lambdaClassName);
                builder.dup();
                typeIterator = types.listIterator();
                while (typeIterator.hasNext()) {
                    type = (String)typeIterator.next();
                    int variableSize = ClassUtil.internalTypeSize(type);
                    builder.load(variableIndex -= variableSize, type);
                }
                builder.invokespecial(lambdaClassName, "<init>", methodDescriptor);
            }
            this.codeAttributeEditor.replaceInstruction(offset, builder.instructions());
        }
    }

    @Override
    public void visitAnyMember(Clazz clazz, Member member) {
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (LambdaExpressionConverter.isDeserializationHook(programClass, programMethod)) {
            this.memberRemover.visitProgramMethod(programClass, programMethod);
        }
    }

    private static boolean isDeserializationHook(Clazz clazz, Method method) {
        return method.getName(clazz).equals(METHOD_NAME_DESERIALIZE_LAMBDA) && method.getDescriptor(clazz).equals(METHOD_TYPE_DESERIALIZE_LAMBDA) && LambdaExpressionConverter.hasFlag(method, 4106);
    }

    private static boolean hasFlag(Member member, int flag) {
        return (member.getAccessFlags() & flag) == flag;
    }

    private ProgramClass createLambdaClass(LambdaExpression lambdaExpression) {
        String[] interfaces;
        String lambdaClassName = lambdaExpression.getLambdaClassName();
        ProgramClass lambdaClass = new ProgramClass(0x310000, 1, new Constant[10], 0, 0, 0);
        ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(lambdaClass);
        lambdaClass.u2thisClass = constantPoolEditor.addClassConstant(lambdaClassName, lambdaClass);
        lambdaClass.u2superClass = constantPoolEditor.addClassConstant("java/lang/Object", null);
        ClassEditor classEditor = new ClassEditor(lambdaClass);
        for (String interfaceName : interfaces = lambdaExpression.interfaces) {
            classEditor.addInterface(constantPoolEditor.addClassConstant(interfaceName, null));
        }
        lambdaExpression.lambdaClass = lambdaClass;
        if (lambdaExpression.referencesPrivateConstructor() || lambdaExpression.needsAccessorMethod()) {
            this.addAccessorMethod(lambdaExpression.referencedClass, lambdaExpression);
        }
        if (lambdaExpression.isStateless()) {
            this.completeStatelessLambdaClass(lambdaClass, lambdaExpression);
        } else {
            this.completeCapturingLambdaClass(lambdaClass, lambdaExpression);
        }
        if (lambdaExpression.bridgeMethodDescriptors.length > 0) {
            this.addBridgeMethods(lambdaClass, lambdaExpression);
        }
        return lambdaClass;
    }

    private void fixAccessFlags(LambdaExpression lambdaExpression) {
        ProgramMethod invokedProgramMethod;
        int currentAccessFlags;
        if (lambdaExpression.referencedInvokedMethod instanceof ProgramMethod && ((currentAccessFlags = (invokedProgramMethod = (ProgramMethod)lambdaExpression.referencedInvokedMethod).getAccessFlags()) & 2) != 0) {
            invokedProgramMethod.u2accessFlags = AccessUtil.replaceAccessFlags(currentAccessFlags, AccessUtil.accessFlags(1));
            if (lambdaExpression.invokedReferenceKind == 7) {
                lambdaExpression.invokedReferenceKind = 5;
            }
        }
    }

    private void addAccessorMethod(ProgramClass programClass, LambdaExpression lambdaExpression) {
        SimplifiedClassEditor classEditor = new SimplifiedClassEditor(programClass);
        String className = programClass.getName();
        String shortClassName = ClassUtil.externalShortClassName(ClassUtil.externalClassName(className));
        String accessorMethodName = String.format("accessor$%s$lambda%d", shortClassName, lambdaExpression.bootstrapMethodIndex);
        String accessorMethodDescriptor = lambdaExpression.invokedMethodDesc;
        int accessFlags = lambdaExpression.referencedInvokedMethod.getAccessFlags();
        if (lambdaExpression.invokedReferenceKind == 8) {
            ArrayList<String> invokedParameterTypes = new ArrayList<String>();
            int methodParameterSize = ClassUtil.internalMethodParameterSize(accessorMethodDescriptor);
            for (int i = 0; i < methodParameterSize; ++i) {
                String invokedParameterType = ClassUtil.internalMethodParameterType(accessorMethodDescriptor, i);
                invokedParameterTypes.add(invokedParameterType);
            }
            String invokedClassType = ClassUtil.internalTypeFromClassName(lambdaExpression.invokedClassName);
            accessorMethodDescriptor = ClassUtil.internalMethodDescriptorFromInternalTypes(invokedClassType, invokedParameterTypes);
        } else if ((accessFlags & 8) == 0) {
            accessorMethodDescriptor = LambdaExpressionConverter.prependParameterToMethodDescriptor(accessorMethodDescriptor, ClassUtil.internalTypeFromClassType(className));
        }
        CompactCodeAttributeComposer composer = classEditor.addMethod(4104, accessorMethodName, accessorMethodDescriptor, 50);
        if (lambdaExpression.invokedReferenceKind == 8) {
            composer.new_(lambdaExpression.invokedClassName).dup();
        }
        InternalTypeEnumeration typeEnumeration = new InternalTypeEnumeration(accessorMethodDescriptor);
        this.completeInterfaceMethod(lambdaExpression, composer, 0, typeEnumeration, null);
        classEditor.finishEditing();
        lambdaExpression.invokedClassName = programClass.getName();
        lambdaExpression.invokedMethodName = accessorMethodName;
        lambdaExpression.invokedMethodDesc = accessorMethodDescriptor;
        lambdaExpression.invokedReferenceKind = 6;
        lambdaExpression.referencedInvokedClass = programClass;
        lambdaExpression.referencedInvokedMethod = programClass.findMethod(accessorMethodName, accessorMethodDescriptor);
    }

    private void completeStatelessLambdaClass(ProgramClass lambdaClass, LambdaExpression lambdaExpression) {
        String lambdaClassType = ClassUtil.internalTypeFromClassName(lambdaClass.getName());
        SimplifiedClassEditor classEditor = new SimplifiedClassEditor(lambdaClass);
        classEditor.addField(25, LAMBDA_SINGLETON_FIELD_NAME, lambdaClassType);
        CompactCodeAttributeComposer composer = classEditor.addMethod(1, "<init>", "()V", 10);
        composer.aload_0().invokespecial("java/lang/Object", "<init>", "()V").return_();
        composer = classEditor.addMethod(8, "<clinit>", "()V", 30);
        composer.new_(lambdaClass.getName()).dup().invokespecial(lambdaClass.getName(), "<init>", "()V").putstatic(lambdaClass.getName(), LAMBDA_SINGLETON_FIELD_NAME, lambdaClassType).return_();
        if (lambdaExpression.isSerializable()) {
            composer = classEditor.addMethod(2, "readResolve", "()Ljava/lang/Object;", 10);
            composer.getstatic(lambdaClass.getName(), LAMBDA_SINGLETON_FIELD_NAME, lambdaClassType).areturn();
        }
        composer = classEditor.addMethod(1, lambdaExpression.interfaceMethod, lambdaExpression.interfaceMethodDescriptor, 50);
        if (lambdaExpression.invokedReferenceKind == 8) {
            InternalTypeEnumeration typeEnumeration = new InternalTypeEnumeration(lambdaExpression.interfaceMethodDescriptor);
            InternalTypeEnumeration invokedTypeEnumeration = new InternalTypeEnumeration(lambdaExpression.invokedMethodDesc);
            composer.new_(lambdaExpression.invokedClassName).dup();
            this.completeInterfaceMethod(lambdaExpression, composer, 1, typeEnumeration, invokedTypeEnumeration);
        } else {
            InternalTypeEnumeration typeEnumeration = new InternalTypeEnumeration(lambdaExpression.interfaceMethodDescriptor);
            InternalTypeEnumeration invokedTypeEnumeration = new InternalTypeEnumeration(lambdaExpression.invokedMethodDesc);
            boolean isInvokeVirtualOrInterface = lambdaExpression.invokedReferenceKind == 5 || lambdaExpression.invokedReferenceKind == 9;
            int paramIndex = 1;
            if (isInvokeVirtualOrInterface) {
                String type = typeEnumeration.nextType();
                String invokedType = ClassUtil.internalTypeFromClassName(lambdaExpression.invokedClassName);
                composer.load(paramIndex, type);
                paramIndex += ClassUtil.internalTypeSize(type);
                LambdaExpressionConverter.convertToTargetType(type, invokedType, composer);
            }
            this.completeInterfaceMethod(lambdaExpression, composer, paramIndex, typeEnumeration, invokedTypeEnumeration);
        }
        classEditor.finishEditing();
    }

    private void completeCapturingLambdaClass(ProgramClass lambdaClass, LambdaExpression lambdaExpression) {
        SimplifiedClassEditor classEditor = new SimplifiedClassEditor(lambdaClass);
        String ctorDescriptor = lambdaExpression.getConstructorDescriptor();
        CompactCodeAttributeComposer composer = classEditor.addMethod(1, "<init>", ctorDescriptor, 50);
        composer.aload_0().invokespecial("java/lang/Object", "<init>", "()V");
        InternalTypeEnumeration typeEnumeration = new InternalTypeEnumeration(ctorDescriptor);
        int argIndex = 0;
        int variableIndex = 1;
        while (typeEnumeration.hasMoreTypes()) {
            String type = typeEnumeration.nextType();
            String fieldName = "arg$" + argIndex++;
            classEditor.addField(18, fieldName, type);
            composer.aload_0();
            composer.load(variableIndex, type);
            composer.putfield(lambdaClass.getName(), fieldName, type);
            variableIndex += ClassUtil.internalTypeSize(type);
        }
        composer.return_();
        composer = classEditor.addMethod(1, lambdaExpression.interfaceMethod, lambdaExpression.interfaceMethodDescriptor, 50);
        typeEnumeration = new InternalTypeEnumeration(ctorDescriptor);
        InternalTypeEnumeration invokedTypeEnumeration = new InternalTypeEnumeration(lambdaExpression.invokedMethodDesc);
        boolean isInvokeVirtualOrInterface = lambdaExpression.invokedReferenceKind == 5 || lambdaExpression.invokedReferenceKind == 9;
        argIndex = 0;
        while (typeEnumeration.hasMoreTypes()) {
            String type = typeEnumeration.nextType();
            String invokedType = isInvokeVirtualOrInterface && argIndex == 0 ? null : invokedTypeEnumeration.nextType();
            String fieldName = "arg$" + argIndex++;
            composer.aload_0().getfield(lambdaClass.getName(), fieldName, type);
            if (invokedType == null) continue;
            LambdaExpressionConverter.convertToTargetType(type, invokedType, composer);
        }
        typeEnumeration = new InternalTypeEnumeration(lambdaExpression.interfaceMethodDescriptor);
        this.completeInterfaceMethod(lambdaExpression, composer, 1, typeEnumeration, invokedTypeEnumeration);
        classEditor.finishEditing();
    }

    private void completeInterfaceMethod(LambdaExpression lambdaExpression, CompactCodeAttributeComposer composer, int parameterIndex, InternalTypeEnumeration typeEnumeration, InternalTypeEnumeration invokedTypeEnumeration) {
        while (typeEnumeration.hasMoreTypes()) {
            String type = typeEnumeration.nextType();
            String invokedType = invokedTypeEnumeration != null ? invokedTypeEnumeration.nextType() : null;
            composer.load(parameterIndex, type);
            parameterIndex += ClassUtil.internalTypeSize(type);
            if (invokedType == null) continue;
            LambdaExpressionConverter.convertToTargetType(type, invokedType, composer);
        }
        switch (lambdaExpression.invokedReferenceKind) {
            case 6: {
                if (lambdaExpression.invokesStaticInterfaceMethod()) {
                    composer.invokestaticinterface(lambdaExpression.invokedClassName, lambdaExpression.invokedMethodName, lambdaExpression.invokedMethodDesc, lambdaExpression.referencedInvokedClass, lambdaExpression.referencedInvokedMethod);
                    break;
                }
                composer.invokestatic(lambdaExpression.invokedClassName, lambdaExpression.invokedMethodName, lambdaExpression.invokedMethodDesc, lambdaExpression.referencedInvokedClass, lambdaExpression.referencedInvokedMethod);
                break;
            }
            case 5: {
                composer.invokevirtual(lambdaExpression.invokedClassName, lambdaExpression.invokedMethodName, lambdaExpression.invokedMethodDesc, lambdaExpression.referencedInvokedClass, lambdaExpression.referencedInvokedMethod);
                break;
            }
            case 9: {
                composer.invokeinterface(lambdaExpression.invokedClassName, lambdaExpression.invokedMethodName, lambdaExpression.invokedMethodDesc, lambdaExpression.referencedInvokedClass, lambdaExpression.referencedInvokedMethod);
                break;
            }
            case 7: 
            case 8: {
                composer.invokespecial(lambdaExpression.invokedClassName, lambdaExpression.invokedMethodName, lambdaExpression.invokedMethodDesc, lambdaExpression.referencedInvokedClass, lambdaExpression.referencedInvokedMethod);
            }
        }
        String methodReturnType = typeEnumeration.returnType();
        if (invokedTypeEnumeration != null) {
            LambdaExpressionConverter.convertToTargetType(invokedTypeEnumeration.returnType(), methodReturnType, composer);
        }
        composer.return_(methodReturnType);
    }

    private void addBridgeMethods(ProgramClass lambdaClass, LambdaExpression lambdaExpression) {
        SimplifiedClassEditor classEditor = new SimplifiedClassEditor(lambdaClass);
        String methodName = lambdaExpression.interfaceMethod;
        for (String bridgeMethodDescriptor : lambdaExpression.bridgeMethodDescriptors) {
            Method method = lambdaClass.findMethod(methodName, bridgeMethodDescriptor);
            if (method != null) continue;
            CompactCodeAttributeComposer composer = classEditor.addMethod(4161, methodName, bridgeMethodDescriptor, 50);
            composer.aload_0();
            InternalTypeEnumeration interfaceTypeEnumeration = new InternalTypeEnumeration(lambdaExpression.interfaceMethodDescriptor);
            InternalTypeEnumeration bridgeTypeEnumeration = new InternalTypeEnumeration(bridgeMethodDescriptor);
            int variableIndex = 1;
            while (bridgeTypeEnumeration.hasMoreTypes()) {
                String type = bridgeTypeEnumeration.nextType();
                String interfaceType = interfaceTypeEnumeration.nextType();
                composer.load(variableIndex, type);
                variableIndex += ClassUtil.internalTypeSize(type);
                LambdaExpressionConverter.convertToTargetType(type, interfaceType, composer);
            }
            composer.invokevirtual(lambdaClass.getName(), lambdaExpression.interfaceMethod, lambdaExpression.interfaceMethodDescriptor);
            String methodReturnType = bridgeTypeEnumeration.returnType();
            LambdaExpressionConverter.convertToTargetType(interfaceTypeEnumeration.returnType(), methodReturnType, composer);
            composer.return_(methodReturnType);
        }
        classEditor.finishEditing();
    }

    private static String prependParameterToMethodDescriptor(String methodDescriptor, String type) {
        StringBuilder methodDescBuilder = new StringBuilder();
        methodDescBuilder.append('(');
        methodDescBuilder.append(type);
        InternalTypeEnumeration typeEnumeration = new InternalTypeEnumeration(methodDescriptor);
        while (typeEnumeration.hasMoreTypes()) {
            methodDescBuilder.append(typeEnumeration.nextType());
        }
        methodDescBuilder.append(')');
        methodDescBuilder.append(typeEnumeration.returnType());
        return methodDescBuilder.toString();
    }

    private static void convertToTargetType(String sourceType, String targetType, CompactCodeAttributeComposer composer) {
        if (ClassUtil.isInternalPrimitiveType(sourceType) && !ClassUtil.isInternalPrimitiveType(targetType)) {
            switch (sourceType.charAt(0)) {
                case 'I': {
                    composer.invokestatic("java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                    break;
                }
                case 'B': {
                    composer.invokestatic("java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                    break;
                }
                case 'C': {
                    composer.invokestatic("java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                    break;
                }
                case 'S': {
                    composer.invokestatic("java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                    break;
                }
                case 'Z': {
                    composer.invokestatic("java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                    break;
                }
                case 'J': {
                    composer.invokestatic("java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                    break;
                }
                case 'F': {
                    composer.invokestatic("java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                    break;
                }
                case 'D': {
                    composer.invokestatic("java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                }
            }
        } else if (!ClassUtil.isInternalPrimitiveType(sourceType) && ClassUtil.isInternalPrimitiveType(targetType)) {
            boolean castRequired = sourceType.equals("Ljava/lang/Object;");
            switch (targetType.charAt(0)) {
                case 'I': {
                    if (castRequired) {
                        composer.checkcast("java/lang/Number");
                    }
                    composer.invokevirtual("java/lang/Number", "intValue", "()I");
                    break;
                }
                case 'B': {
                    if (castRequired) {
                        composer.checkcast("java/lang/Byte");
                    }
                    composer.invokevirtual("java/lang/Byte", "byteValue", "()B");
                    break;
                }
                case 'C': {
                    if (castRequired) {
                        composer.checkcast("java/lang/Character");
                    }
                    composer.invokevirtual("java/lang/Character", "charValue", "()C");
                    break;
                }
                case 'S': {
                    if (castRequired) {
                        composer.checkcast("java/lang/Short");
                    }
                    composer.invokevirtual("java/lang/Short", "shortValue", "()S");
                    break;
                }
                case 'Z': {
                    if (castRequired) {
                        composer.checkcast("java/lang/Boolean");
                    }
                    composer.invokevirtual("java/lang/Boolean", "booleanValue", "()Z");
                    break;
                }
                case 'J': {
                    if (castRequired) {
                        composer.checkcast("java/lang/Number");
                    }
                    composer.invokevirtual("java/lang/Number", "longValue", "()J");
                    break;
                }
                case 'F': {
                    if (castRequired) {
                        composer.checkcast("java/lang/Number");
                    }
                    composer.invokevirtual("java/lang/Number", "floatValue", "()F");
                    break;
                }
                case 'D': {
                    if (castRequired) {
                        composer.checkcast("java/lang/Number");
                    }
                    composer.invokevirtual("java/lang/Number", "doubleValue", "()D");
                }
            }
        } else if (ClassUtil.isInternalClassType(sourceType) && (ClassUtil.isInternalClassType(targetType) || ClassUtil.isInternalArrayType(targetType)) && !sourceType.equals(targetType) && !"Ljava/lang/Object;".equals(targetType)) {
            composer.checkcast(ClassUtil.internalClassTypeFromType(targetType));
        }
    }
}

