/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import java.util.HashMap;
import java.util.Map;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.editor.SimplifiedClassEditor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.MethodLinker;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.gson.FieldSignatureCollector;
import proguard.optimize.gson.GsonRuntimeSettings;
import proguard.optimize.gson.InlineSerializer;
import proguard.optimize.gson.InlineSerializers;
import proguard.optimize.gson.OptimizedClassConstants;
import proguard.optimize.gson.OptimizedJsonInfo;
import proguard.optimize.gson.TypeTokenClassBuilder;
import proguard.optimize.info.ProgramMemberOptimizationInfoSetter;
import proguard.util.MultiValueMap;

public class GsonSerializationOptimizer
extends SimplifiedVisitor
implements MemberVisitor,
ClassVisitor,
ElementValueVisitor,
AttributeVisitor,
AnnotationVisitor {
    private static final boolean DEBUG = false;
    private static final Map<String, InlineSerializer> inlineSerializers = new HashMap<String, InlineSerializer>();
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final GsonRuntimeSettings gsonRuntimeSettings;
    private final CodeAttributeEditor codeAttributeEditor;
    private final OptimizedJsonInfo serializationInfo;
    private final boolean supportExposeAnnotation;
    private final MultiValueMap<String, String> injectedClassNameMap;
    private InstructionSequenceBuilder ____;

    public GsonSerializationOptimizer(ClassPool programClassPool, ClassPool libraryClassPool, GsonRuntimeSettings gsonRuntimeSettings, CodeAttributeEditor codeAttributeEditor, OptimizedJsonInfo serializationInfo, MultiValueMap<String, String> injectedClassNameMap) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.gsonRuntimeSettings = gsonRuntimeSettings;
        this.codeAttributeEditor = codeAttributeEditor;
        this.serializationInfo = serializationInfo;
        this.supportExposeAnnotation = gsonRuntimeSettings.excludeFieldsWithoutExposeAnnotation;
        this.injectedClassNameMap = injectedClassNameMap;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.u2accessFlags &= 0xFFFFFFFD;
        programClass.u2accessFlags |= 1;
        SimplifiedClassEditor classEditor = new SimplifiedClassEditor(programClass);
        this.____ = new InstructionSequenceBuilder(programClass, this.programClassPool, this.libraryClassPool);
        Integer classIndex = this.serializationInfo.classIndices.get(programClass.getName());
        String methodNameToJson = "toJson$" + classIndex;
        String methodNameToJsonBody = "toJsonBody$" + classIndex;
        ProgramMethod toJsonMethod = classEditor.addMethod(4097, methodNameToJson, OptimizedClassConstants.METHOD_TYPE_TO_JSON, this.____.return_().instructions());
        toJsonMethod.accept(programClass, (MemberVisitor)new ProgramMemberOptimizationInfoSetter());
        this.codeAttributeEditor.reset(1);
        this.____.aload(2).invokevirtual("com/google/gson/stream/JsonWriter", "beginObject", "()Lcom/google/gson/stream/JsonWriter;");
        this.____.aload(0).aload(1).aload(2).aload(3).invokevirtual(programClass.getName(), methodNameToJsonBody, OptimizedClassConstants.METHOD_TYPE_TO_JSON_BODY);
        this.____.aload(2).invokevirtual("com/google/gson/stream/JsonWriter", "endObject", "()Lcom/google/gson/stream/JsonWriter;").return_();
        this.codeAttributeEditor.replaceInstruction(0, this.____.instructions());
        toJsonMethod.attributesAccept(programClass, this.codeAttributeEditor);
        this.addToJsonBodyMethod(programClass, classEditor);
        programClass.accept(new MethodLinker());
        classEditor.finishEditing(this.programClassPool, this.libraryClassPool);
    }

    private void addToJsonBodyMethod(ProgramClass programClass, SimplifiedClassEditor classEditor) {
        Integer classIndex = this.serializationInfo.classIndices.get(programClass.getName());
        String methodName = "toJsonBody$" + classIndex;
        ProgramMethod toJsonBodyMethod = classEditor.addMethod(4100, methodName, OptimizedClassConstants.METHOD_TYPE_TO_JSON_BODY, this.____.return_().instructions());
        toJsonBodyMethod.accept(programClass, (MemberVisitor)new ProgramMemberOptimizationInfoSetter());
        toJsonBodyMethod.attributesAccept(programClass, new ToJsonCodeAttributeVisitor());
    }

    static {
        inlineSerializers.put("Z", new InlineSerializers.InlinePrimitiveBooleanSerializer());
        inlineSerializers.put("Ljava/lang/Boolean;", new InlineSerializers.InlineBooleanSerializer());
        inlineSerializers.put("B", new InlineSerializers.InlinePrimitiveIntegerSerializer());
        inlineSerializers.put("S", new InlineSerializers.InlinePrimitiveIntegerSerializer());
        inlineSerializers.put("I", new InlineSerializers.InlinePrimitiveIntegerSerializer());
        inlineSerializers.put("Ljava/lang/String;", new InlineSerializers.InlineStringSerializer());
    }

    private class ToJsonCodeAttributeVisitor
    extends SimplifiedVisitor
    implements AttributeVisitor,
    MemberVisitor {
        private int valueLocalIndex;

        private ToJsonCodeAttributeVisitor() {
        }

        @Override
        public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
            GsonSerializationOptimizer.this.codeAttributeEditor.reset(1);
            this.valueLocalIndex = codeAttribute.u2maxLocals;
            clazz.fieldsAccept(new MemberAccessFilter(0, 4104, this));
            if (!clazz.getSuperClass().getName().equals("java/lang/Object")) {
                Integer superClassIndex = ((GsonSerializationOptimizer)GsonSerializationOptimizer.this).serializationInfo.classIndices.get(clazz.getSuperClass().getName());
                String superMethodNameToJsonBody = "toJsonBody$" + superClassIndex;
                GsonSerializationOptimizer.this.____.aload(0).aload(1).aload(2).aload(3).invokevirtual(clazz.getSuperClass().getName(), superMethodNameToJsonBody, OptimizedClassConstants.METHOD_TYPE_TO_JSON_BODY);
            }
            GsonSerializationOptimizer.this.____.return_();
            GsonSerializationOptimizer.this.codeAttributeEditor.replaceInstruction(0, GsonSerializationOptimizer.this.____.instructions());
            GsonSerializationOptimizer.this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
        }

        @Override
        public void visitProgramField(ProgramClass programClass, ProgramField programField) {
            OptimizedJsonInfo.ClassJsonInfo classSerializationInfo = ((GsonSerializationOptimizer)GsonSerializationOptimizer.this).serializationInfo.classJsonInfos.get(programClass.getName());
            String[] jsonFieldNames = classSerializationInfo.javaToJsonFieldNames.get(programField.getName(programClass));
            String javaFieldName = programField.getName(programClass);
            if (jsonFieldNames != null) {
                String fieldDescriptor = programField.getDescriptor(programClass);
                FieldSignatureCollector signatureAttributeCollector = new FieldSignatureCollector();
                programField.attributesAccept(programClass, signatureAttributeCollector);
                boolean retrieveAdapterByTypeToken = false;
                CodeAttributeEditor.Label end = GsonSerializationOptimizer.this.codeAttributeEditor.label();
                if (ClassUtil.isInternalClassType(fieldDescriptor)) {
                    CodeAttributeEditor.Label noRecursion = GsonSerializationOptimizer.this.codeAttributeEditor.label();
                    GsonSerializationOptimizer.this.____.aload(0).aload(0).getfield(programClass, programField).ifacmpne(noRecursion.offset()).goto_(end.offset()).label(noRecursion);
                }
                if (GsonSerializationOptimizer.this.supportExposeAnnotation && !classSerializationInfo.exposedJavaFieldNames.contains(javaFieldName)) {
                    GsonSerializationOptimizer.this.____.aload(1).getfield("com/google/gson/Gson", "excluder", "Lcom/google/gson/internal/Excluder;").getfield("com/google/gson/internal/Excluder", "requireExpose", "Z").ifne(end.offset());
                }
                Integer fieldIndex = ((GsonSerializationOptimizer)GsonSerializationOptimizer.this).serializationInfo.jsonFieldIndices.get(jsonFieldNames[0]);
                GsonSerializationOptimizer.this.____.aload(3).aload(2).ldc(fieldIndex).invokeinterface(OptimizedClassConstants.NAME_OPTIMIZED_JSON_WRITER, "b", "(Lcom/google/gson/stream/JsonWriter;I)V");
                InlineSerializer inlineSerializer = (InlineSerializer)inlineSerializers.get(fieldDescriptor);
                if (inlineSerializer != null && inlineSerializer.canSerialize(GsonSerializationOptimizer.this.gsonRuntimeSettings)) {
                    inlineSerializer.serialize(programClass, programField, GsonSerializationOptimizer.this.codeAttributeEditor, GsonSerializationOptimizer.this.____, GsonSerializationOptimizer.this.gsonRuntimeSettings);
                } else {
                    GsonSerializationOptimizer.this.____.aload(1);
                    block0 : switch (fieldDescriptor.charAt(0)) {
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'F': 
                        case 'I': 
                        case 'J': 
                        case 'S': 
                        case 'Z': {
                            String className = ClassUtil.internalNumericClassNameFromPrimitiveType(fieldDescriptor.charAt(0));
                            GsonSerializationOptimizer.this.____.getstatic(className, "TYPE", "Ljava/lang/Class;");
                            break;
                        }
                        case 'L': {
                            if (signatureAttributeCollector.getFieldSignature() == null) {
                                String fieldClassName = fieldDescriptor.substring(1, fieldDescriptor.length() - 1);
                                Clazz fieldClass = GsonSerializationOptimizer.this.programClassPool.getClass(fieldClassName);
                                if (fieldClass == null) {
                                    fieldClass = GsonSerializationOptimizer.this.libraryClassPool.getClass(fieldClassName);
                                }
                                GsonSerializationOptimizer.this.____.ldc(fieldClass);
                                break;
                            }
                            ProgramClass typeTokenClass = new TypeTokenClassBuilder(programClass, programField, signatureAttributeCollector.getFieldSignature()).build(GsonSerializationOptimizer.this.programClassPool);
                            GsonSerializationOptimizer.this.programClassPool.addClass(typeTokenClass);
                            typeTokenClass.accept(new ClassReferenceInitializer(GsonSerializationOptimizer.this.programClassPool, GsonSerializationOptimizer.this.libraryClassPool));
                            GsonSerializationOptimizer.this.injectedClassNameMap.put(programClass.getName(), typeTokenClass.getName());
                            GsonSerializationOptimizer.this.____.new_(typeTokenClass.getName()).dup().invokespecial(typeTokenClass.getName(), "<init>", "()V");
                            retrieveAdapterByTypeToken = true;
                            break;
                        }
                        case '[': {
                            int fieldDescriptorIndex = 1;
                            while (fieldDescriptor.charAt(fieldDescriptorIndex) == '[') {
                                ++fieldDescriptorIndex;
                            }
                            switch (fieldDescriptor.charAt(fieldDescriptorIndex)) {
                                case 'B': 
                                case 'C': 
                                case 'D': 
                                case 'F': 
                                case 'I': 
                                case 'J': 
                                case 'S': 
                                case 'Z': {
                                    String className = ClassUtil.internalNumericClassNameFromPrimitiveType(fieldDescriptor.charAt(0));
                                    Clazz fieldClass = GsonSerializationOptimizer.this.libraryClassPool.getClass(className);
                                    GsonSerializationOptimizer.this.____.ldc(fieldDescriptor, fieldClass);
                                    break block0;
                                }
                                case 'L': {
                                    String fieldClassName = fieldDescriptor.substring(2, fieldDescriptor.length() - 1);
                                    Clazz fieldClass = GsonSerializationOptimizer.this.programClassPool.getClass(fieldClassName);
                                    if (fieldClass == null) {
                                        fieldClass = GsonSerializationOptimizer.this.libraryClassPool.getClass(fieldClassName);
                                    }
                                    GsonSerializationOptimizer.this.____.ldc(fieldDescriptor, fieldClass);
                                    break block0;
                                }
                            }
                            break;
                        }
                    }
                    GsonSerializationOptimizer.this.____.aload(0).getfield(programClass, programField);
                    switch (fieldDescriptor.charAt(0)) {
                        case 'Z': {
                            GsonSerializationOptimizer.this.____.invokestatic("java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                            break;
                        }
                        case 'C': {
                            GsonSerializationOptimizer.this.____.invokestatic("java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                            break;
                        }
                        case 'B': {
                            GsonSerializationOptimizer.this.____.invokestatic("java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                            break;
                        }
                        case 'S': {
                            GsonSerializationOptimizer.this.____.invokestatic("java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                            break;
                        }
                        case 'I': {
                            GsonSerializationOptimizer.this.____.invokestatic("java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                            break;
                        }
                        case 'F': {
                            GsonSerializationOptimizer.this.____.invokestatic("java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                            break;
                        }
                        case 'J': {
                            GsonSerializationOptimizer.this.____.invokestatic("java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                            break;
                        }
                        case 'D': {
                            GsonSerializationOptimizer.this.____.invokestatic("java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
                        }
                    }
                    GsonSerializationOptimizer.this.____.dup().astore(this.valueLocalIndex);
                    if (retrieveAdapterByTypeToken) {
                        GsonSerializationOptimizer.this.____.invokestatic(OptimizedClassConstants.NAME_GSON_UTIL, "getTypeAdapter", "(Lcom/google/gson/Gson;Lcom/google/gson/reflect/TypeToken;Ljava/lang/Object;)Lcom/google/gson/TypeAdapter;");
                    } else {
                        GsonSerializationOptimizer.this.____.invokestatic(OptimizedClassConstants.NAME_GSON_UTIL, "getTypeAdapter", "(Lcom/google/gson/Gson;Ljava/lang/Class;Ljava/lang/Object;)Lcom/google/gson/TypeAdapter;");
                    }
                    GsonSerializationOptimizer.this.____.aload(2).aload(this.valueLocalIndex).invokevirtual("com/google/gson/TypeAdapter", "write", "(Lcom/google/gson/stream/JsonWriter;Ljava/lang/Object;)V");
                }
                GsonSerializationOptimizer.this.____.label(end);
            }
        }
    }
}

