/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.optimize.gson.GsonRuntimeSettings;
import proguard.optimize.gson.InlineDeserializer;

public class InlineDeserializers {

    public static class InlineStringDeserializer
    implements InlineDeserializer {
        @Override
        public boolean canDeserialize(GsonRuntimeSettings gsonRuntimeSettings) {
            return true;
        }

        @Override
        public void deserialize(ProgramClass programClass, ProgramField programField, CodeAttributeEditor codeAttributeEditor, InstructionSequenceBuilder ____, GsonRuntimeSettings gsonRuntimeSettings) {
            CodeAttributeEditor.Label isBoolean = codeAttributeEditor.label();
            CodeAttributeEditor.Label end = codeAttributeEditor.label();
            ____.aload(2).invokevirtual("com/google/gson/stream/JsonReader", "peek", "()Lcom/google/gson/stream/JsonToken;").getstatic("com/google/gson/stream/JsonToken", "BOOLEAN", "Lcom/google/gson/stream/JsonToken;").ifacmpeq(isBoolean.offset());
            ____.aload(0).aload(2).invokevirtual("com/google/gson/stream/JsonReader", "nextString", "()Ljava/lang/String;").putfield(programClass, programField).goto_(end.offset());
            ____.label(isBoolean).aload(0).aload(2).invokevirtual("com/google/gson/stream/JsonReader", "nextBoolean", "()Z").invokestatic("java/lang/Boolean", "toString", "(Z)Ljava/lang/String;").putfield(programClass, programField).label(end);
        }
    }

    public static class InlinePrimitiveIntegerDeserializer
    implements InlineDeserializer {
        private final Class targetType;

        public InlinePrimitiveIntegerDeserializer() {
            this(null);
        }

        public InlinePrimitiveIntegerDeserializer(Class targetType) {
            this.targetType = targetType;
        }

        @Override
        public boolean canDeserialize(GsonRuntimeSettings gsonRuntimeSettings) {
            return true;
        }

        @Override
        public void deserialize(ProgramClass programClass, ProgramField programField, CodeAttributeEditor codeAttributeEditor, InstructionSequenceBuilder ____, GsonRuntimeSettings gsonRuntimeSettings) {
            ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor(programClass);
            int exceptionClassConstant = constantPoolEditor.addClassConstant("java/lang/NumberFormatException", null);
            CodeAttributeEditor.Label tryStart = codeAttributeEditor.label();
            CodeAttributeEditor.Label tryEnd = codeAttributeEditor.label();
            CodeAttributeEditor.Label catchStart = codeAttributeEditor.catch_(tryStart.offset(), tryEnd.offset(), exceptionClassConstant);
            CodeAttributeEditor.Label catchEnd = codeAttributeEditor.label();
            ____.label(tryStart).aload(0).aload(2).invokevirtual("com/google/gson/stream/JsonReader", "nextInt", "()I");
            if (this.targetType == Byte.TYPE) {
                ____.i2b();
            } else if (this.targetType == Short.TYPE) {
                ____.i2s();
            }
            ____.putfield(programClass, programField).goto_(catchEnd.offset()).label(tryEnd);
            int throwableLocal = 4;
            ____.label(catchStart).astore(throwableLocal).new_("com/google/gson/JsonSyntaxException").dup().aload(throwableLocal).invokespecial("com/google/gson/JsonSyntaxException", "<init>", "(Ljava/lang/Throwable;)V").athrow().label(catchEnd);
        }
    }
}

