/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.gson;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.editor.InstructionSequenceBuilder;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.gson.OptimizedClassConstants;
import proguard.optimize.gson.OptimizedJsonInfo;

public class OptimizedTypeAdapterInitializer
extends SimplifiedVisitor
implements ClassVisitor {
    private final String typeAdapterClassName;
    private final String objectClassName;
    private final ProgramClass objectProgramClass;
    private final CodeAttributeEditor codeAttributeEditor;
    private final OptimizedJsonInfo serializationIndexMap;
    private final OptimizedJsonInfo deserializationIndexMap;
    private final ClassPool instanceCreatorClasses;
    private final ClassVisitor classVisitor;

    public OptimizedTypeAdapterInitializer(String typeAdapterClassName, ProgramClass objectProgramClass, CodeAttributeEditor codeAttributeEditor, OptimizedJsonInfo serializationInfo, OptimizedJsonInfo deserializationInfo, ClassPool instanceCreatorClasses, ClassVisitor classVisitor) {
        this.typeAdapterClassName = typeAdapterClassName;
        this.objectClassName = ClassUtil.internalClassName(objectProgramClass.getName());
        this.objectProgramClass = objectProgramClass;
        this.codeAttributeEditor = codeAttributeEditor;
        this.serializationIndexMap = serializationInfo;
        this.deserializationIndexMap = deserializationInfo;
        this.instanceCreatorClasses = instanceCreatorClasses;
        this.classVisitor = classVisitor;
    }

    @Override
    public void visitAnyClass(Clazz clazz) {
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        SimplifiedVisitor writeImplementer;
        boolean isEnumAdapter;
        programClass.thisClassConstantAccept(new TypeAdapterRenamer());
        programClass.methodsAccept(new AllAttributeVisitor(new AllAttributeVisitor(new LocalVariableTypeRenamer())));
        boolean bl = isEnumAdapter = (this.objectProgramClass.getAccessFlags() & 0x4000) != 0;
        if (isEnumAdapter) {
            this.objectProgramClass.u2accessFlags &= 0xFFFFFFFD;
            this.objectProgramClass.u2accessFlags |= 1;
        }
        SimplifiedVisitor readImplementer = isEnumAdapter ? new EnumReadImplementer() : new ReadImplementer();
        SimplifiedVisitor simplifiedVisitor = writeImplementer = isEnumAdapter ? new EnumWriteImplementer() : new WriteImplementer();
        if (this.deserializationIndexMap.classIndices.get(this.objectClassName) != null) {
            programClass.methodsAccept(new MemberNameFilter("read", (MemberVisitor)new AllAttributeVisitor((AttributeVisitor)((Object)readImplementer))));
        }
        if (this.serializationIndexMap.classIndices.get(this.objectClassName) != null) {
            programClass.methodsAccept(new MemberNameFilter("write", (MemberVisitor)new AllAttributeVisitor((AttributeVisitor)((Object)writeImplementer))));
        }
        this.classVisitor.visitProgramClass(programClass);
    }

    private class WriteImplementer
    extends SimplifiedVisitor
    implements AttributeVisitor {
        private WriteImplementer() {
        }

        @Override
        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        @Override
        public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
            OptimizedTypeAdapterInitializer.this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
            InstructionSequenceBuilder ____ = new InstructionSequenceBuilder((ProgramClass)clazz);
            Integer classIndex = ((OptimizedTypeAdapterInitializer)OptimizedTypeAdapterInitializer.this).serializationIndexMap.classIndices.get(OptimizedTypeAdapterInitializer.this.objectClassName);
            String methodNameToJson = "toJson$" + classIndex;
            CodeAttributeEditor.Label nonNull = OptimizedTypeAdapterInitializer.this.codeAttributeEditor.label();
            CodeAttributeEditor.Label end = OptimizedTypeAdapterInitializer.this.codeAttributeEditor.label();
            ____.aload(2).ifnonnull(nonNull.offset());
            ____.aload(1).invokevirtual("com/google/gson/stream/JsonWriter", "nullValue", "()Lcom/google/gson/stream/JsonWriter;").pop().goto_(end.offset());
            ____.label(nonNull).aload(2).checkcast(OptimizedTypeAdapterInitializer.this.objectClassName).aload(0).getfield(OptimizedTypeAdapterInitializer.this.typeAdapterClassName, "gson", "Lcom/google/gson/Gson;").aload(1).aload(0).getfield(OptimizedTypeAdapterInitializer.this.typeAdapterClassName, "optimizedJsonWriter", OptimizedClassConstants.FIELD_TYPE_OPTIMIZED_JSON_WRITER).invokevirtual(OptimizedTypeAdapterInitializer.this.objectClassName, methodNameToJson, OptimizedClassConstants.METHOD_TYPE_TO_JSON).label(end).return_();
            OptimizedTypeAdapterInitializer.this.codeAttributeEditor.replaceInstruction(0, ____.instructions());
            OptimizedTypeAdapterInitializer.this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }

    private class EnumWriteImplementer
    extends SimplifiedVisitor
    implements AttributeVisitor {
        private EnumWriteImplementer() {
        }

        @Override
        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        @Override
        public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
            OptimizedTypeAdapterInitializer.this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
            InstructionSequenceBuilder ____ = new InstructionSequenceBuilder((ProgramClass)clazz);
            CodeAttributeEditor.Label nonNull = OptimizedTypeAdapterInitializer.this.codeAttributeEditor.label();
            CodeAttributeEditor.Label end = OptimizedTypeAdapterInitializer.this.codeAttributeEditor.label();
            CodeAttributeEditor.Label writeValue = OptimizedTypeAdapterInitializer.this.codeAttributeEditor.label();
            ____.aload(2).ifnonnull(nonNull.offset());
            ____.aload(1).invokevirtual("com/google/gson/stream/JsonWriter", "nullValue", "()Lcom/google/gson/stream/JsonWriter;").pop().goto_(end.offset());
            Map<String, String[]> javaToJsonValueNames = ((OptimizedTypeAdapterInitializer)OptimizedTypeAdapterInitializer.this).serializationIndexMap.classJsonInfos.get((Object)((OptimizedTypeAdapterInitializer)OptimizedTypeAdapterInitializer.this).objectClassName).javaToJsonFieldNames;
            Map<String, Integer> jsonFieldIndices = ((OptimizedTypeAdapterInitializer)OptimizedTypeAdapterInitializer.this).serializationIndexMap.jsonFieldIndices;
            ____.label(nonNull).aload(0).getfield(OptimizedTypeAdapterInitializer.this.typeAdapterClassName, "optimizedJsonWriter", OptimizedClassConstants.FIELD_TYPE_OPTIMIZED_JSON_WRITER).aload(1).aload(2);
            for (String javaValueName : javaToJsonValueNames.keySet()) {
                CodeAttributeEditor.Label label = OptimizedTypeAdapterInitializer.this.codeAttributeEditor.label();
                String jsonValueName = javaToJsonValueNames.get(javaValueName)[0];
                ____.dup().getstatic(OptimizedTypeAdapterInitializer.this.objectClassName, javaValueName, ClassUtil.internalTypeFromClassName(OptimizedTypeAdapterInitializer.this.objectClassName)).ifacmpne(label.offset()).pop().ldc(jsonFieldIndices.get(jsonValueName)).goto_(writeValue.offset()).label(label);
            }
            ____.pop().iconst_m1();
            ____.label(writeValue).invokevirtual(OptimizedClassConstants.NAME_OPTIMIZED_JSON_WRITER, "c", "(Lcom/google/gson/stream/JsonWriter;I)V").label(end).return_();
            OptimizedTypeAdapterInitializer.this.codeAttributeEditor.replaceInstruction(0, ____.instructions());
            OptimizedTypeAdapterInitializer.this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }

    private class ReadImplementer
    extends SimplifiedVisitor
    implements AttributeVisitor {
        private ReadImplementer() {
        }

        @Override
        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        @Override
        public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
            OptimizedTypeAdapterInitializer.this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
            InstructionSequenceBuilder ____ = new InstructionSequenceBuilder((ProgramClass)clazz);
            Integer classIndex = ((OptimizedTypeAdapterInitializer)OptimizedTypeAdapterInitializer.this).deserializationIndexMap.classIndices.get(OptimizedTypeAdapterInitializer.this.objectClassName);
            String methodNameFromJson = "fromJson$" + classIndex;
            CodeAttributeEditor.Label nonNull = OptimizedTypeAdapterInitializer.this.codeAttributeEditor.label();
            ____.aload(1).invokevirtual("com/google/gson/stream/JsonReader", "peek", "()Lcom/google/gson/stream/JsonToken;");
            ____.getstatic("com/google/gson/stream/JsonToken", "NULL", "Lcom/google/gson/stream/JsonToken;").ifacmpne(nonNull.offset());
            ____.aload(1).invokevirtual("com/google/gson/stream/JsonReader", "skipValue", "()V");
            ____.aconst_null().areturn();
            ____.label(nonNull);
            if (OptimizedTypeAdapterInitializer.this.instanceCreatorClasses.getClass(OptimizedTypeAdapterInitializer.this.objectClassName) == null) {
                ____.new_(OptimizedTypeAdapterInitializer.this.objectClassName).dup().invokespecial(OptimizedTypeAdapterInitializer.this.objectClassName, "<init>", "()V").astore(2);
            } else {
                ____.aload(0).getfield(OptimizedTypeAdapterInitializer.this.typeAdapterClassName, "gson", "Lcom/google/gson/Gson;").getfield("com/google/gson/Gson", "instanceCreators", "Ljava/util/Map;").ldc(OptimizedTypeAdapterInitializer.this.instanceCreatorClasses.getClass(OptimizedTypeAdapterInitializer.this.objectClassName)).invokevirtual("java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;").checkcast("com/google/gson/InstanceCreator").ldc(OptimizedTypeAdapterInitializer.this.instanceCreatorClasses.getClass(OptimizedTypeAdapterInitializer.this.objectClassName)).invokevirtual("com/google/gson/InstanceCreator", "createInstance", "(Ljava/lang/reflect/Type;)Ljava/lang/Object;").checkcast(OptimizedTypeAdapterInitializer.this.objectClassName).astore(2);
            }
            ____.aload(2).aload(0).getfield(OptimizedTypeAdapterInitializer.this.typeAdapterClassName, "gson", "Lcom/google/gson/Gson;").aload(1).aload(0).getfield(OptimizedTypeAdapterInitializer.this.typeAdapterClassName, "optimizedJsonReader", OptimizedClassConstants.FIELD_TYPE_OPTIMIZED_JSON_READER).invokevirtual(OptimizedTypeAdapterInitializer.this.objectClassName, methodNameFromJson, OptimizedClassConstants.METHOD_TYPE_FROM_JSON);
            ____.aload(2).areturn();
            OptimizedTypeAdapterInitializer.this.codeAttributeEditor.replaceInstruction(0, ____.instructions());
            OptimizedTypeAdapterInitializer.this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }

    private static class SwitchCase
    implements Comparable<SwitchCase> {
        private String enumConstant;
        private CodeAttributeEditor.Label label;
        private int stringIndex;

        public SwitchCase(String enumConstant, CodeAttributeEditor.Label label, int stringIndex) {
            this.enumConstant = enumConstant;
            this.label = label;
            this.stringIndex = stringIndex;
        }

        @Override
        public int compareTo(SwitchCase switchCase) {
            return this.stringIndex - switchCase.stringIndex;
        }
    }

    private class EnumReadImplementer
    extends SimplifiedVisitor
    implements AttributeVisitor {
        private EnumReadImplementer() {
        }

        @Override
        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        @Override
        public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
            OptimizedTypeAdapterInitializer.this.codeAttributeEditor.reset(codeAttribute.u4codeLength);
            InstructionSequenceBuilder ____ = new InstructionSequenceBuilder((ProgramClass)clazz);
            Map<String, String[]> javaToJsonValueNames = ((OptimizedTypeAdapterInitializer)OptimizedTypeAdapterInitializer.this).deserializationIndexMap.classJsonInfos.get((Object)((OptimizedTypeAdapterInitializer)OptimizedTypeAdapterInitializer.this).objectClassName).javaToJsonFieldNames;
            Map<String, Integer> jsonFieldIndices = ((OptimizedTypeAdapterInitializer)OptimizedTypeAdapterInitializer.this).deserializationIndexMap.jsonFieldIndices;
            ArrayList<SwitchCase> switchCases = new ArrayList<SwitchCase>();
            for (String javaValueName : javaToJsonValueNames.keySet()) {
                for (String jsonValueName : javaToJsonValueNames.get(javaValueName)) {
                    switchCases.add(new SwitchCase(javaValueName, OptimizedTypeAdapterInitializer.this.codeAttributeEditor.label(), jsonFieldIndices.get(jsonValueName)));
                }
            }
            Collections.sort(switchCases);
            int[] cases = new int[switchCases.size()];
            int[] jumpOffsets = new int[switchCases.size()];
            for (int index = 0; index < switchCases.size(); ++index) {
                cases[index] = ((SwitchCase)switchCases.get(index)).stringIndex;
                jumpOffsets[index] = ((SwitchCase)switchCases.get(index)).label.offset();
            }
            CodeAttributeEditor.Label defaultCase = OptimizedTypeAdapterInitializer.this.codeAttributeEditor.label();
            ____.aload(0).getfield(OptimizedTypeAdapterInitializer.this.typeAdapterClassName, "optimizedJsonReader", OptimizedClassConstants.FIELD_TYPE_OPTIMIZED_JSON_READER).aload(1).invokevirtual(OptimizedClassConstants.NAME_OPTIMIZED_JSON_READER, "c", "(Lcom/google/gson/stream/JsonReader;)I");
            ____.lookupswitch(defaultCase.offset(), cases, jumpOffsets);
            for (int index = 0; index < switchCases.size(); ++index) {
                ____.label(((SwitchCase)switchCases.get(index)).label).getstatic(OptimizedTypeAdapterInitializer.this.objectClassName, ((SwitchCase)switchCases.get(index)).enumConstant, ClassUtil.internalTypeFromClassName(OptimizedTypeAdapterInitializer.this.objectClassName)).areturn();
            }
            ____.label(defaultCase).aconst_null().areturn();
            OptimizedTypeAdapterInitializer.this.codeAttributeEditor.replaceInstruction(0, ____.instructions());
            OptimizedTypeAdapterInitializer.this.codeAttributeEditor.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }

    private class LocalVariableTypeRenamer
    extends SimplifiedVisitor
    implements AttributeVisitor,
    LocalVariableInfoVisitor {
        private LocalVariableTypeRenamer() {
        }

        @Override
        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        @Override
        public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
            localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
        }

        @Override
        public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
            String descriptor = localVariableInfo.getDescriptor(clazz);
            if (descriptor.equals(OptimizedClassConstants.TYPE_OPTIMIZED_TYPE_ADAPTER_IMPL)) {
                localVariableInfo.u2descriptorIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(ClassUtil.internalTypeFromClassName(OptimizedTypeAdapterInitializer.this.typeAdapterClassName));
            }
        }
    }

    private class TypeAdapterRenamer
    extends SimplifiedVisitor
    implements ConstantVisitor {
        private TypeAdapterRenamer() {
        }

        @Override
        public void visitAnyConstant(Clazz clazz, Constant constant) {
        }

        @Override
        public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
            classConstant.u2nameIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(OptimizedTypeAdapterInitializer.this.typeAdapterClassName);
        }
    }
}

