/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.BootstrapMethodInfo;
import proguard.classfile.attribute.BootstrapMethodsAttribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.NestMembersAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.editor.BootstrapMethodRemapper;
import proguard.classfile.editor.ConstantPoolRemapper;
import proguard.classfile.editor.InterfaceDeleter;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.shrink.UsageMarker;

public class ClassShrinker
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
AttributeVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private final UsageMarker usageMarker;
    private int[] constantIndexMap = new int[256];
    private int[] bootstrapMethodIndexMap = new int[256];
    private final ConstantPoolRemapper constantPoolRemapper = new ConstantPoolRemapper();
    private final BootstrapMethodRemapper bootstrapMethodRemapper = new BootstrapMethodRemapper();

    public ClassShrinker(UsageMarker usageMarker) {
        this.usageMarker = usageMarker;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        if (programClass.u2interfacesCount > 0) {
            new InterfaceDeleter(this.shrinkFlags(programClass.constantPool, programClass.u2interfaces, programClass.u2interfacesCount)).visitProgramClass(programClass);
        }
        int newConstantPoolCount = this.shrinkConstantPool(programClass.constantPool, programClass.u2constantPoolCount);
        int oldFieldsCount = programClass.u2fieldsCount;
        programClass.u2fieldsCount = this.shrinkArray(programClass.fields, programClass.u2fieldsCount);
        if (programClass.u2fieldsCount < oldFieldsCount) {
            programClass.u2accessFlags |= 0x40000;
        }
        int oldMethodsCount = programClass.u2methodsCount;
        programClass.u2methodsCount = this.shrinkArray(programClass.methods, programClass.u2methodsCount);
        if (programClass.u2methodsCount < oldMethodsCount) {
            programClass.u2accessFlags |= 0x20000;
        }
        programClass.u2attributesCount = this.shrinkArray(programClass.attributes, programClass.u2attributesCount);
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.attributesAccept(this);
        if (newConstantPoolCount < programClass.u2constantPoolCount) {
            programClass.u2constantPoolCount = newConstantPoolCount;
            this.constantPoolRemapper.setConstantIndexMap(this.constantIndexMap);
            this.constantPoolRemapper.visitProgramClass(programClass);
        }
        MySignatureCleaner signatureCleaner = new MySignatureCleaner();
        programClass.fieldsAccept(new AllAttributeVisitor(signatureCleaner));
        programClass.methodsAccept(new AllAttributeVisitor(signatureCleaner));
        programClass.attributesAccept(signatureCleaner);
        programClass.subClasses = this.shrinkToNewArray(programClass.subClasses);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        libraryClass.subClasses = this.shrinkToNewArray(libraryClass.subClasses);
    }

    @Override
    public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
        programMember.u2attributesCount = this.shrinkArray(programMember.attributes, programMember.u2attributesCount);
        programMember.attributesAccept(programClass, this);
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitBootstrapMethodsAttribute(Clazz clazz, BootstrapMethodsAttribute bootstrapMethodsAttribute) {
        int newBootstrapMethodsCount = this.shrinkBootstrapMethodArray(bootstrapMethodsAttribute.bootstrapMethods, bootstrapMethodsAttribute.u2bootstrapMethodsCount);
        if (newBootstrapMethodsCount < bootstrapMethodsAttribute.u2bootstrapMethodsCount) {
            bootstrapMethodsAttribute.u2bootstrapMethodsCount = newBootstrapMethodsCount;
            this.bootstrapMethodRemapper.setBootstrapMethodIndexMap(this.bootstrapMethodIndexMap);
            clazz.constantPoolEntriesAccept(this.bootstrapMethodRemapper);
        }
    }

    @Override
    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        innerClassesAttribute.u2classesCount = this.shrinkArray(innerClassesAttribute.classes, innerClassesAttribute.u2classesCount);
    }

    @Override
    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        if (enclosingMethodAttribute.referencedMethod != null && !this.usageMarker.isUsed(enclosingMethodAttribute.referencedMethod)) {
            enclosingMethodAttribute.u2nameAndTypeIndex = 0;
            enclosingMethodAttribute.referencedMethod = null;
        }
    }

    @Override
    public void visitNestMembersAttribute(Clazz clazz, NestMembersAttribute nestMembersAttribute) {
        nestMembersAttribute.u2classesCount = this.shrinkConstantIndexArray(((ProgramClass)clazz).constantPool, nestMembersAttribute.u2classes, nestMembersAttribute.u2classesCount);
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.u2attributesCount = this.shrinkArray(codeAttribute.attributes, codeAttribute.u2attributesCount);
        codeAttribute.attributesAccept(clazz, method, this);
    }

    @Override
    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.u2localVariableTableLength = this.shrinkArray(localVariableTableAttribute.localVariableTable, localVariableTableAttribute.u2localVariableTableLength);
    }

    @Override
    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.u2localVariableTypeTableLength = this.shrinkArray(localVariableTypeTableAttribute.localVariableTypeTable, localVariableTypeTableAttribute.u2localVariableTypeTableLength);
    }

    @Override
    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        annotationsAttribute.u2annotationsCount = this.shrinkArray(annotationsAttribute.annotations, annotationsAttribute.u2annotationsCount);
        annotationsAttribute.annotationsAccept(clazz, this);
    }

    @Override
    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        for (int parameterIndex = 0; parameterIndex < parameterAnnotationsAttribute.u1parametersCount; ++parameterIndex) {
            parameterAnnotationsAttribute.u2parameterAnnotationsCount[parameterIndex] = this.shrinkArray(parameterAnnotationsAttribute.parameterAnnotations[parameterIndex], parameterAnnotationsAttribute.u2parameterAnnotationsCount[parameterIndex]);
        }
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
    }

    @Override
    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        annotation.u2elementValuesCount = this.shrinkArray(annotation.elementValues, annotation.u2elementValuesCount);
        annotation.elementValuesAccept(clazz, this);
    }

    @Override
    public void visitAnyElementValue(Clazz clazz, Annotation annotation, ElementValue elementValue) {
    }

    @Override
    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        annotationElementValue.annotationAccept(clazz, this);
    }

    @Override
    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        arrayElementValue.u2elementValuesCount = this.shrinkArray(arrayElementValue.elementValues, arrayElementValue.u2elementValuesCount);
        arrayElementValue.elementValuesAccept(clazz, annotation, this);
    }

    private int shrinkConstantPool(Constant[] constantPool, int length) {
        if (this.constantIndexMap.length < length) {
            this.constantIndexMap = new int[length];
        }
        int counter = 1;
        boolean isUsed = false;
        for (int index = 1; index < length; ++index) {
            this.constantIndexMap[index] = counter;
            Constant constant = constantPool[index];
            if (constant != null) {
                isUsed = this.usageMarker.isUsed(constant);
            }
            if (isUsed) {
                this.constantIndexMap[index] = counter;
                constantPool[counter++] = constant;
                continue;
            }
            this.constantIndexMap[index] = -1;
        }
        Arrays.fill(constantPool, counter, length, null);
        return counter;
    }

    private boolean[] shrinkFlags(Constant[] constantPool, int[] array, int length) {
        boolean[] unused = new boolean[length];
        for (int index = 0; index < length; ++index) {
            if (this.usageMarker.isUsed(constantPool[array[index]])) continue;
            unused[index] = true;
        }
        return unused;
    }

    private int shrinkConstantIndexArray(Constant[] constantPool, int[] array, int length) {
        int counter = 0;
        for (int index = 0; index < length; ++index) {
            if (!this.usageMarker.isUsed(constantPool[array[index]])) continue;
            array[counter++] = array[index];
        }
        Arrays.fill(array, counter, length, 0);
        return counter;
    }

    private Clazz[] shrinkToNewArray(Clazz[] array) {
        if (array == null) {
            return null;
        }
        int length = this.shrinkArray(array, array.length);
        if (length == 0) {
            return null;
        }
        if (length == array.length) {
            return array;
        }
        Clazz[] newArray = new Clazz[length];
        System.arraycopy(array, 0, newArray, 0, length);
        return newArray;
    }

    private int shrinkBootstrapMethodArray(BootstrapMethodInfo[] bootstrapMethods, int length) {
        if (this.bootstrapMethodIndexMap.length < length) {
            this.bootstrapMethodIndexMap = new int[length];
        }
        int counter = 0;
        for (int index = 0; index < length; ++index) {
            BootstrapMethodInfo bootstrapMethod = bootstrapMethods[index];
            if (this.usageMarker.isUsed(bootstrapMethod)) {
                this.bootstrapMethodIndexMap[index] = counter;
                bootstrapMethods[counter++] = bootstrapMethod;
                continue;
            }
            this.bootstrapMethodIndexMap[index] = -1;
        }
        Arrays.fill(bootstrapMethods, counter, length, null);
        return counter;
    }

    private int shrinkArray(VisitorAccepter[] array, int length) {
        int counter = 0;
        for (int index = 0; index < length; ++index) {
            VisitorAccepter visitorAccepter = array[index];
            if (!this.usageMarker.isUsed(visitorAccepter)) continue;
            array[counter++] = visitorAccepter;
        }
        if (counter < length) {
            Arrays.fill(array, counter, length, null);
        }
        return counter;
    }

    private class MySignatureCleaner
    extends SimplifiedVisitor
    implements AttributeVisitor {
        private MySignatureCleaner() {
        }

        @Override
        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        @Override
        public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
            Clazz[] referencedClasses = signatureAttribute.referencedClasses;
            if (referencedClasses != null) {
                String signature = signatureAttribute.getSignature(clazz);
                DescriptorClassEnumeration classEnumeration = new DescriptorClassEnumeration(signature);
                int referencedClassIndex = 0;
                StringBuffer newSignatureBuffer = new StringBuffer();
                newSignatureBuffer.append(classEnumeration.nextFluff());
                while (classEnumeration.hasMoreClassNames()) {
                    String className = classEnumeration.nextClassName();
                    Clazz referencedClass = referencedClasses[referencedClassIndex];
                    if (referencedClass != null && !ClassShrinker.this.usageMarker.isUsed(referencedClass)) {
                        className = "java/lang/Object";
                        referencedClasses[referencedClassIndex] = null;
                    } else if (classEnumeration.isInnerClassName()) {
                        className = className.substring(className.lastIndexOf(36) + 1);
                    }
                    ++referencedClassIndex;
                    newSignatureBuffer.append(className);
                    newSignatureBuffer.append(classEnumeration.nextFluff());
                }
                ((Utf8Constant)((ProgramClass)clazz).constantPool[signatureAttribute.u2signatureIndex]).setString(newSignatureBuffer.toString());
            }
        }
    }
}

