/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.util.List;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.classfile.ClassConstants;
import proguard.classfile.ClassPool;
import proguard.io.CascadingDataEntryWriter;
import proguard.io.ClassDataEntryWriter;
import proguard.io.DataEntryNameFilter;
import proguard.io.DataEntryParentFilter;
import proguard.io.DataEntryWriter;
import proguard.io.DirectoryWriter;
import proguard.io.ExtraDataEntryWriter;
import proguard.io.FilteredDataEntryWriter;
import proguard.io.JarWriter;
import proguard.io.ParentDataEntryWriter;
import proguard.io.PrefixAddingDataEntryWriter;
import proguard.util.ExtensionMatcher;
import proguard.util.FileNameParser;
import proguard.util.ListParser;
import proguard.util.MultiValueMap;

public class DataEntryWriterFactory {
    private final ClassPool programClassPool;
    private final MultiValueMap extraClassNameMap;

    public DataEntryWriterFactory(ClassPool programClassPool, MultiValueMap<String, String> extraClassNamemap) {
        this.programClassPool = programClassPool;
        this.extraClassNameMap = extraClassNamemap;
    }

    public DataEntryWriter createDataEntryWriter(ClassPath classPath, int fromIndex, int toIndex) {
        DataEntryWriter writer = null;
        for (int index = toIndex - 1; index >= fromIndex; --index) {
            ClassPathEntry entry = classPath.get(index);
            writer = this.createClassPathEntryWriter(entry, writer);
        }
        return writer;
    }

    private DataEntryWriter createClassPathEntryWriter(ClassPathEntry classPathEntry, DataEntryWriter alternativeWriter) {
        boolean isApk = classPathEntry.isApk();
        boolean isJar = classPathEntry.isJar();
        boolean isAar = classPathEntry.isAar();
        boolean isWar = classPathEntry.isWar();
        boolean isEar = classPathEntry.isEar();
        boolean isJmod = classPathEntry.isJmod();
        boolean isZip = classPathEntry.isZip();
        List filter = classPathEntry.getFilter();
        List apkFilter = classPathEntry.getApkFilter();
        List jarFilter = classPathEntry.getJarFilter();
        List aarFilter = classPathEntry.getAarFilter();
        List warFilter = classPathEntry.getWarFilter();
        List earFilter = classPathEntry.getEarFilter();
        List jmodFilter = classPathEntry.getJmodFilter();
        List zipFilter = classPathEntry.getZipFilter();
        System.out.println("Preparing output " + (isApk ? "apk" : (isJar ? "jar" : (isAar ? "aar" : (isWar ? "war" : (isEar ? "ear" : (isJmod ? "jmod" : (isZip ? "zip" : "directory"))))))) + " [" + classPathEntry.getName() + "]" + (filter != null || apkFilter != null || jarFilter != null || aarFilter != null || warFilter != null || earFilter != null || jmodFilter != null || zipFilter != null ? " (filtered)" : ""));
        DataEntryWriter writer = new DirectoryWriter(classPathEntry.getFile(), isApk || isJar || isAar || isWar || isEar || isJmod || isZip);
        boolean flattenApks = false;
        boolean flattenJars = flattenApks || isApk;
        boolean flattenAars = flattenJars || isJar;
        boolean flattenWars = flattenAars || isAar;
        boolean flattenEars = flattenWars || isWar;
        boolean flattenJmods = flattenEars || isEar;
        boolean flattenZips = flattenJmods || isJmod;
        writer = this.wrapInJarWriter(writer, flattenZips, isZip, ".zip", zipFilter, null, null);
        writer = this.wrapInJarWriter(writer, flattenJmods, isJmod, ".jmod", jmodFilter, ClassConstants.JMOD_HEADER, "classes/");
        writer = this.wrapInJarWriter(writer, flattenEars, isEar, ".ear", earFilter, null, null);
        writer = this.wrapInJarWriter(writer, flattenWars, isWar, ".war", warFilter, null, "classes/");
        writer = this.wrapInJarWriter(writer, flattenAars, isAar, ".aar", aarFilter, null, null);
        writer = this.wrapInJarWriter(writer, flattenJars, isJar, ".jar", jarFilter, null, null);
        writer = this.wrapInJarWriter(writer, flattenApks, isApk, ".apk", apkFilter, null, null);
        writer = new ClassDataEntryWriter(this.programClassPool, writer);
        writer = filter != null ? new FilteredDataEntryWriter(new DataEntryNameFilter(new ListParser(new FileNameParser()).parse(filter)), writer) : writer;
        writer = new ExtraDataEntryWriter(this.extraClassNameMap, writer, writer, ".class");
        return alternativeWriter != null ? new CascadingDataEntryWriter(writer, alternativeWriter) : writer;
    }

    private DataEntryWriter wrapInJarWriter(DataEntryWriter writer, boolean flatten, boolean isOutputJar, String jarFilterExtension, List jarFilter, byte[] jarHeader, String classFilePrefix) {
        DataEntryWriter jarWriter;
        if (flatten) {
            jarWriter = new ParentDataEntryWriter(writer);
        } else {
            jarWriter = new JarWriter(jarHeader, writer);
            if (classFilePrefix != null) {
                jarWriter = new FilteredDataEntryWriter(new DataEntryNameFilter(new ExtensionMatcher(".class")), new PrefixAddingDataEntryWriter(classFilePrefix, jarWriter), jarWriter);
            }
        }
        return new FilteredDataEntryWriter(new DataEntryParentFilter(new DataEntryNameFilter(new ExtensionMatcher(jarFilterExtension))), jarFilter != null ? new FilteredDataEntryWriter(new DataEntryParentFilter(new DataEntryNameFilter(new ListParser(new FileNameParser()).parse(jarFilter))), jarWriter) : jarWriter, isOutputJar ? jarWriter : writer);
    }
}

