/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.Configuration;
import proguard.DataEntryWriterFactory;
import proguard.InputReader;
import proguard.classfile.ClassPool;
import proguard.classfile.util.ClassUtil;
import proguard.io.ClassFilter;
import proguard.io.ClassMapDataEntryWriter;
import proguard.io.DataEntryCopier;
import proguard.io.DataEntryReader;
import proguard.io.DataEntryRewriter;
import proguard.io.DataEntryWriter;
import proguard.io.DirectoryFilter;
import proguard.io.ExtraDataEntryWriter;
import proguard.io.FilteredDataEntryReader;
import proguard.io.IdleRewriter;
import proguard.io.KotlinModuleRewriter;
import proguard.io.ManifestRewriter;
import proguard.io.NameFilter;
import proguard.io.NameFilteredDataEntryWriter;
import proguard.io.RenamedDataEntryReader;
import proguard.io.RenamedDataEntryWriter;
import proguard.util.MultiValueMap;

public class OutputWriter {
    private final Configuration configuration;

    public OutputWriter(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool programClassPool, MultiValueMap<String, String> injectedClassNameMap) throws IOException {
        ClassPath programJars = this.configuration.programJars;
        DataEntryWriterFactory dataEntryWriterFactory = new DataEntryWriterFactory(programClassPool, injectedClassNameMap);
        int firstInputIndex = 0;
        int lastInputIndex = 0;
        for (int index = 0; index < programJars.size(); ++index) {
            ClassPathEntry entry = programJars.get(index);
            if (!entry.isOutput()) {
                lastInputIndex = index;
                continue;
            }
            int nextIndex = index + 1;
            if (nextIndex != programJars.size() && programJars.get(nextIndex).isOutput()) continue;
            this.writeOutput(dataEntryWriterFactory, programClassPool, programJars, firstInputIndex, lastInputIndex + 1, nextIndex);
            firstInputIndex = nextIndex;
        }
    }

    private void writeOutput(DataEntryWriterFactory dataEntryWriterFactory, ClassPool programClassPool, ClassPath classPath, int fromInputIndex, int fromOutputIndex, int toOutputIndex) throws IOException {
        try {
            DataEntryCopier resourceCopier;
            DataEntryWriter writer = dataEntryWriterFactory.createDataEntryWriter(classPath, fromOutputIndex, toOutputIndex);
            if (this.configuration.addConfigurationDebugging) {
                writer = new ExtraDataEntryWriter("classmap.txt", writer, new ClassMapDataEntryWriter(programClassPool, writer));
                System.err.println("Warning: -addconfigurationdebugging is enabled; the resulting build will contain obfuscation information.");
                System.err.println("It should only be used for debugging purposes.");
            }
            DataEntryWriter resourceWriter = writer;
            if (this.configuration.obfuscate && this.configuration.adaptResourceFileNames != null) {
                resourceWriter = this.renameResourceFiles(programClassPool, resourceWriter);
            }
            DataEntryReader resourceRewriter = resourceCopier = new DataEntryCopier(resourceWriter);
            if ((this.configuration.shrink || this.configuration.optimize || this.configuration.obfuscate) && this.configuration.adaptResourceFileContents != null) {
                DataEntryReader adaptingContentWriter = resourceRewriter;
                if (this.configuration.obfuscate) {
                    adaptingContentWriter = this.adaptResourceFiles(programClassPool, resourceWriter);
                }
                resourceRewriter = new NameFilter(this.configuration.adaptResourceFileContents, adaptingContentWriter, resourceRewriter);
            }
            FilteredDataEntryReader reader = this.writeDirectories(programClassPool, resourceCopier, resourceRewriter);
            reader = new ClassFilter(new IdleRewriter(writer), (DataEntryReader)reader);
            new InputReader(this.configuration).readInput("  Copying resources from program ", classPath, fromInputIndex, fromOutputIndex, reader);
            writer.close();
        }
        catch (IOException ex) {
            throw (IOException)new IOException("Can't write [" + classPath.get(fromOutputIndex).getName() + "] (" + ex.getMessage() + ")").initCause(ex);
        }
    }

    private DataEntryWriter renameResourceFiles(ClassPool programClassPool, DataEntryWriter dataEntryWriter) {
        Map packagePrefixMap = OutputWriter.createPackagePrefixMap(programClassPool);
        return new NameFilteredDataEntryWriter(this.configuration.adaptResourceFileNames, (DataEntryWriter)new RenamedDataEntryWriter(programClassPool, packagePrefixMap, dataEntryWriter), dataEntryWriter);
    }

    private DataEntryReader adaptResourceFiles(ClassPool programClassPool, DataEntryWriter writer) {
        Charset charset = this.configuration.android ? Charset.forName("UTF-8") : Charset.defaultCharset();
        NameFilter dataEntryReader = new NameFilter("META-INF/MANIFEST.MF,META-INF/*.SF", (DataEntryReader)new ManifestRewriter(programClassPool, charset, writer), (DataEntryReader)new DataEntryRewriter(programClassPool, charset, writer));
        if (this.configuration.adaptKotlinMetadata) {
            dataEntryReader = new NameFilter("META-INF/*.kotlin_module", (DataEntryReader)new KotlinModuleRewriter(programClassPool, charset, writer), (DataEntryReader)dataEntryReader);
        }
        return dataEntryReader;
    }

    private DirectoryFilter writeDirectories(ClassPool programClassPool, DataEntryReader directoryCopier, DataEntryReader fileCopier) {
        NameFilter directoryRewriter = null;
        if (this.configuration.keepDirectories != null) {
            Map packagePrefixMap = OutputWriter.createPackagePrefixMap(programClassPool);
            directoryRewriter = new NameFilter(this.configuration.keepDirectories, (DataEntryReader)new RenamedDataEntryReader(packagePrefixMap, directoryCopier, directoryCopier));
        }
        return new DirectoryFilter(directoryRewriter, fileCopier);
    }

    private static Map createPackagePrefixMap(ClassPool classPool) {
        HashMap<String, String> packagePrefixMap = new HashMap<String, String>();
        Iterator iterator = classPool.classNames();
        while (iterator.hasNext()) {
            String className = (String)iterator.next();
            String packagePrefix = ClassUtil.internalPackagePrefix(className);
            String mappedNewPackagePrefix = (String)packagePrefixMap.get(packagePrefix);
            if (mappedNewPackagePrefix != null && mappedNewPackagePrefix.equals(packagePrefix)) continue;
            String newClassName = classPool.getClass(className).getName();
            String newPackagePrefix = ClassUtil.internalPackagePrefix(newClassName);
            packagePrefixMap.put(packagePrefix, newPackagePrefix);
        }
        return packagePrefixMap;
    }
}

