/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ConstantValueAttribute;
import proguard.classfile.attribute.DeprecatedAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExceptionsAttribute;
import proguard.classfile.attribute.ExtendedLineNumberInfo;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.LineNumberInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.MethodParametersAttribute;
import proguard.classfile.attribute.NestHostAttribute;
import proguard.classfile.attribute.NestMembersAttribute;
import proguard.classfile.attribute.ParameterInfo;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.SourceDebugExtensionAttribute;
import proguard.classfile.attribute.SourceDirAttribute;
import proguard.classfile.attribute.SourceFileAttribute;
import proguard.classfile.attribute.SyntheticAttribute;
import proguard.classfile.attribute.UnknownAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeInvisibleTypeAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.RuntimeVisibleTypeAnnotationsAttribute;
import proguard.classfile.attribute.annotation.TypeAnnotation;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.AnnotationAdder;
import proguard.classfile.editor.AttributesEditor;
import proguard.classfile.editor.CodeAttributeComposer;
import proguard.classfile.editor.ConstantAdder;
import proguard.classfile.editor.ElementValueAdder;
import proguard.classfile.editor.ExceptionAdder;
import proguard.classfile.editor.ExceptionInfoAdder;
import proguard.classfile.editor.InstructionAdder;
import proguard.classfile.editor.LineNumberInfoAdder;
import proguard.classfile.editor.LocalVariableInfoAdder;
import proguard.classfile.editor.LocalVariableTypeInfoAdder;
import proguard.classfile.editor.NestMemberAdder;
import proguard.classfile.editor.ParameterInfoAdder;
import proguard.classfile.editor.TypeAnnotationAdder;
import proguard.classfile.util.SimplifiedVisitor;

public class AttributeAdder
extends SimplifiedVisitor
implements AttributeVisitor {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final int[] EMPTY_INTS = new int[0];
    private static final Attribute[] EMPTY_ATTRIBUTES = new Attribute[0];
    private static final ExceptionInfo[] EMPTY_EXCEPTIONS = new ExceptionInfo[0];
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private final ProgramClass targetClass;
    private final ProgramMember targetMember;
    private final CodeAttribute targetCodeAttribute;
    private final boolean replaceAttributes;
    private final ConstantAdder constantAdder;
    private final AttributesEditor attributesEditor;

    public AttributeAdder(ProgramClass targetClass, boolean replaceAttributes) {
        this(targetClass, null, null, replaceAttributes);
    }

    public AttributeAdder(ProgramClass targetClass, ProgramMember targetMember, boolean replaceAttributes) {
        this(targetClass, targetMember, null, replaceAttributes);
    }

    public AttributeAdder(ProgramClass targetClass, ProgramMember targetMember, CodeAttribute targetCodeAttribute, boolean replaceAttributes) {
        this.targetClass = targetClass;
        this.targetMember = targetMember;
        this.targetCodeAttribute = targetCodeAttribute;
        this.replaceAttributes = replaceAttributes;
        this.constantAdder = new ConstantAdder(targetClass);
        this.attributesEditor = new AttributesEditor(targetClass, targetMember, targetCodeAttribute, replaceAttributes);
    }

    @Override
    public void visitUnknownAttribute(Clazz clazz, UnknownAttribute unknownAttribute) {
        UnknownAttribute newUnknownAttribute = new UnknownAttribute(this.constantAdder.addConstant(clazz, unknownAttribute.u2attributeNameIndex), unknownAttribute.u4attributeLength, unknownAttribute.info);
        newUnknownAttribute.setProcessingFlags(unknownAttribute.getProcessingFlags());
        this.attributesEditor.addAttribute(newUnknownAttribute);
    }

    @Override
    public void visitSourceDebugExtensionAttribute(Clazz clazz, SourceDebugExtensionAttribute sourceDebugExtensionAttribute) {
        SourceDebugExtensionAttribute newSourceDebugExtensionAttribute = new SourceDebugExtensionAttribute(this.constantAdder.addConstant(clazz, sourceDebugExtensionAttribute.u2attributeNameIndex), sourceDebugExtensionAttribute.u4attributeLength, sourceDebugExtensionAttribute.info);
        newSourceDebugExtensionAttribute.setProcessingFlags(sourceDebugExtensionAttribute.getProcessingFlags());
        this.attributesEditor.addAttribute(newSourceDebugExtensionAttribute);
    }

    @Override
    public void visitSourceFileAttribute(Clazz clazz, SourceFileAttribute sourceFileAttribute) {
        SourceFileAttribute newSourceFileAttribute = new SourceFileAttribute(this.constantAdder.addConstant(clazz, sourceFileAttribute.u2attributeNameIndex), this.constantAdder.addConstant(clazz, sourceFileAttribute.u2sourceFileIndex));
        newSourceFileAttribute.setProcessingFlags(sourceFileAttribute.getProcessingFlags());
        this.attributesEditor.addAttribute(newSourceFileAttribute);
    }

    @Override
    public void visitSourceDirAttribute(Clazz clazz, SourceDirAttribute sourceDirAttribute) {
        SourceDirAttribute newSourceDirAttribute = new SourceDirAttribute(this.constantAdder.addConstant(clazz, sourceDirAttribute.u2attributeNameIndex), this.constantAdder.addConstant(clazz, sourceDirAttribute.u2sourceDirIndex));
        newSourceDirAttribute.setProcessingFlags(sourceDirAttribute.getProcessingFlags());
        this.attributesEditor.addAttribute(newSourceDirAttribute);
    }

    @Override
    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        InnerClassesAttribute newInnerClassesAttribute = new InnerClassesAttribute(this.constantAdder.addConstant(clazz, innerClassesAttribute.u2attributeNameIndex), 0, null);
        newInnerClassesAttribute.setProcessingFlags(innerClassesAttribute.getProcessingFlags());
        this.attributesEditor.addAttribute(newInnerClassesAttribute);
    }

    @Override
    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        EnclosingMethodAttribute newEnclosingMethodAttribute = new EnclosingMethodAttribute(this.constantAdder.addConstant(clazz, enclosingMethodAttribute.u2attributeNameIndex), this.constantAdder.addConstant(clazz, enclosingMethodAttribute.u2classIndex), enclosingMethodAttribute.u2nameAndTypeIndex == 0 ? 0 : this.constantAdder.addConstant(clazz, enclosingMethodAttribute.u2nameAndTypeIndex));
        newEnclosingMethodAttribute.setProcessingFlags(enclosingMethodAttribute.getProcessingFlags());
        newEnclosingMethodAttribute.referencedClass = enclosingMethodAttribute.referencedClass;
        newEnclosingMethodAttribute.referencedMethod = enclosingMethodAttribute.referencedMethod;
        this.attributesEditor.addAttribute(newEnclosingMethodAttribute);
    }

    @Override
    public void visitNestHostAttribute(Clazz clazz, NestHostAttribute nestHostAttribute) {
        NestHostAttribute newNestHostAttribute = new NestHostAttribute(this.constantAdder.addConstant(clazz, nestHostAttribute.u2attributeNameIndex), this.constantAdder.addConstant(clazz, nestHostAttribute.u2hostClassIndex));
        this.attributesEditor.addAttribute(newNestHostAttribute);
    }

    @Override
    public void visitNestMembersAttribute(Clazz clazz, NestMembersAttribute nestMembersAttribute) {
        NestMembersAttribute newNestMembersAttribute = new NestMembersAttribute(this.constantAdder.addConstant(clazz, nestMembersAttribute.u2attributeNameIndex), 0, nestMembersAttribute.u2classesCount > 0 ? new int[nestMembersAttribute.u2classesCount] : EMPTY_INTS);
        nestMembersAttribute.memberClassConstantsAccept(this.targetClass, new NestMemberAdder(this.targetClass, newNestMembersAttribute));
        this.attributesEditor.addAttribute(newNestMembersAttribute);
    }

    @Override
    public void visitDeprecatedAttribute(Clazz clazz, DeprecatedAttribute deprecatedAttribute) {
        DeprecatedAttribute newDeprecatedAttribute = new DeprecatedAttribute(this.constantAdder.addConstant(clazz, deprecatedAttribute.u2attributeNameIndex));
        newDeprecatedAttribute.setProcessingFlags(deprecatedAttribute.getProcessingFlags());
        this.attributesEditor.addAttribute(newDeprecatedAttribute);
    }

    @Override
    public void visitSyntheticAttribute(Clazz clazz, SyntheticAttribute syntheticAttribute) {
        SyntheticAttribute newSyntheticAttribute = new SyntheticAttribute(this.constantAdder.addConstant(clazz, syntheticAttribute.u2attributeNameIndex));
        newSyntheticAttribute.setProcessingFlags(syntheticAttribute.getProcessingFlags());
        this.attributesEditor.addAttribute(newSyntheticAttribute);
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        SignatureAttribute newSignatureAttribute = new SignatureAttribute(this.constantAdder.addConstant(clazz, signatureAttribute.u2attributeNameIndex), this.constantAdder.addConstant(clazz, signatureAttribute.u2signatureIndex));
        newSignatureAttribute.setProcessingFlags(signatureAttribute.getProcessingFlags());
        newSignatureAttribute.referencedClasses = signatureAttribute.referencedClasses;
        this.attributesEditor.addAttribute(newSignatureAttribute);
    }

    @Override
    public void visitConstantValueAttribute(Clazz clazz, Field field, ConstantValueAttribute constantValueAttribute) {
        ConstantValueAttribute newConstantValueAttribute = new ConstantValueAttribute(this.constantAdder.addConstant(clazz, constantValueAttribute.u2attributeNameIndex), this.constantAdder.addConstant(clazz, constantValueAttribute.u2constantValueIndex));
        newConstantValueAttribute.setProcessingFlags(constantValueAttribute.getProcessingFlags());
        this.attributesEditor.addAttribute(newConstantValueAttribute);
    }

    @Override
    public void visitMethodParametersAttribute(Clazz clazz, Method method, MethodParametersAttribute methodParametersAttribute) {
        MethodParametersAttribute newMethodParametersAttribute = new MethodParametersAttribute(this.constantAdder.addConstant(clazz, methodParametersAttribute.u2attributeNameIndex), methodParametersAttribute.u1parametersCount, new ParameterInfo[methodParametersAttribute.u1parametersCount]);
        methodParametersAttribute.parametersAccept(clazz, method, new ParameterInfoAdder(this.targetClass, newMethodParametersAttribute));
        newMethodParametersAttribute.setProcessingFlags(methodParametersAttribute.getProcessingFlags());
        this.attributesEditor.addAttribute(newMethodParametersAttribute);
    }

    @Override
    public void visitExceptionsAttribute(Clazz clazz, Method method, ExceptionsAttribute exceptionsAttribute) {
        ExceptionsAttribute newExceptionsAttribute = new ExceptionsAttribute(this.constantAdder.addConstant(clazz, exceptionsAttribute.u2attributeNameIndex), 0, exceptionsAttribute.u2exceptionIndexTableLength > 0 ? new int[exceptionsAttribute.u2exceptionIndexTableLength] : EMPTY_INTS);
        exceptionsAttribute.exceptionEntriesAccept((ProgramClass)clazz, new ExceptionAdder(this.targetClass, newExceptionsAttribute));
        newExceptionsAttribute.setProcessingFlags(exceptionsAttribute.getProcessingFlags());
        this.attributesEditor.addAttribute(newExceptionsAttribute);
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        CodeAttribute newCodeAttribute = new CodeAttribute(this.constantAdder.addConstant(clazz, codeAttribute.u2attributeNameIndex), codeAttribute.u2maxStack, codeAttribute.u2maxLocals, 0, EMPTY_BYTES, 0, codeAttribute.u2exceptionTableLength > 0 ? new ExceptionInfo[codeAttribute.u2exceptionTableLength] : EMPTY_EXCEPTIONS, 0, codeAttribute.u2attributesCount > 0 ? new Attribute[codeAttribute.u2attributesCount] : EMPTY_ATTRIBUTES);
        newCodeAttribute.setProcessingFlags(codeAttribute.getProcessingFlags());
        CodeAttributeComposer codeAttributeComposer = new CodeAttributeComposer();
        codeAttributeComposer.beginCodeFragment(codeAttribute.u4codeLength + 32);
        codeAttribute.instructionsAccept(clazz, method, new InstructionAdder(this.targetClass, codeAttributeComposer));
        codeAttributeComposer.appendLabel(codeAttribute.u4codeLength);
        codeAttribute.exceptionsAccept(clazz, method, new ExceptionInfoAdder(this.targetClass, codeAttributeComposer));
        if (codeAttribute.getAttribute(clazz, "LineNumberTable") == null) {
            String source = clazz.getName() + '.' + method.getName(clazz) + method.getDescriptor(clazz) + ":0:0";
            codeAttributeComposer.insertLineNumber(new ExtendedLineNumberInfo(0, 0, source));
        }
        codeAttributeComposer.endCodeFragment();
        codeAttribute.attributesAccept(clazz, method, new AttributeAdder(this.targetClass, this.targetMember, newCodeAttribute, this.replaceAttributes));
        codeAttributeComposer.visitCodeAttribute(this.targetClass, (Method)((Object)this.targetMember), newCodeAttribute);
        this.attributesEditor.addAttribute(newCodeAttribute);
    }

    @Override
    public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
    }

    @Override
    public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
    }

    @Override
    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        LineNumberTableAttribute newLineNumberTableAttribute = new LineNumberTableAttribute(this.constantAdder.addConstant(clazz, lineNumberTableAttribute.u2attributeNameIndex), 0, new LineNumberInfo[lineNumberTableAttribute.u2lineNumberTableLength]);
        lineNumberTableAttribute.accept(clazz, method, codeAttribute, new LineNumberInfoAdder(newLineNumberTableAttribute));
        newLineNumberTableAttribute.setProcessingFlags(lineNumberTableAttribute.getProcessingFlags());
        this.attributesEditor.addAttribute(newLineNumberTableAttribute);
    }

    @Override
    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        LocalVariableTableAttribute newLocalVariableTableAttribute = new LocalVariableTableAttribute(this.constantAdder.addConstant(clazz, localVariableTableAttribute.u2attributeNameIndex), 0, new LocalVariableInfo[localVariableTableAttribute.u2localVariableTableLength]);
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, new LocalVariableInfoAdder(this.targetClass, newLocalVariableTableAttribute));
        newLocalVariableTableAttribute.setProcessingFlags(localVariableTableAttribute.getProcessingFlags());
        this.attributesEditor.addAttribute(newLocalVariableTableAttribute);
    }

    @Override
    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        LocalVariableTypeTableAttribute newLocalVariableTypeTableAttribute = new LocalVariableTypeTableAttribute(this.constantAdder.addConstant(clazz, localVariableTypeTableAttribute.u2attributeNameIndex), 0, new LocalVariableTypeInfo[localVariableTypeTableAttribute.u2localVariableTypeTableLength]);
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, new LocalVariableTypeInfoAdder(this.targetClass, newLocalVariableTypeTableAttribute));
        newLocalVariableTypeTableAttribute.setProcessingFlags(localVariableTypeTableAttribute.getProcessingFlags());
        this.attributesEditor.addAttribute(newLocalVariableTypeTableAttribute);
    }

    @Override
    public void visitRuntimeVisibleAnnotationsAttribute(Clazz clazz, RuntimeVisibleAnnotationsAttribute runtimeVisibleAnnotationsAttribute) {
        RuntimeVisibleAnnotationsAttribute newAnnotationsAttribute = new RuntimeVisibleAnnotationsAttribute(this.constantAdder.addConstant(clazz, runtimeVisibleAnnotationsAttribute.u2attributeNameIndex), 0, new Annotation[runtimeVisibleAnnotationsAttribute.u2annotationsCount]);
        runtimeVisibleAnnotationsAttribute.annotationsAccept(clazz, new AnnotationAdder(this.targetClass, newAnnotationsAttribute));
        newAnnotationsAttribute.setProcessingFlags(runtimeVisibleAnnotationsAttribute.getProcessingFlags());
        this.attributesEditor.addAttribute(newAnnotationsAttribute);
    }

    @Override
    public void visitRuntimeInvisibleAnnotationsAttribute(Clazz clazz, RuntimeInvisibleAnnotationsAttribute runtimeInvisibleAnnotationsAttribute) {
        RuntimeInvisibleAnnotationsAttribute newAnnotationsAttribute = new RuntimeInvisibleAnnotationsAttribute(this.constantAdder.addConstant(clazz, runtimeInvisibleAnnotationsAttribute.u2attributeNameIndex), 0, new Annotation[runtimeInvisibleAnnotationsAttribute.u2annotationsCount]);
        runtimeInvisibleAnnotationsAttribute.annotationsAccept(clazz, new AnnotationAdder(this.targetClass, newAnnotationsAttribute));
        newAnnotationsAttribute.setProcessingFlags(runtimeInvisibleAnnotationsAttribute.getProcessingFlags());
        this.attributesEditor.addAttribute(newAnnotationsAttribute);
    }

    @Override
    public void visitRuntimeVisibleParameterAnnotationsAttribute(Clazz clazz, Method method, RuntimeVisibleParameterAnnotationsAttribute runtimeVisibleParameterAnnotationsAttribute) {
        Annotation[][] parameterAnnotations = new Annotation[runtimeVisibleParameterAnnotationsAttribute.u1parametersCount][];
        Arrays.fill((Object[])parameterAnnotations, EMPTY_ANNOTATIONS);
        RuntimeVisibleParameterAnnotationsAttribute newParameterAnnotationsAttribute = new RuntimeVisibleParameterAnnotationsAttribute(this.constantAdder.addConstant(clazz, runtimeVisibleParameterAnnotationsAttribute.u2attributeNameIndex), 0, new int[runtimeVisibleParameterAnnotationsAttribute.u1parametersCount], parameterAnnotations);
        runtimeVisibleParameterAnnotationsAttribute.annotationsAccept(clazz, method, new AnnotationAdder(this.targetClass, newParameterAnnotationsAttribute));
        newParameterAnnotationsAttribute.setProcessingFlags(runtimeVisibleParameterAnnotationsAttribute.getProcessingFlags());
        this.attributesEditor.addAttribute(newParameterAnnotationsAttribute);
    }

    @Override
    public void visitRuntimeInvisibleParameterAnnotationsAttribute(Clazz clazz, Method method, RuntimeInvisibleParameterAnnotationsAttribute runtimeInvisibleParameterAnnotationsAttribute) {
        Annotation[][] parameterAnnotations = new Annotation[runtimeInvisibleParameterAnnotationsAttribute.u1parametersCount][];
        Arrays.fill((Object[])parameterAnnotations, EMPTY_ANNOTATIONS);
        RuntimeInvisibleParameterAnnotationsAttribute newParameterAnnotationsAttribute = new RuntimeInvisibleParameterAnnotationsAttribute(this.constantAdder.addConstant(clazz, runtimeInvisibleParameterAnnotationsAttribute.u2attributeNameIndex), 0, new int[runtimeInvisibleParameterAnnotationsAttribute.u1parametersCount], parameterAnnotations);
        runtimeInvisibleParameterAnnotationsAttribute.annotationsAccept(clazz, method, new AnnotationAdder(this.targetClass, newParameterAnnotationsAttribute));
        newParameterAnnotationsAttribute.setProcessingFlags(runtimeInvisibleParameterAnnotationsAttribute.getProcessingFlags());
        this.attributesEditor.addAttribute(newParameterAnnotationsAttribute);
    }

    @Override
    public void visitRuntimeVisibleTypeAnnotationsAttribute(Clazz clazz, RuntimeVisibleTypeAnnotationsAttribute runtimeVisibleTypeAnnotationsAttribute) {
        RuntimeVisibleTypeAnnotationsAttribute newTypeAnnotationsAttribute = new RuntimeVisibleTypeAnnotationsAttribute(this.constantAdder.addConstant(clazz, runtimeVisibleTypeAnnotationsAttribute.u2attributeNameIndex), 0, new TypeAnnotation[runtimeVisibleTypeAnnotationsAttribute.u2annotationsCount]);
        runtimeVisibleTypeAnnotationsAttribute.typeAnnotationsAccept(clazz, new TypeAnnotationAdder(this.targetClass, newTypeAnnotationsAttribute));
        newTypeAnnotationsAttribute.setProcessingFlags(runtimeVisibleTypeAnnotationsAttribute.getProcessingFlags());
        this.attributesEditor.addAttribute(newTypeAnnotationsAttribute);
    }

    @Override
    public void visitRuntimeInvisibleTypeAnnotationsAttribute(Clazz clazz, RuntimeInvisibleTypeAnnotationsAttribute runtimeInvisibleTypeAnnotationsAttribute) {
        RuntimeInvisibleTypeAnnotationsAttribute newTypeAnnotationsAttribute = new RuntimeInvisibleTypeAnnotationsAttribute(this.constantAdder.addConstant(clazz, runtimeInvisibleTypeAnnotationsAttribute.u2attributeNameIndex), 0, new TypeAnnotation[runtimeInvisibleTypeAnnotationsAttribute.u2annotationsCount]);
        runtimeInvisibleTypeAnnotationsAttribute.typeAnnotationsAccept(clazz, new TypeAnnotationAdder(this.targetClass, newTypeAnnotationsAttribute));
        newTypeAnnotationsAttribute.setProcessingFlags(runtimeInvisibleTypeAnnotationsAttribute.getProcessingFlags());
        this.attributesEditor.addAttribute(newTypeAnnotationsAttribute);
    }

    @Override
    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        AnnotationDefaultAttribute newAnnotationDefaultAttribute = new AnnotationDefaultAttribute(this.constantAdder.addConstant(clazz, annotationDefaultAttribute.u2attributeNameIndex), null);
        annotationDefaultAttribute.defaultValueAccept(clazz, new ElementValueAdder(this.targetClass, newAnnotationDefaultAttribute, false));
        newAnnotationDefaultAttribute.setProcessingFlags(annotationDefaultAttribute.getProcessingFlags());
        this.attributesEditor.addAttribute(newAnnotationDefaultAttribute);
    }
}

