/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin;

import java.util.List;
import kotlinx.metadata.KmVariance;
import proguard.classfile.Clazz;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinMetadataAnnotation;
import proguard.classfile.kotlin.KotlinTypeAliasMetadata;
import proguard.classfile.kotlin.KotlinTypeParameterMetadata;
import proguard.classfile.kotlin.flags.KotlinTypeFlags;
import proguard.classfile.kotlin.visitors.KotlinAnnotationVisitor;
import proguard.classfile.kotlin.visitors.KotlinTypeVisitor;
import proguard.util.SimpleVisitorAccepter;

public class KotlinTypeMetadata
extends SimpleVisitorAccepter
implements VisitorAccepter {
    public KmVariance variance;
    public List<KotlinTypeMetadata> typeArguments;
    public KotlinTypeMetadata abbreviation;
    public String className;
    public Clazz referencedClass;
    public int typeParamID = -1;
    public KotlinTypeParameterMetadata referencedParameter;
    public String aliasName;
    public KotlinTypeAliasMetadata referencedTypeAlias;
    public KotlinTypeMetadata outerClassType;
    public String flexibilityID;
    public List<KotlinTypeMetadata> upperBounds;
    public boolean isRaw = false;
    public List<KotlinMetadataAnnotation> annotations;
    public KotlinTypeFlags flags;
    private static final KotlinTypeMetadata STAR_PROJECTION = new KotlinStarProjectionMetadata();

    public KotlinTypeMetadata(int flags) {
        this(flags, null);
    }

    public KotlinTypeMetadata(int flags, KmVariance variance) {
        this.variance = variance;
        this.flags = new KotlinTypeFlags(flags);
    }

    public void accept(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinTypeVisitor kotlinTypeVisitor) {
        kotlinTypeVisitor.visitSuperType(clazz, kotlinClassKindMetadata, this);
    }

    public void upperBoundsAccept(Clazz clazz, KotlinTypeVisitor kotlinTypeVisitor) {
        for (KotlinTypeMetadata upperBound : this.upperBounds) {
            upperBound.acceptAsUpperBound(clazz, this, kotlinTypeVisitor);
        }
    }

    public void typeArgumentsAccept(Clazz clazz, KotlinTypeVisitor kotlinTypeVisitor) {
        for (KotlinTypeMetadata typeArgument : this.typeArguments) {
            if (typeArgument.isStarProjection()) {
                kotlinTypeVisitor.visitStarProjection(clazz, this);
                continue;
            }
            kotlinTypeVisitor.visitTypeArgument(clazz, this, typeArgument);
        }
    }

    public void outerClassAccept(Clazz clazz, KotlinTypeVisitor kotlinTypeVisitor) {
        if (this.outerClassType != null) {
            kotlinTypeVisitor.visitOuterClass(clazz, this, this.outerClassType);
        }
    }

    private void acceptAsUpperBound(Clazz clazz, KotlinTypeMetadata boundedType, KotlinTypeVisitor kotlinTypeVisitor) {
        kotlinTypeVisitor.visitTypeUpperBound(clazz, boundedType, this);
    }

    public void abbreviationAccept(Clazz clazz, KotlinTypeVisitor kotlinTypeVisitor) {
        if (this.abbreviation != null) {
            this.abbreviation.acceptAsAbbreviation(clazz, this, kotlinTypeVisitor);
        }
    }

    private void acceptAsAbbreviation(Clazz clazz, KotlinTypeMetadata abbreviatedType, KotlinTypeVisitor kotlinTypeVisitor) {
        kotlinTypeVisitor.visitAbbreviation(clazz, abbreviatedType, this);
    }

    public void accept(Clazz clazz, KotlinTypeParameterMetadata boundedTypeParameter, KotlinTypeVisitor kotlinTypeVisitor) {
        kotlinTypeVisitor.visitParameterUpperBound(clazz, boundedTypeParameter, this);
    }

    public void annotationsAccept(Clazz clazz, KotlinAnnotationVisitor kotlinAnnotationVisitor) {
        for (KotlinMetadataAnnotation annotation : this.annotations) {
            kotlinAnnotationVisitor.visitTypeAnnotation(clazz, this, annotation);
        }
    }

    public String toString() {
        return "Kotlin type";
    }

    static KotlinTypeMetadata starProjection() {
        return STAR_PROJECTION;
    }

    protected boolean isStarProjection() {
        return false;
    }

    private static class KotlinStarProjectionMetadata
    extends KotlinTypeMetadata {
        KotlinStarProjectionMetadata() {
            super(0);
        }

        @Override
        protected boolean isStarProjection() {
            return true;
        }
    }
}

