/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin.asserter;

import java.util.function.Consumer;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.asserter.InvalidReferenceError;
import proguard.classfile.kotlin.asserter.MissingReferenceError;
import proguard.classfile.kotlin.asserter.Reporter;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class AssertUtil {
    private final String parentElement;
    private final Clazz clazz;
    private final KotlinMetadata kotlinMetadata;
    private final Reporter reporter;

    public AssertUtil(String parentElement, Clazz clazz, KotlinMetadata kotlinMetadata, Reporter reporter) {
        this.parentElement = parentElement;
        this.clazz = clazz;
        this.kotlinMetadata = kotlinMetadata;
        this.reporter = reporter;
    }

    public Consumer<Object> reportIfNullReference(String checkedElement) {
        return metadataElement -> this.reportIfNullReference(metadataElement, checkedElement);
    }

    public Consumer<Field> reportIfFieldDangling(Clazz checkedClass, String checkedElement) {
        return field -> this.reportIfFieldDangling(checkedClass, (Field)field, checkedElement);
    }

    public void reportIfNullReference(Object checkedElement, String checkedElementName) {
        if (checkedElement == null) {
            this.reporter.report(new MissingReferenceError(this.parentElement, checkedElementName, this.clazz, this.kotlinMetadata));
        }
    }

    public void reportIfFieldDangling(Clazz checkedClass, Field field, String checkedElementName) {
        ExactMemberMatcher match = new ExactMemberMatcher(field);
        checkedClass.accept(new AllFieldVisitor(match));
        if (!match.memberMatched) {
            this.reporter.report(new InvalidReferenceError(this.parentElement, checkedElementName, this.clazz, this.kotlinMetadata));
        }
    }

    public void reportIfMethodDangling(Clazz checkedClass, Method method, String checkedElementName) {
        ExactMemberMatcher match = new ExactMemberMatcher(method);
        checkedClass.accept(new AllMethodVisitor(match));
        if (!match.memberMatched) {
            this.reporter.report(new InvalidReferenceError(this.parentElement, checkedElementName, this.clazz, this.kotlinMetadata));
        }
    }

    private static class ExactMemberMatcher
    extends SimplifiedVisitor
    implements MemberVisitor {
        private final Member memberToMatch;
        boolean memberMatched;

        ExactMemberMatcher(Member memberToMatch) {
            this.memberToMatch = memberToMatch;
        }

        @Override
        public void visitAnyMember(Clazz clazz, Member member) {
            if (member == this.memberToMatch) {
                this.memberMatched = true;
            }
        }
    }
}

