/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin.asserter;

import java.util.Arrays;
import java.util.List;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.asserter.KotlinMetadataConstraint;
import proguard.classfile.kotlin.asserter.KotlinMetadataError;
import proguard.classfile.kotlin.asserter.Reporter;
import proguard.classfile.kotlin.asserter.constraint.ClassIntegrity;
import proguard.classfile.kotlin.asserter.constraint.ConstructorIntegrity;
import proguard.classfile.kotlin.asserter.constraint.DeclarationContainerIntegrity;
import proguard.classfile.kotlin.asserter.constraint.FunctionIntegrity;
import proguard.classfile.kotlin.asserter.constraint.KmAnnotationIntegrity;
import proguard.classfile.kotlin.asserter.constraint.PropertyIntegrity;
import proguard.classfile.kotlin.asserter.constraint.SyntheticClassIntegrity;
import proguard.classfile.kotlin.asserter.constraint.TypeIntegrity;
import proguard.classfile.kotlin.asserter.constraint.ValueParameterIntegrity;
import proguard.classfile.kotlin.visitors.KotlinMetadataRemover;
import proguard.classfile.kotlin.visitors.KotlinMetadataVisitor;
import proguard.classfile.util.WarningPrinter;

public class KotlinMetadataAsserter
implements KotlinMetadataVisitor {
    public static final List<KotlinMetadataConstraint> DEFAULT_CONSTRAINTS = Arrays.asList(FunctionIntegrity.constraint(), ConstructorIntegrity.constraint(), PropertyIntegrity.constraint(), ClassIntegrity.constraint(), TypeIntegrity.constraint(), KmAnnotationIntegrity.constraint(), ValueParameterIntegrity.constraint(), SyntheticClassIntegrity.constraint(), DeclarationContainerIntegrity.constraint());
    private final Iterable<? extends KotlinMetadataConstraint> constraints;
    private final Reporter reporter;
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final WarningPrinter warningPrinter;

    public KotlinMetadataAsserter(ClassPool programClassPool, ClassPool libraryClassPool, final WarningPrinter warningPrinter) {
        this(DEFAULT_CONSTRAINTS, new Reporter(){
            private int count = 0;

            @Override
            public void report(KotlinMetadataError error) {
                ++this.count;
                warningPrinter.print(error.clazz.getName(), "Warning: " + error.toString());
            }

            @Override
            public void resetCounter() {
                this.count = 0;
            }

            @Override
            public int getCount() {
                return this.count;
            }
        }, programClassPool, libraryClassPool, warningPrinter);
    }

    public KotlinMetadataAsserter(Iterable<? extends KotlinMetadataConstraint> constraints, Reporter reporter, ClassPool programClassPool, ClassPool libraryClassPool, WarningPrinter warningPrinter) {
        this.constraints = constraints;
        this.reporter = reporter;
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.warningPrinter = warningPrinter;
    }

    @Override
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        this.reporter.resetCounter();
        for (KotlinMetadataConstraint kotlinMetadataConstraint : this.constraints) {
            kotlinMetadataConstraint.check(this.reporter, clazz, kotlinMetadata, this.programClassPool, this.libraryClassPool);
        }
        if (this.reporter.getCount() > 0) {
            this.warningPrinter.print(clazz.getName(), "  Not processing the metadata for class " + clazz.getName());
            clazz.accept(new KotlinMetadataRemover());
        }
    }
}

